/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.runtime;

import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.qing.data.model.designtime.Property;
import com.kingdee.bos.qing.data.model.runtime.CompareFilter;
import com.kingdee.bos.qing.data.model.runtime.EasPrimaryDataValueHandleDelegate;
import com.kingdee.bos.qing.data.model.runtime.IMetaRuntimeFilter;
import com.kingdee.bos.qing.data.model.runtime.RuntimeEntity;
import com.kingdee.bos.qing.data.model.runtime.RuntimeProperty;
import com.kingdee.bos.qing.data.model.runtime.compare.entityfilter.EntityFilterPair;
import com.kingdee.bos.qing.data.model.runtime.compare.entityfilter.IEntityFilter;
import com.kingdee.bos.qing.data.model.runtime.compare.entityfilter.SimpleEntityFilter;
import com.kingdee.bos.qing.data.util.valueconvert.PrimaryDataValueHandlerDelegate;
import java.util.List;

public class MetaCompareFilter
extends CompareFilter
implements IMetaRuntimeFilter {
    private List<FilterItemInfo> listItems;

    @Override
    public String toSqlWhere(RuntimeEntity runtimeEntity) {
        if (this.isInvalid()) {
            return null;
        }
        IEntityFilter entityFilter = this.getComparatorRuntimeApiSupplier().getFilterConstructor();
        return this.buildSqlWhere(entityFilter);
    }

    private String buildSqlWhere(IEntityFilter entityFilter) {
        if (entityFilter instanceof SimpleEntityFilter) {
            String where = "#" + this.listItems.size();
            FilterItemInfo filterItem = this.createFilterItem((SimpleEntityFilter)entityFilter);
            this.listItems.add(filterItem);
            return where;
        }
        EntityFilterPair filterPair = (EntityFilterPair)entityFilter;
        StringBuilder sb = new StringBuilder();
        String leftWhere = this.buildSqlWhere(filterPair.getLeft());
        String rightWhere = this.buildSqlWhere(filterPair.getRight());
        sb.append(" ( ").append(leftWhere).append(" ").append(filterPair.getOp()).append(" ").append(rightWhere).append(" ) ");
        return sb.toString();
    }

    private FilterItemInfo createFilterItem(SimpleEntityFilter entityFilter) {
        String filterName = entityFilter.getFilterName();
        Object filterValue = entityFilter.getComparedValue();
        CompareType compareType = this.adaptToEasCompare(entityFilter.getFilterString());
        return new FilterItemInfo(filterName, filterValue, compareType);
    }

    public boolean isUnPushdownableFilter() {
        Property prop = this.getRuntimeProperty().getProperty();
        Boolean isFlexField = (Boolean)prop.getExtensionValue("isFlexField", Boolean.class);
        return isFlexField != null && isFlexField != false || super.isUnPushdownableFilter();
    }

    private CompareType adaptToEasCompare(String filterString) {
        if (filterString.equals("is null")) {
            return CompareType.IS;
        }
        if (filterString.equals("is not null")) {
            return CompareType.ISNOT;
        }
        if (filterString.equals("!=")) {
            return CompareType.NOTEQUALS;
        }
        return CompareType.getEnum((String)filterString);
    }

    public SimpleEntityFilter getEmptyStrFilter() {
        return new SimpleEntityFilter(this.getFilterName(), "is", (Object)"EMPTY");
    }

    public SimpleEntityFilter getNotEmptyStrFilter() {
        return new SimpleEntityFilter(this.getFilterName(), "is not", (Object)"EMPTY");
    }

    public PrimaryDataValueHandlerDelegate getPrimaryDataValueHandler() {
        return new EasPrimaryDataValueHandleDelegate(this._dataType, this.getCompareOp());
    }

    public String getFilterName() {
        RuntimeProperty runtimeProperty = this.getRuntimeProperty();
        String fkDisplayQueryPropName = (String)runtimeProperty.getRuntimeValue("foreignDisplayQueryPropName", String.class);
        if (fkDisplayQueryPropName != null) {
            return fkDisplayQueryPropName;
        }
        return (String)runtimeProperty.getRuntimeValue("realQueryPropName", String.class);
    }

    @Override
    public List<FilterItemInfo> getFilterItemInfos() {
        return this.listItems;
    }

    @Override
    public void setFilterItemInfos(List<FilterItemInfo> itemInfos) {
        this.listItems = itemInfos;
    }
}

