/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.exporter.qhf;

import com.kingdee.bos.qing.common.cache.AbstractDataSource;
import com.kingdee.bos.qing.common.cache.SingleFileDataSource;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.session.IQingSession;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.imexport.exporter.exception.ExportException;
import com.kingdee.bos.qing.imexport.exporter.exception.ExportQsException;
import com.kingdee.bos.qing.imexport.exporter.qhf.domain.scene.AbstractSchemaObjsQHFExporter;
import com.kingdee.bos.qing.imexport.model.PackageMeta;
import com.kingdee.bos.qing.imexport.model.embeddeddata.EmbeddedDataInfo;
import com.kingdee.bos.qing.imexport.model.embeddeddata.EmbeddedDataObject;
import com.kingdee.bos.qing.imexport.model.embeddeddata.EmbeddedDataQsInfo;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.IntegratedHelperImpl;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public class EmbeddedLongerSquareQHFExporter
extends AbstractSchemaObjsQHFExporter {
    public EmbeddedLongerSquareQHFExporter(QingContext qingContext, IDBExcuter dbExcuter, ITransactionManagement tx) {
        super(qingContext, dbExcuter, tx);
    }

    public void export(Map<String, String> params, PackageMeta meta) throws ExportException, SQLException, AbstractQingException, IOException {
        String tag = params.get("tag");
        String bizTag = params.get("bizTag");
        String ctrlKey = params.get("ctrlKey");
        String id = params.get("id");
        EmbeddedDataObject embeddedDataObj = new EmbeddedDataObject();
        EmbeddedDataInfo embeddedDataInfo = new EmbeddedDataInfo();
        embeddedDataInfo.setId(id);
        embeddedDataInfo.setBizTag(bizTag);
        embeddedDataInfo.put((Object)"ctrlKey", (Object)ctrlKey);
        embeddedDataInfo.setName(IntegratedHelperImpl.getEntityDisplayName(bizTag));
        String filterContent = QingSessionUtil.get((String)("qing_filter_" + tag));
        embeddedDataInfo.setFilterContent(filterContent);
        embeddedDataObj.setEmbeddedDataInfo(embeddedDataInfo);
        List extraSchemaObjects = this.getExtraSchemaObjects(params, tag, meta);
        List schemaObjs = this.getDBSchema(bizTag, meta);
        schemaObjs.addAll(extraSchemaObjects);
        embeddedDataObj.setSchemaObjs(schemaObjs);
        IQingSession qingSession = QingSessionUtil.getQingSessionImpl();
        AbstractDataSource dataSource = (AbstractDataSource)qingSession.getCache(AbstractDataSource.getCacheKey((String)tag), AbstractDataSource.class);
        if (dataSource == null) {
            throw new ExportQsException();
        }
        SingleFileDataSource singleFileDataSource = (SingleFileDataSource)dataSource;
        String qsFileName = singleFileDataSource.getFileName();
        EmbeddedDataQsInfo embeddedDataQsInfo = new EmbeddedDataQsInfo();
        embeddedDataQsInfo.setExtractTimestamp(singleFileDataSource.getExtractDataTime());
        embeddedDataQsInfo.setOriginalCreatorId(singleFileDataSource.getOriginalCreatorId());
        embeddedDataQsInfo.setOriginalCreatorName(IntegratedHelper.getUserName((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (String)singleFileDataSource.getOriginalCreatorId()));
        embeddedDataQsInfo.setQsFileName(qsFileName);
        embeddedDataQsInfo.setExtractDataTraceSpans(singleFileDataSource.getExtractDataTraceSpans());
        embeddedDataObj.setEmbeddedDataQsInfo(embeddedDataQsInfo);
        meta.getEmbeddedDataObjs().add(embeddedDataObj);
    }
}

