/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.exporter.qhf.domain.scene.publish.source;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.imexport.exporter.qhf.EmbeddedLongerSquareQHFExporter;
import com.kingdee.bos.qing.imexport.exporter.qhf.domain.scene.publish.source.AbstractPublishSourceQHFExporter;
import com.kingdee.bos.qing.imexport.model.PackageMeta;
import com.kingdee.bos.qing.imexport.model.embeddeddata.EmbeddedDataInfo;
import com.kingdee.bos.qing.imexport.model.embeddeddata.EmbeddedDataQsInfo;
import com.kingdee.bos.qing.imexport.model.publish.AbstractCarryDataInfo;
import com.kingdee.bos.qing.imexport.model.publish.AbstractPublishObject;
import com.kingdee.bos.qing.imexport.model.publish.LongerSquarePublishObject;
import com.kingdee.bos.qing.imexport.model.publish.embedded.EmbeddedCarryDataInfo;
import com.kingdee.bos.qing.publish.dao.BillManagerDao;
import com.kingdee.bos.qing.publish.model.BillModel;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.IntegratedHelperImpl;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import org.jdom2.JDOMException;

public class PublishSourceEmbeddedQHFExporter
extends AbstractPublishSourceQHFExporter {
    private BillManagerDao billManagerDao;

    private BillManagerDao getBillManagerDao() {
        if (this.billManagerDao == null) {
            this.billManagerDao = new BillManagerDao(this.dbExcuter);
        }
        return this.billManagerDao;
    }

    public PublishSourceEmbeddedQHFExporter(QingContext qingContext, IDBExcuter dbExcuter, ITransactionManagement tx) {
        super(qingContext, dbExcuter, tx);
    }

    public void export(String tag, AbstractPublishObject publishObj, PackageMeta meta) throws AbstractQingException, SQLException, IOException, JDOMException {
        if (publishObj.getPublishPO().isCarryData()) {
            this.loadCarryDataInfo(publishObj);
        } else {
            BillModel billModel = this.getBillManagerDao().findBillByPublishId(publishObj.getPublishPO().getId());
            String ctrKey = billModel.getCtrKey();
            String bizTag = publishObj.getPublishPO().getTagId();
            String publishId = publishObj.getPublishPO().getId();
            HashMap<String, String> params = new HashMap<String, String>(16);
            params.put("tag", tag);
            params.put("ctrKey", ctrKey);
            params.put("bizTag", bizTag);
            params.put("id", publishId);
            EmbeddedLongerSquareQHFExporter exporter = new EmbeddedLongerSquareQHFExporter(this.qingContext, this.dbExcuter, this.tx);
            exporter.export(params, meta);
        }
    }

    public AbstractPublishObject getPublishObj(PublishPO publishPO) {
        return new LongerSquarePublishObject();
    }

    private void loadCarryDataInfo(AbstractPublishObject publishObj) throws AbstractQingIntegratedException, SQLException {
        PublishPO publishPO = publishObj.getPublishPO();
        String publishId = publishPO.getId();
        BillModel billModel = this.getBillManagerDao().findBillByPublishId(publishId);
        if (billModel != null) {
            EmbeddedCarryDataInfo embededCarryDataInfo = new EmbeddedCarryDataInfo();
            EmbeddedDataInfo embeddedDataInfo = new EmbeddedDataInfo();
            embeddedDataInfo.setId(publishId);
            embeddedDataInfo.setBizTag(publishPO.getTagId());
            embeddedDataInfo.put((Object)"ctrlKey", (Object)billModel.getCtrKey());
            embeddedDataInfo.setName(IntegratedHelperImpl.getEntityDisplayName(publishPO.getTagId()));
            byte[] filterContent = this.getBillManagerDao().loadFilterContent(publishId);
            embeddedDataInfo.setFilterContent(new String(filterContent));
            embededCarryDataInfo.setEmbeddedDataInfo(embeddedDataInfo);
            EmbeddedDataQsInfo embeddedDataQsInfo = new EmbeddedDataQsInfo();
            embeddedDataQsInfo.setExtractTimestamp(billModel.getExtractDataTime().getTime());
            embeddedDataQsInfo.setOriginalCreatorId(publishPO.getCreatorId());
            embeddedDataQsInfo.setOriginalCreatorName(IntegratedHelper.getUserName((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (String)publishPO.getCreatorId()));
            embeddedDataQsInfo.setQsFileName(billModel.getQsFileName());
            embededCarryDataInfo.setEmbeddedDataQsInfo(embeddedDataQsInfo);
            publishObj.setCarryDataInfo((AbstractCarryDataInfo)embededCarryDataInfo);
        }
    }
}

