/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.preparedata;

import com.kingdee.bos.qing.behavior.BehaviorAssociate;
import com.kingdee.bos.qing.behavior.impl.BehaviorService;
import com.kingdee.bos.qing.bill.preparedata.BillPrepareDataContext;
import com.kingdee.bos.qing.common.cache.AbstractDataSource;
import com.kingdee.bos.qing.common.context.IQingContextable;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBAccessable;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.framework.server.annotation.longtime.LongTimeServiceMethodAnnotation;
import com.kingdee.bos.qing.common.session.IQingSession;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.dashboard.RuntimeDashboardService;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.data.util.DateUtils;
import com.kingdee.bos.qing.preparedata.IPrepareDataService;
import com.kingdee.bos.qing.preparedata.cache.ProgressModel;
import com.kingdee.bos.qing.preparedata.handler.publish.PublishPrepareDataContext;
import com.kingdee.bos.qing.preparedata.handler.timingpush.TimingPushPrepareDataContext;
import com.kingdee.bos.qing.preparedata.model.DataSourceInfo;
import com.kingdee.bos.qing.preparedata.preparedatacontext.AbstractPrepareDataContext;
import com.kingdee.bos.qing.preparedata.preparedatacontext.SubjectPrepareDataContext;
import com.kingdee.bos.qing.preparedata.task.DataExtractTask;
import com.kingdee.bos.qing.preparedata.task.FromType;
import com.kingdee.bos.qing.publish.domain.CommonPublishDomain;
import com.kingdee.bos.qing.publish.exception.PublishSourcePublishNotExistException;
import com.kingdee.bos.qing.publish.model.PublishOperTypeEnum;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.util.PublishUtil;
import com.kingdee.bos.qing.response.AbstractResponseWrap;
import com.kingdee.bos.qing.response.IResponseWrap;
import com.kingdee.bos.qing.response.ResponseSuccessWrap;
import com.kingdee.bos.qing.response.ResponseUtil;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.schedule.ScheduleEngine;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class PrepareDataService
extends BehaviorService
implements IPrepareDataService,
IQingContextable,
IDBAccessable {
    private QingContext qingContext;
    private ITransactionManagement tx;
    private IDBExcuter dbExcuter;
    private CommonPublishDomain commonPublishDomain;
    private static final String SCENE_LONGER = "longer";

    public void setQingContext(QingContext qingContext) {
        this.qingContext = qingContext;
    }

    public void setTx(ITransactionManagement tx) {
        this.tx = tx;
    }

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    private CommonPublishDomain getCommonPublishDomain() {
        if (this.commonPublishDomain == null) {
            this.commonPublishDomain = new CommonPublishDomain(this.qingContext, this.tx, this.dbExcuter);
        }
        return this.commonPublishDomain;
    }

    @Override
    @BehaviorAssociate(behavior=true)
    @LongTimeServiceMethodAnnotation
    public byte[] subjectStartExtractData(Map<String, String> params) {
        String lastRequestCookies = params.get("lastRequestCookies");
        if (StringUtils.isNotBlank((CharSequence)lastRequestCookies)) {
            QingSessionUtil.set((String)"lastRequestCookies", (String)lastRequestCookies);
        }
        String tag = params.get("tag");
        long timeStamp = Long.parseLong(params.get("timeStamp"));
        String themeId = params.get("themeId");
        boolean dealProgresss = "true".equals(params.get("dealProgresss"));
        boolean needSyncExtract = "true".equals(params.get("openSync"));
        boolean startBySchedule = false;
        if (needSyncExtract) {
            startBySchedule = true;
        }
        SubjectPrepareDataContext subjectPrepareDataContext = new SubjectPrepareDataContext();
        subjectPrepareDataContext.setQingContext(this.qingContext);
        subjectPrepareDataContext.setDbExcuter(this.dbExcuter);
        subjectPrepareDataContext.setTx(this.tx);
        subjectPrepareDataContext.setTag(tag);
        subjectPrepareDataContext.setTimeStamp(timeStamp);
        subjectPrepareDataContext.setFromType(FromType.subject);
        subjectPrepareDataContext.setDealProgresss(dealProgresss);
        subjectPrepareDataContext.setStartBySchedule(startBySchedule);
        subjectPrepareDataContext.setThemeId(themeId);
        subjectPrepareDataContext.setSaveMode(true);
        return this.startExtractData((AbstractPrepareDataContext)subjectPrepareDataContext);
    }

    @Override
    @LongTimeServiceMethodAnnotation
    public byte[] billStartExtractData(Map<String, String> params) {
        String lastRequestCookies = params.get("lastRequestCookies");
        if (StringUtils.isNotBlank((CharSequence)lastRequestCookies)) {
            QingSessionUtil.set((String)"lastRequestCookies", (String)lastRequestCookies);
        }
        String tag = params.get("tag");
        long timeStamp = Long.parseLong(params.get("timeStamp"));
        String bizTag = params.get("bizTag");
        boolean dealProgresss = "true".equals(params.get("dealProgresss"));
        boolean needSyncExtract = "true".equals(params.get("openSync"));
        boolean startBySchedule = false;
        if (needSyncExtract) {
            startBySchedule = true;
        }
        BillPrepareDataContext billPrepareDataContext = new BillPrepareDataContext();
        billPrepareDataContext.setQingContext(this.qingContext);
        billPrepareDataContext.setDbExcuter(this.dbExcuter);
        billPrepareDataContext.setTx(this.tx);
        billPrepareDataContext.setTag(tag);
        billPrepareDataContext.setTimeStamp(timeStamp);
        billPrepareDataContext.setFromType("bill".equals(params.get("formType")) ? FromType.bill : FromType.control);
        billPrepareDataContext.setDealProgresss(dealProgresss);
        billPrepareDataContext.setStartBySchedule(startBySchedule);
        billPrepareDataContext.setBizTag(bizTag);
        billPrepareDataContext.setCreatorId(this.qingContext.getUserId());
        return this.startExtractData(billPrepareDataContext);
    }

    @Override
    @BehaviorAssociate(behavior=true)
    @LongTimeServiceMethodAnnotation
    public byte[] publishedStartExtractData(Map<String, String> params) {
        String lastRequestCookies = params.get("lastRequestCookies");
        if (StringUtils.isNotBlank((CharSequence)lastRequestCookies)) {
            QingSessionUtil.set((String)"lastRequestCookies", (String)lastRequestCookies);
        }
        String tag = params.get("tag");
        long timeStamp = Long.parseLong(params.get("timeStamp"));
        String publishId = params.get("publishId");
        boolean dealProgresss = "true".equals(params.get("dealProgresss"));
        boolean isFirstFromCache = "true".equals(params.get("isFirstFromCache"));
        boolean needSyncExtract = "true".equals(params.get("openSync"));
        boolean isEditScene = "true".equals(params.get("isEditScene"));
        boolean startBySchedule = false;
        if (needSyncExtract) {
            startBySchedule = true;
        }
        PublishPrepareDataContext publishPrepareDataContext = new PublishPrepareDataContext();
        publishPrepareDataContext.setQingContext(this.qingContext);
        publishPrepareDataContext.setDbExcuter(this.dbExcuter);
        publishPrepareDataContext.setTx(this.tx);
        publishPrepareDataContext.setTag(tag);
        publishPrepareDataContext.setTimeStamp(timeStamp);
        publishPrepareDataContext.setFromType(FromType.publish);
        publishPrepareDataContext.setDealProgresss(dealProgresss);
        publishPrepareDataContext.setStartBySchedule(startBySchedule);
        publishPrepareDataContext.setFirstFromCache(isFirstFromCache);
        publishPrepareDataContext.setEditScene(isEditScene);
        publishPrepareDataContext.setPublishId(publishId);
        return this.startExtractData((AbstractPrepareDataContext)publishPrepareDataContext);
    }

    @Override
    @BehaviorAssociate(behavior=true)
    @LongTimeServiceMethodAnnotation
    public byte[] publishedDsdRefAnalysisStartExtractData(Map<String, String> params) {
        String lastRequestCookies = params.get("lastRequestCookies");
        if (StringUtils.isNotBlank((CharSequence)lastRequestCookies)) {
            QingSessionUtil.set((String)"lastRequestCookies", (String)lastRequestCookies);
        }
        RuntimeDashboardService runtimeDashboardService = new RuntimeDashboardService();
        runtimeDashboardService.setQingContext(this.qingContext);
        runtimeDashboardService.setDbExcuter(this.dbExcuter);
        runtimeDashboardService.setTx(this.tx);
        return runtimeDashboardService.refreshData(params);
    }

    @Override
    @LongTimeServiceMethodAnnotation
    public byte[] editTimedPushStartExtractData(Map<String, String> params) {
        String lastRequestCookies = params.get("lastRequestCookies");
        if (StringUtils.isNotBlank((CharSequence)lastRequestCookies)) {
            QingSessionUtil.set((String)"lastRequestCookies", (String)lastRequestCookies);
        }
        String tag = params.get("tag");
        String configId = params.get("configId");
        long timeStamp = Long.parseLong(params.get("timeStamp"));
        TimingPushPrepareDataContext timingPushPrepareDataContext = new TimingPushPrepareDataContext();
        timingPushPrepareDataContext.setQingContext(this.qingContext);
        timingPushPrepareDataContext.setDbExcuter(this.dbExcuter);
        timingPushPrepareDataContext.setTx(this.tx);
        String manageType = params.get("manageType");
        if ("emailTimedPush".equals(manageType)) {
            timingPushPrepareDataContext.setFromType(FromType.timingPushEmail);
        } else if ("lappTimedPush".equals(manageType)) {
            timingPushPrepareDataContext.setFromType(FromType.timingPushRobot);
        }
        timingPushPrepareDataContext.setTag(tag);
        timingPushPrepareDataContext.setDealProgresss(false);
        timingPushPrepareDataContext.setTimeStamp(timeStamp);
        timingPushPrepareDataContext.setScheduleEngine((IScheduleEngine)new ScheduleEngine());
        timingPushPrepareDataContext.setConfigId(configId);
        return this.startExtractData((AbstractPrepareDataContext)timingPushPrepareDataContext);
    }

    private byte[] startExtractData(AbstractPrepareDataContext prepareDataContext) {
        DataExtractTask task = new DataExtractTask(prepareDataContext);
        try {
            ProgressModel progressModel = task.call();
            if (progressModel.isAsynResult()) {
                return null;
            }
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)progressModel);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @Override
    public byte[] getServerTimeStamp(Map<String, String> params) {
        ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)(System.currentTimeMillis() + ""));
        return ResponseUtil.output((IResponseWrap)wrap);
    }

    @Override
    public byte[] loadSubjectDataInfo(Map<String, String> params) {
        String tag = params.get("tag");
        try {
            DataSourceInfo dataSourceInfo = new DataSourceInfo();
            IQingSession qingSession = QingSessionUtil.getQingSessionImpl();
            AbstractDataSource dataSource = (AbstractDataSource)qingSession.getCache(AbstractDataSource.getCacheKey((String)tag), AbstractDataSource.class);
            if (dataSource != null) {
                long extractDataTime = dataSource.getExtractDataTime();
                if (extractDataTime != 0L) {
                    String extractDataTimeStr = DateUtils.DateToString((Date)new Date(extractDataTime), (String)"yyyy-MM-dd HH:mm:ss");
                    dataSourceInfo.setExtractDataTime(extractDataTimeStr);
                }
                dataSourceInfo.setHasDirectModeTable(dataSource.hasDirectModeTable());
            }
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)dataSourceInfo);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @Override
    public byte[] loadPublishedDataInfo(Map<String, String> params) {
        String tag = params.get("tag");
        String scene = params.get("scene");
        String isEdit = params.get("isEdit");
        try {
            DataSourceInfo dataSourceInfo = new DataSourceInfo();
            IQingSession qingSession = QingSessionUtil.getQingSessionImpl();
            AbstractDataSource dataSource = (AbstractDataSource)qingSession.getCache(AbstractDataSource.getCacheKey((String)tag), AbstractDataSource.class);
            String publishId = params.get("publishId");
            if (dataSource != null) {
                long extractDataTime = dataSource.getExtractDataTime();
                if (extractDataTime != 0L) {
                    String extractDataTimeStr = DateUtils.DateToString((Date)new Date(extractDataTime), (String)"yyyy-MM-dd HH:mm:ss");
                    dataSourceInfo.setExtractDataTime(extractDataTimeStr);
                    String originalCreatorName = IntegratedHelper.getUserName((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (String)dataSource.getOriginalCreatorId());
                    dataSourceInfo.setOriginalCreatorName(originalCreatorName);
                }
                dataSourceInfo.setHasDirectModeTable(dataSource.hasDirectModeTable());
            } else {
                PublishPO publishPO = this.getCommonPublishDomain().loadPublishInfo(publishId);
                if (publishPO != null) {
                    String originalCreatorId = publishPO.getCreatorId();
                    String originalCreatorName = IntegratedHelper.getUserName((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (String)originalCreatorId);
                    dataSourceInfo.setOriginalCreatorName(originalCreatorName);
                }
            }
            if (PublishUtil.isPublish((String)publishId)) {
                this.setPublishOper(dataSourceInfo, publishId, scene, null, "true".equals(isEdit));
            }
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)dataSourceInfo);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    private void setPublishOper(DataSourceInfo dataSourceInfo, String publishId, String scene, String dsbPublishId, boolean isEdit) throws AbstractQingIntegratedException, SQLException, PublishSourcePublishNotExistException {
        Map noOperAuthValueMap = this.getCommonPublishDomain().loadPublishOperList(publishId, dsbPublishId, !isEdit, false);
        HashMap resultNoOperAuthValueMap = new HashMap(16);
        if (SCENE_LONGER.equals(scene)) {
            resultNoOperAuthValueMap.put(PublishOperTypeEnum.LONGER.getType(), noOperAuthValueMap.get(PublishOperTypeEnum.LONGER.getType()));
        } else {
            resultNoOperAuthValueMap.put(PublishOperTypeEnum.SQUARE.getType(), noOperAuthValueMap.get(PublishOperTypeEnum.SQUARE.getType()));
        }
        dataSourceInfo.setNoAuthOperValueMap(resultNoOperAuthValueMap);
    }

    @Override
    public byte[] loadPublishedDsdRefAnalysisDataInfo(Map<String, String> params) {
        String tag = params.get("tag");
        String jsonRef = params.get("ref");
        String dsbPublishId = params.get("dsbPublishId");
        String scene = params.get("scene");
        String isEdit = params.get("isEdit");
        try {
            PublishPO publishPO;
            DataSourceInfo dataSourceInfo = new DataSourceInfo();
            ReferenceMap referenceMap = (ReferenceMap)JsonUtil.decodeFromString((String)jsonRef, ReferenceMap.class);
            String refToId = referenceMap.getRefToId();
            IQingSession qingSession = QingSessionUtil.getQingSessionImpl();
            AbstractDataSource dataSource = (AbstractDataSource)qingSession.getCache(AbstractDataSource.getCacheKey((String)tag), AbstractDataSource.class);
            if (dataSource != null) {
                long extractDataTime = dataSource.getExtractDataTime();
                if (extractDataTime != 0L) {
                    String extractDataTimeStr = DateUtils.DateToString((Date)new Date(extractDataTime), (String)"yyyy-MM-dd HH:mm:ss");
                    dataSourceInfo.setExtractDataTime(extractDataTimeStr);
                    if (PublishUtil.isPublish((String)refToId)) {
                        String originalCreatorName = IntegratedHelper.getUserName((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (String)dataSource.getOriginalCreatorId());
                        dataSourceInfo.setOriginalCreatorName(originalCreatorName);
                    }
                }
                dataSourceInfo.setHasDirectModeTable(dataSource.hasDirectModeTable());
            } else if (PublishUtil.isPublish((String)refToId) && (publishPO = this.getCommonPublishDomain().loadPublishInfo(refToId)) != null) {
                String originalCreatorId = publishPO.getCreatorId();
                String originalCreatorName = IntegratedHelper.getUserName((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (String)originalCreatorId);
                dataSourceInfo.setOriginalCreatorName(originalCreatorName);
            }
            this.setPublishOper(dataSourceInfo, refToId, scene, dsbPublishId, "true".equals(isEdit));
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)dataSourceInfo);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @Override
    public byte[] loadEditTimedPushDataInfo(Map<String, String> params) {
        String tag = params.get("tag");
        try {
            DataSourceInfo dataSourceInfo = new DataSourceInfo();
            IQingSession qingSession = QingSessionUtil.getQingSessionImpl();
            AbstractDataSource dataSource = (AbstractDataSource)qingSession.getCache(AbstractDataSource.getCacheKey((String)tag), AbstractDataSource.class);
            if (dataSource != null) {
                long extractDataTime = dataSource.getExtractDataTime();
                if (extractDataTime != 0L) {
                    String extractDataTimeStr = DateUtils.DateToString((Date)new Date(extractDataTime), (String)"yyyy-MM-dd HH:mm:ss");
                    dataSourceInfo.setExtractDataTime(extractDataTimeStr);
                }
                dataSourceInfo.setHasDirectModeTable(dataSource.hasDirectModeTable());
            }
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)dataSourceInfo);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }
}

