/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.preparedata.handler.budget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.localimpl.LocalPersistentQingFile;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.preparedata.exception.BillFormException;
import com.kingdee.bos.qing.preparedata.handler.budget.BudgetDataSourceWriter;
import com.kingdee.bos.qing.preparedata.handler.budget.IQingBudgetDataProvider;
import com.kingdee.bos.qing.preparedata.handler.controller.model.Field;
import com.kingdee.bos.qing.preparedata.handler.controller.model.QingFieldType;
import com.kingdee.bos.qing.preparedata.handler.controller.model.QingMeta;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.web.etl.model.BudgetPageParameters;
import com.kingdee.eas.common.EASBizException;
import java.lang.reflect.Constructor;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BudgetDataProvider {
    private String tag;
    private Context ctx;
    private QingMeta qingMeta;
    private List<String> fileList;
    private Map<String, List<String>> filter;
    private IQingBudgetDataProvider iQingBudgetDataProvider;
    private BudgetPageParameters budgetPageParameters;
    private static Map<Integer, DataType> dataFieldType = new HashMap<Integer, DataType>();

    public BudgetDataProvider(String tag, Context ctx, BudgetPageParameters budgetPageParameters) {
        this.tag = tag;
        this.ctx = ctx;
        this.budgetPageParameters = budgetPageParameters;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public List<String> getFileList() {
        return this.fileList;
    }

    public Map<String, List<String>> getFilter() {
        return this.filter;
    }

    public QingMeta getQingMeta() throws BillFormException {
        String tag = this.budgetPageParameters.getTag();
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            LogUtil.info((String)("qing into getQingMeta:" + tag + ":" + sdf.format(new Date())));
            this.qingMeta = this.getQingBudgetDataProvider().getMeta(tag);
            this.fileList = this.getQingBudgetDataProvider().getFiles(tag);
            this.filter = this.getQingBudgetDataProvider().getFilter(tag);
            StringBuffer fileStr = new StringBuffer();
            if (this.fileList != null && this.fileList.size() != 0) {
                MetaInfo metaInfo = null;
                for (int i = 0; i < this.fileList.size(); ++i) {
                    String fileName = this.fileList.get(i);
                    fileStr.append(fileName + ";");
                    IQingFileVisitor dataFile = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.BUDGET, (String)fileName);
                    if (dataFile.exists()) continue;
                    LogUtil.error((String)("qing in getQingMeta, file not exist:" + fileName));
                    List<Field> fields = this.qingMeta.getColumns();
                    if (metaInfo == null) {
                        metaInfo = new MetaInfo();
                        for (int j = 0; j < fields.size(); ++j) {
                            Field field = fields.get(j);
                            metaInfo.addField(field.getName(), field.getAlias(), dataFieldType.get(field.getFieldType()));
                        }
                    }
                    LocalPersistentQingFile qingFile = new LocalPersistentQingFile(QingPersistentFileType.BUDGET, fileName);
                    BudgetDataSourceWriter budgetDataSourceWriter = new BudgetDataSourceWriter((IQingFile)qingFile, this.ctx);
                    budgetDataSourceWriter.start(metaInfo);
                    budgetDataSourceWriter.writeData(new Object[metaInfo.getFieldNames().size()]);
                    budgetDataSourceWriter.close(null);
                }
                LogUtil.info((String)("qing in getQingMeta:" + tag + ":" + fileStr));
            }
            LogUtil.info((String)("qing out of getQingMeta:" + tag + ":" + sdf.format(new Date())));
        }
        catch (EASBizException e) {
            throw new BillFormException(e.getMessage(), e);
        }
        catch (BOSException e) {
            throw new BillFormException(e.getMessage(), e);
        }
        return this.qingMeta;
    }

    public void dispose() {
    }

    private IQingBudgetDataProvider getQingBudgetDataProvider() throws BillFormException {
        if (this.iQingBudgetDataProvider == null) {
            try {
                String className = this.budgetPageParameters.getClassName();
                Class<?> clazz = Class.forName(className);
                Constructor<?> constructor = clazz.getConstructor(Context.class);
                this.iQingBudgetDataProvider = (IQingBudgetDataProvider)constructor.newInstance(this.ctx);
            }
            catch (Exception e) {
                throw new BillFormException(e.getMessage(), e);
            }
        }
        return this.iQingBudgetDataProvider;
    }

    static {
        dataFieldType.put(QingFieldType.String.toNumber(), DataType.STRING);
        dataFieldType.put(QingFieldType.Number.toNumber(), DataType.NUMBER);
        dataFieldType.put(QingFieldType.Int.toNumber(), DataType.INT);
        dataFieldType.put(QingFieldType.DateTime.toNumber(), DataType.DATETIME);
        dataFieldType.put(QingFieldType.Date.toNumber(), DataType.DATE);
        dataFieldType.put(QingFieldType.Boolean.toNumber(), DataType.BOOLEAN);
    }
}

