/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.preparedata.handler.budget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.qing.common.context.QingIntegratedContext;
import com.kingdee.bos.qing.common.lock.ILock;
import com.kingdee.bos.qing.common.lock.LockFactory;
import com.kingdee.bos.qing.datasource.exception.DataSourcePersistenceException;
import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.bos.qing.datasource.spec.qs.QingStorageWriterWraper;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.ormrpc.IBudgetService;
import com.kingdee.bos.qing.ormrpc.QingORMRPCDispatcherFactory;
import com.kingdee.bos.qing.preparedata.util.QingBudgetServiceUtil;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.QingIntegratedUtil;
import java.io.Closeable;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import q.storage.columnar.api.impl.QingStorageRecord;
import q.storage.columnar.util.QingStorageUtils;
import shaded.org.apache.parquet.io.api.Binary;
import shaded.org.apache.parquet.schema.GroupType;
import shaded.org.apache.parquet.schema.MessageType;
import shaded.org.apache.parquet.schema.PrimitiveType;
import shaded.org.apache.parquet.schema.Type;

public class BudgetDataSourceWriter {
    public static final int BIGDECIMAL_LENGTH = 16;
    public static final String QS = ".QS";
    public static final String EXTRAMETA_DATA_KEY = ".metadata.";
    private static final String BUDGET_UPLOAD_FILE_LOCK = "BUDGET_UPLOAD_FILE_LOCK";
    private static final int SUGGESTED_BUFFER_LEN = 65536;
    private QingStorageWriterWraper _recordWriter;
    private boolean _hasData;
    private MetaInfo _metaInfo;
    private IQingFile _dataFile;
    private MessageType _recordSchema;
    private List<DataType> _tempFieldTypesForWrite;
    private List<String> _tempFieldNamesForWrite;
    private Context _ctx;

    BudgetDataSourceWriter(IQingFile dataFile, Context context) {
        this._dataFile = dataFile;
        this._ctx = context;
    }

    public void start(MetaInfo metaInfo) {
        this._metaInfo = metaInfo;
        this._tempFieldTypesForWrite = metaInfo.getFieldDataTypes();
        this._tempFieldNamesForWrite = metaInfo.getFieldNames();
    }

    public void writeData(Object[] row) throws BOSException {
        if (this._recordWriter == null) {
            this.start();
        }
        this._hasData = true;
        QingStorageRecord record = new QingStorageRecord((GroupType)this._recordSchema);
        for (int index = 0; index < this._tempFieldTypesForWrite.size(); ++index) {
            DataType dataType = this._tempFieldTypesForWrite.get(index);
            Object oValue = row[index];
            if (oValue == null) continue;
            if (dataType == DataType.DATE || dataType == DataType.DATETIME) {
                if (oValue instanceof Date) {
                    long value = ((Date)oValue).getTime();
                    record.add(index, value);
                    continue;
                }
                if (oValue instanceof Calendar) {
                    long value = ((Calendar)oValue).getTimeInMillis();
                    record.add(index, value);
                    continue;
                }
                LogUtil.error((String)("error in BudgetDataSourceWriter, file name is " + this._dataFile.getName() + ", value is " + oValue.toString()));
                throw new BOSException("error in BudgetDataSourceWriter, " + this._tempFieldNamesForWrite.get(index) + " expected " + oValue.toString() + " to be a Date, but a " + oValue.getClass().getName());
            }
            if (dataType == DataType.INT) {
                Long v = null;
                try {
                    if (oValue instanceof Long) {
                        v = (Long)oValue;
                    } else if (oValue instanceof Short) {
                        v = ((Short)oValue).longValue();
                    }
                    if (oValue instanceof Integer) {
                        v = ((Integer)oValue).longValue();
                    }
                    if (oValue instanceof Byte) {
                        v = ((Byte)oValue).longValue();
                    }
                    if (oValue instanceof BigDecimal) {
                        v = ((BigDecimal)oValue).longValue();
                    }
                }
                catch (Exception e) {
                    LogUtil.error((String)("error in BudgetDataSourceWriter, file name is " + this._dataFile.getName() + ", value is " + oValue.toString()));
                    throw new BOSException("error in BudgetDataSourceWriter, " + this._tempFieldNamesForWrite.get(index) + " expected " + oValue.toString() + " to be a int, but a " + oValue.getClass().getName());
                }
                if (v == null) {
                    LogUtil.error((String)("error in BudgetDataSourceWriter, file name is " + this._dataFile.getName() + ", value is null. oValue type is " + oValue.getClass().getName()));
                    throw new BOSException("error in BudgetDataSourceWriter, file name is " + this._dataFile.getName() + ", value is null. oValue type is " + oValue.getClass().getName());
                }
                record.add(index, v.longValue());
                continue;
            }
            if (dataType == DataType.NUMBER) {
                BigDecimal v = null;
                if (oValue instanceof BigDecimal) {
                    v = (BigDecimal)oValue;
                } else if (oValue instanceof Number) {
                    v = new BigDecimal(oValue.toString());
                } else {
                    LogUtil.error((String)("error in BudgetDataSourceWriter, file name is " + this._dataFile.getName() + ", value is " + oValue.toString()));
                    throw new BOSException("error in BudgetDataSourceWriter, " + this._tempFieldNamesForWrite.get(index) + " expected " + oValue.toString() + " to be a Number, but a " + oValue.getClass().getName());
                }
                byte[] encode = null;
                try {
                    encode = QingStorageUtils.encodeBigDecimal((BigDecimal)v, (int)16);
                }
                catch (Exception e) {
                    LogUtil.error((String)("error in BudgetDataSourceWriter, file name is " + this._dataFile.getName() + ", value is " + oValue.toString()));
                    throw new BOSException("error in BudgetDataSourceWriter, " + this._tempFieldNamesForWrite.get(index) + " can not encode bigDecimal to byte[]: " + oValue);
                }
                record.add(index, Binary.fromConstantByteArray((byte[])encode));
                continue;
            }
            String value = oValue.toString();
            if (value.length() <= 0) continue;
            record.add(index, value);
        }
        try {
            this._recordWriter.write(record);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(Exception exception) {
        if (!this._hasData) {
            try {
                this.start();
            }
            catch (Exception e) {
                exception = e;
            }
        }
        if (this._recordWriter != null) {
            try {
                this._recordWriter.finishWriteData();
            }
            catch (DataSourcePersistenceException e) {
                exception = e;
            }
            try {
                this._recordWriter.close((Exception)exception);
            }
            catch (Exception e) {
                exception = e;
            }
            this._recordWriter = null;
        }
        if (exception == null && QingBudgetServiceUtil.isNeedORMRPC()) {
            ILock lock = LockFactory.createLock((String)(BUDGET_UPLOAD_FILE_LOCK + this._dataFile.getName()));
            try {
                lock.lock();
                this.uploadFile();
            }
            catch (Exception e) {
                LogUtil.error((String)("error in BudgetDataSourceWriter uploadFile, file name is " + this._dataFile.getName()), (Throwable)e);
                exception = e;
            }
            finally {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void uploadFile() throws IOException {
        IBudgetService ormService = QingORMRPCDispatcherFactory.createBudgetService(this._ctx);
        QingIntegratedContext qingCtx = QingIntegratedUtil.initQingIntegratedContext(this._ctx, null);
        QingInputStream inputStream = null;
        int len = -1;
        int fileCount = 0;
        try {
            inputStream = this._dataFile.getInputStream();
            fileCount = (int)(inputStream.length() / 65536L) + 1;
            byte[] result = new byte[65536];
            for (int i = 0; i < fileCount; ++i) {
                inputStream.seek((long)(i * 65536));
                len = inputStream.read(result);
                if (len != -1) {
                    result = Arrays.copyOf(result, len);
                    ormService.uploadBudgetDataFile(qingCtx, this._dataFile.getName() + "." + i, result);
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{inputStream});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{inputStream});
        ormService.uploadBudgetDataFileFinish(qingCtx, this._dataFile.getName(), fileCount);
    }

    private MessageType createMessageType() {
        if (this._metaInfo == null) {
            return null;
        }
        PrimitiveType[] columns = new PrimitiveType[this._tempFieldTypesForWrite.size()];
        for (int index = 0; index < this._tempFieldTypesForWrite.size(); ++index) {
            DataType dataType = this._tempFieldTypesForWrite.get(index);
            String fieldId = this.getFieldID(index);
            columns[index] = DataType.DATE.equals((Object)dataType) || DataType.DATETIME.equals((Object)dataType) ? new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, fieldId) : (DataType.NUMBER.equals((Object)dataType) ? new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, fieldId) : (DataType.INT.equals((Object)dataType) ? new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, fieldId) : new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, fieldId)));
        }
        return new MessageType("envelope", (Type[])columns);
    }

    private String getFieldID(int index) {
        return index + "";
    }

    private void start() throws BOSException {
        if (this._recordWriter != null) {
            return;
        }
        if (this._metaInfo == null) {
            throw new BOSException("no metainfo");
        }
        this._recordSchema = this.createMessageType();
        try {
            this._recordWriter = new QingStorageWriterWraper(this._dataFile, this._recordSchema, this._metaInfo);
        }
        catch (DataSourcePersistenceException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

