/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.preparedata.handler.controller.model;

import com.kingdee.bos.qing.preparedata.handler.controller.model.EntryEntity;
import com.kingdee.bos.qing.preparedata.handler.controller.model.Field;
import com.kingdee.bos.qing.preparedata.handler.controller.model.ParentChildDimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class QingMeta {
    private List<Field> columns = new ArrayList<Field>();
    private List<EntryEntity> entryEntities = new ArrayList<EntryEntity>();
    private Map<String, EntryEntity> entryMap = new HashMap<String, EntryEntity>();
    private Map<String, Field> fieldMap = new HashMap<String, Field>();
    private String suggestedDefaultSchemaId;
    private List<ParentChildDimension> parentChildDimensions = new ArrayList<ParentChildDimension>();
    private String rootKey;
    private boolean isCoreBaseBill;

    public boolean isCoreBaseBill() {
        return this.isCoreBaseBill;
    }

    public void setCoreBaseBill(boolean coreBaseBill) {
        this.isCoreBaseBill = coreBaseBill;
    }

    public void addColumn(Field column) {
        String uniqueKey = column.getEntity() + "." + column.getName();
        if (column != null && !this.fieldMap.containsKey(uniqueKey)) {
            this.columns.add(column);
            this.fieldMap.put(uniqueKey, column);
        }
    }

    public void addEntryEntity(EntryEntity entryentity) {
        if (entryentity != null) {
            if (this.entryMap.containsKey(entryentity.getName())) {
                return;
            }
            this.entryEntities.add(entryentity);
            this.entryMap.put(entryentity.getName(), entryentity);
        }
    }

    public EntryEntity getEntryEntity(String name) {
        return this.entryMap.get(name);
    }

    public Field getField(String fieldName, String entityName) {
        return this.fieldMap.get(entityName + "." + fieldName);
    }

    public void replaceField(String fieldName, String entityName, Field target) {
        Iterator<Field> iterator = this.columns.iterator();
        int col = -1;
        boolean needReplace = false;
        while (iterator.hasNext()) {
            ++col;
            Field field = iterator.next();
            if (!field.getName().equalsIgnoreCase(fieldName) || !entityName.equalsIgnoreCase(field.getEntity())) continue;
            needReplace = true;
            iterator.remove();
            break;
        }
        if (needReplace) {
            this.columns.add(col, target);
        } else {
            this.columns.add(target);
        }
        this.fieldMap.put(entityName + "." + fieldName, target);
        EntryEntity entryEntity = this.entryMap.get(entityName);
        entryEntity.replaceField(fieldName, target);
    }

    public String getRootKey() {
        if (null == this.rootKey) {
            for (EntryEntity entry : this.entryEntities) {
                if (null != entry.getParentName()) continue;
                this.rootKey = entry.getKey();
                break;
            }
        }
        return this.rootKey;
    }

    public List<Field> getColumns() {
        return this.columns;
    }

    public List<EntryEntity> getEntryEntities() {
        return Collections.unmodifiableList(this.entryEntities);
    }

    public String getSuggestedDefaultSchemaId() {
        return this.suggestedDefaultSchemaId;
    }

    public void setSuggestedDefaultSchemaId(String suggestedDefaultSchemaId) {
        this.suggestedDefaultSchemaId = suggestedDefaultSchemaId;
    }

    public void addParentChildDimension(ParentChildDimension parentChildDimension) {
        if (parentChildDimension != null) {
            this.parentChildDimensions.add(parentChildDimension);
        }
    }

    public List<ParentChildDimension> getParentChildDimensions() {
        return Collections.unmodifiableList(this.parentChildDimensions);
    }
}

