/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.preparedata.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.PropertyRefCollection;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SelectorInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.SubQueryInfo;
import com.kingdee.bos.metadata.query.util.ConstDataType;
import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.preparedata.exception.PrepareDataException;
import com.kingdee.bos.qing.preparedata.handler.controller.model.QingFieldType;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.base.permission.RuleUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryUtil {
    private static Map<String, DataType> filedTypeMap = new HashMap<String, DataType>();
    private static Map<String, QingFieldType> qingFiledTypeMap = new HashMap<String, QingFieldType>();
    private static final String SUFFIX_ID = ".id";

    public static QingFieldType parseQingFieldType(String fieldType) {
        if (StringUtils.isEmpty((CharSequence)fieldType)) {
            return QingFieldType.String;
        }
        QingFieldType qingFieldType = qingFiledTypeMap.get(fieldType.toUpperCase());
        if (null == qingFieldType) {
            return QingFieldType.String;
        }
        return qingFieldType;
    }

    public static DataType parseDataType(String fieldType) {
        if (fieldType == null) {
            return DataType.STRING;
        }
        DataType dateType = filedTypeMap.get(fieldType.toUpperCase());
        if (dateType == null) {
            return DataType.STRING;
        }
        return dateType;
    }

    public static List<Map<String, Object>> getQueryProperties(Context ctx, String queryPK) throws PrepareDataException {
        ArrayList<Map<String, Object>> queryProperties = new ArrayList<Map<String, Object>>();
        MetaDataPK queryMetaPK = MetaDataPK.create((String)queryPK);
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        QueryInfo query = loader.getQuery((IMetaDataPK)queryMetaPK);
        try {
            SubObjectInfo mainObject = query.getMainObject();
            if (mainObject instanceof SubQueryInfo) {
                query = ((SubQueryInfo)mainObject).getQueryRef();
            }
        }
        catch (BOSException e) {
            throw new PrepareDataException("failed to load query properties.", (Throwable)e);
        }
        SelectorInfo selectorInfo = query.getSelector();
        ArrayList fieldInfos = selectorInfo.getFields();
        for (QueryFieldInfo queryFieldInfo : fieldInfos) {
            PropertyRefInfo propertyRefInfo;
            PropertyInfo propertyInfo;
            HashMap<String, String> properties = new HashMap<String, String>();
            String name = queryFieldInfo.getName();
            String alias = queryFieldInfo.getDisplayName(ctx.getOriginLocale());
            properties.put("alias", alias);
            properties.put("name", name);
            ConstDataType dataType = null;
            String dataTypeString = com.kingdee.bos.metadata.entity.DataType.STRING.getName();
            try {
                dataType = queryFieldInfo.getReturnType();
                dataTypeString = dataType.equals((Object)ConstDataType.INT) || dataType.equals((Object)ConstDataType.NUMBER) ? com.kingdee.bos.metadata.entity.DataType.DECIMAL.getName() : (dataType.equals((Object)ConstDataType.DATE) || dataType.equals((Object)ConstDataType.TIME) || dataType.equals((Object)ConstDataType.TIMESTAMP) ? com.kingdee.bos.metadata.entity.DataType.DATE.getName() : com.kingdee.bos.metadata.entity.DataType.STRING.getName());
            }
            catch (BOSException bOSException) {
                // empty catch block
            }
            PropertyRefCollection propertyRefCollection = queryFieldInfo.getPropertyRefs();
            if ((dataType.equals((Object)ConstDataType.INT) || dataType.equals((Object)ConstDataType.NUMBER)) && propertyRefCollection != null && propertyRefCollection.size() == 1 && queryFieldInfo.getFormulaString().equals("#0") && (propertyInfo = (propertyRefInfo = propertyRefCollection.get(0)).getRefProperty()) instanceof OwnPropertyInfo) {
                OwnPropertyInfo ownProp = (OwnPropertyInfo)propertyInfo;
                com.kingdee.bos.metadata.entity.DataType ownDataType = ownProp.getDataType();
                DataType qingDataType = QueryUtil.parseDataType(ownDataType.getName());
                dataTypeString = qingDataType.equals((Object)DataType.NUMBER) ? ownDataType.getName() : com.kingdee.bos.metadata.entity.DataType.STRING.getName();
            }
            properties.put("fieldType", dataTypeString);
            queryProperties.add(properties);
        }
        return queryProperties;
    }

    public static IQueryExecutor getQueryExecutor(Context ctx, String queryPK, List<String> selector, String filterItems) throws ParserException, BOSException {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK(queryPK));
        QueryUtil.buildExecutor(ctx, exec, selector, filterItems, queryPK, true);
        return exec;
    }

    public static IQueryExecutor getQueryExecutorBySql(Context ctx, String sql, List<String> selector, String filterItems) throws ParserException, BOSException {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (String)sql, null);
        QueryUtil.buildExecutor(ctx, exec, selector, filterItems, null, false);
        return exec;
    }

    private static void buildExecutor(Context ctx, IQueryExecutor exec, List<String> selector, String filterItems, String queryPK, boolean needPermission) throws ParserException, BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = null;
        if (filterItems != null && filterItems.length() > 0) {
            filterInfo = new FilterInfo(filterItems);
            entityViewInfo.setFilter(filterInfo);
        }
        if (needPermission) {
            String fieldName;
            if (filterInfo == null) {
                filterInfo = new FilterInfo();
            }
            if (!StringUtil.isEmptyString((String)(fieldName = QueryUtil.getBizOrgPropertyName(ctx, queryPK)))) {
                UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
                String userId = userInfo.getId().toString();
                String sql = " (select forgid from t_pm_orgrange where fuserid = '" + userId + "' and ftype = 10)";
                FilterItemInfo itemInfo = new FilterItemInfo(fieldName + " in " + sql);
                FilterInfo filterField = new FilterInfo();
                filterField.getFilterItems().add(itemInfo);
                filterInfo = RuleUtil.mergeFilterInfo((FilterInfo)filterInfo, (FilterInfo)filterField, (String)"and");
                entityViewInfo.setFilter(filterInfo);
            }
        }
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        for (String fieldName : selector) {
            selectorItemCollection.add(fieldName);
        }
        entityViewInfo.setSelector(selectorItemCollection);
        exec.setObjectView(entityViewInfo);
        exec.option().isIgnoreOrder = true;
        exec.option().isAutoIgnoreDuplicatedRow = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.option().isIgnorePermissionCheck = false;
    }

    private static String getBizOrgPropertyName(Context ctx, String queryPK) {
        CoreBillBaseInfo billBaseInfo;
        IObjectValue objectValue = null;
        QueryInfo metaInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getQuery((IMetaDataPK)MetaDataPK.create((String)queryPK));
        if (metaInfo == null) {
            return null;
        }
        EntityObjectInfo entityInfo = QueryUtil.getMainEntityInfo((AbstractMetaDataValue)metaInfo);
        if (entityInfo == null) {
            return null;
        }
        try {
            objectValue = (IObjectValue)entityInfo.getObjectValueClazzRuntime().newInstance();
        }
        catch (Exception e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
        }
        String name = null;
        if (objectValue instanceof CoreBillBaseInfo) {
            billBaseInfo = (CoreBillBaseInfo)objectValue;
            name = billBaseInfo.getBizOrgPropertyName();
        } else if (objectValue instanceof CoreBillEntryBaseInfo) {
            billBaseInfo = (CoreBillEntryBaseInfo)objectValue;
            name = billBaseInfo.getBizOrgPropertyName();
            name = QueryUtil.getPropertyName(entityInfo, (IObjectValue)metaInfo, name);
        }
        if (StringUtil.isEmptyString(name)) {
            for (PropertyInfo pi : entityInfo.getInheritedNoDuplicatedPropertiesRuntime()) {
                String value = pi.getExtendedProperty("isMainBizOrg");
                if (!"true".equalsIgnoreCase(value)) continue;
                name = QueryUtil.getPropertyName(entityInfo, (IObjectValue)pi, pi.getName());
                break;
            }
        } else {
            PropertyInfo pi = entityInfo.getPropertyByName(name);
            name = QueryUtil.getPropertyName(entityInfo, (IObjectValue)pi, name);
        }
        return name;
    }

    private static EntityObjectInfo getMainEntityInfo(AbstractMetaDataValue metaInfo) {
        try {
            SubObjectInfo mainObject = ((QueryInfo)metaInfo).getMainObject();
            if (mainObject instanceof SubQueryInfo) {
                return null;
            }
            if (mainObject instanceof SubEntityInfo) {
                SubEntityInfo subInfo = (SubEntityInfo)mainObject;
                return subInfo.getEntityRef();
            }
            return null;
        }
        catch (BOSException e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static String getPropertyName(EntityObjectInfo entityInfo, IObjectValue objectValue, String name) {
        if (objectValue instanceof EntityObjectInfo && name != null && name.indexOf(".") > 0) {
            if (entityInfo.getPropertyByName(name.split("\\.")[0]) != null) {
                return null;
            }
        } else if (objectValue instanceof LinkPropertyInfo) {
            name = name + SUFFIX_ID;
            return name;
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] Object2ByteArray(Object object) throws IOException {
        byte[] bytes;
        ByteArrayOutputStream baos = null;
        ObjectOutputStream os = null;
        try {
            baos = new ByteArrayOutputStream();
            os = new ObjectOutputStream(baos);
            os.writeObject(object);
            os.flush();
            bytes = baos.toByteArray();
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{baos, os});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{baos, os});
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object ByteArray2Object(byte[] bytes) throws IOException, ClassNotFoundException {
        Object object;
        ByteArrayInputStream bais = null;
        ObjectInputStream ois = null;
        try {
            bais = new ByteArrayInputStream(bytes);
            ois = new ObjectInputStream(bais);
            object = ois.readObject();
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{bais, ois});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{bais, ois});
        return object;
    }

    static {
        filedTypeMap.put("SHORT", DataType.NUMBER);
        filedTypeMap.put("INTEGER", DataType.NUMBER);
        filedTypeMap.put("LONG", DataType.NUMBER);
        filedTypeMap.put("FLOAT", DataType.NUMBER);
        filedTypeMap.put("DOUBLE", DataType.NUMBER);
        filedTypeMap.put("BIGDECIMAL", DataType.NUMBER);
        filedTypeMap.put("DATE", DataType.DATE);
        filedTypeMap.put("TIME", DataType.DATE);
        filedTypeMap.put("TIMESTAMP", DataType.DATE);
        filedTypeMap.put("CHAR", DataType.STRING);
        filedTypeMap.put("BOOLEAN", DataType.STRING);
        filedTypeMap.put("BYTE", DataType.STRING);
        filedTypeMap.put("STRING", DataType.STRING);
        filedTypeMap.put("ENUM", DataType.STRING);
        qingFiledTypeMap.put("SHORT", QingFieldType.Number);
        qingFiledTypeMap.put("INTEGER", QingFieldType.Int);
        qingFiledTypeMap.put("INT", QingFieldType.Int);
        qingFiledTypeMap.put("LONG", QingFieldType.Number);
        qingFiledTypeMap.put("FLOAT", QingFieldType.Number);
        qingFiledTypeMap.put("DOUBLE", QingFieldType.Number);
        qingFiledTypeMap.put("BIGDECIMAL", QingFieldType.Number);
        qingFiledTypeMap.put("NUMBER", QingFieldType.Number);
        qingFiledTypeMap.put("DATE", QingFieldType.Date);
        qingFiledTypeMap.put("TIME", QingFieldType.Date);
        qingFiledTypeMap.put("TIMESTAMP", QingFieldType.Date);
        qingFiledTypeMap.put("CHAR", QingFieldType.String);
        qingFiledTypeMap.put("BOOLEAN", QingFieldType.Boolean);
        qingFiledTypeMap.put("BYTE", QingFieldType.String);
        qingFiledTypeMap.put("STRING", QingFieldType.String);
        qingFiledTypeMap.put("ENUM", QingFieldType.String);
    }
}

