/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.programablecard.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.dashboard.exception.DashboardException;
import com.kingdee.bos.qing.manage.domain.ThemeDomain;
import com.kingdee.bos.qing.manage.domain.ThemeGroupDomain;
import com.kingdee.bos.qing.manage.model.FolderNode;
import com.kingdee.bos.qing.manage.model.ThemeGroupVO;
import com.kingdee.bos.qing.manage.model.ThemeVO;
import com.kingdee.bos.qing.programablecard.IChartInfoReceive;
import com.kingdee.bos.qing.programablecard.dao.ProgramableCardDao;
import com.kingdee.bos.qing.programablecard.model.ProgramableCard;
import com.kingdee.bos.qing.programablecard.model.ProgramableCardPubRef;
import com.kingdee.bos.qing.programablecard.model.ProgramableCardRef;
import com.kingdee.bos.qing.programablecard.util.ChartRequestUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public class ProgramableCardDomain
implements IChartInfoReceive {
    private ProgramableCardDao cardDao;
    private IDBExcuter dbExcuter;
    private QingContext qingContext;
    private ITransactionManagement tx;
    private ThemeDomain themeDomain;
    private ThemeGroupDomain themeGroupDomain;

    private ProgramableCardDao getCardDao() {
        if (this.cardDao == null) {
            this.cardDao = new ProgramableCardDao(this.dbExcuter);
        }
        return this.cardDao;
    }

    public ProgramableCardDomain(IDBExcuter dbExcuter, ITransactionManagement tx) {
        this.dbExcuter = dbExcuter;
        this.tx = tx;
    }

    public ProgramableCardDomain(IDBExcuter dbExcuter, ITransactionManagement tx, QingContext qingContext) {
        this.dbExcuter = dbExcuter;
        this.tx = tx;
        this.qingContext = qingContext;
    }

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveChartInfo(String themeId, Map<String, Object> chartParams) {
        boolean success = true;
        String chartId = (String)chartParams.get("chartId");
        try {
            this.tx.beginRequired();
            this.getCardDao().saveChartInfo(themeId, chartId);
        }
        catch (Throwable e) {
            success = false;
            this.tx.markRollback();
            LogUtil.error((String)("save chartInfo failed, themeId=" + themeId + ", chartId=" + chartId), (Throwable)e);
        }
        finally {
            this.tx.end();
        }
        return success;
    }

    public String getRefChartId(String dsbId, String refUid) throws AbstractQingIntegratedException, SQLException {
        ProgramableCardRef cardRef = this.getCardDao().loadChartRefInfo(dsbId, refUid);
        if (cardRef != null) {
            return cardRef.getChartId();
        }
        return null;
    }

    public String getChartId(String themeId) throws AbstractQingIntegratedException, SQLException {
        ProgramableCard card = this.getCardDao().loadChartInfo(themeId);
        if (card != null) {
            return card.getChartId();
        }
        return null;
    }

    public String getRuntimeChartId(String publishId, String refUid, String userId) throws AbstractQingIntegratedException, SQLException {
        ProgramableCardPubRef userBindCardRef = this.getCardDao().loadUserBindPubChartRefInfo(publishId, refUid, userId);
        if (userBindCardRef != null) {
            return userBindCardRef.getChartId();
        }
        ProgramableCardPubRef cardPubRef = this.getCardDao().loadPublishChartRefInfo(publishId, refUid);
        String pubChartId = cardPubRef.getChartId();
        try {
            this.tx.beginRequired();
            String userBindChartId = ChartRequestUtil.copyChartContent(pubChartId);
            this.getCardDao().saveUserBindPubChartRefInfo(userBindChartId, refUid, publishId, userId);
            String string = userBindChartId;
            return string;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
        }
    }

    private ThemeGroupDomain getThemeGroupDomain() {
        if (this.themeGroupDomain == null) {
            this.themeGroupDomain = new ThemeGroupDomain();
            this.themeGroupDomain.setDbExcuter(this.dbExcuter);
            this.themeGroupDomain.setQingContext(this.qingContext);
            this.themeGroupDomain.setTx(this.tx);
        }
        return this.themeGroupDomain;
    }

    private ThemeDomain getThemeDomain() {
        if (this.themeDomain == null) {
            this.themeDomain = new ThemeDomain(this.qingContext, this.dbExcuter);
        }
        return this.themeDomain;
    }

    public FolderNode getAllProgramableCard(String userID) throws AbstractQingIntegratedException, DashboardException {
        FolderNode root = new FolderNode();
        try {
            List themeGroupList = this.getThemeGroupDomain().getUserVisibleThemeGroups();
            for (int i = themeGroupList.size() - 1; i >= 0; --i) {
                ThemeGroupVO themeGroupVO = (ThemeGroupVO)themeGroupList.get(i);
                FolderNode themeGroupNode = new FolderNode();
                themeGroupNode.setName(themeGroupVO.getThemeGroupName());
                themeGroupNode.setPreset(themeGroupVO.isPreset());
                List themeVOList = this.getThemeDomain().listThemesUnionPreset(userID, themeGroupVO.getThemeGroupID(), "2");
                for (int j = 0; j < themeVOList.size(); ++j) {
                    FolderNode themeNode = new FolderNode();
                    themeNode.setName(((ThemeVO)themeVOList.get(j)).getThemeName());
                    themeNode.setThemeId(((ThemeVO)themeVOList.get(j)).getThemeID());
                    themeNode.setPreset(((ThemeVO)themeVOList.get(j)).isPreset());
                    themeGroupNode.addChild(themeNode);
                }
                if (themeVOList.size() <= 0) continue;
                root.addChild(themeGroupNode);
            }
        }
        catch (SQLException e) {
            throw new DashboardException((Throwable)e);
        }
        return root;
    }

    public boolean getProgramableCardAvailable(Map<String, String> params) throws AbstractQingIntegratedException, DashboardException {
        try {
            String themeId = params.get("themeId");
            ProgramableCard cardInfo = this.getCardDao().loadChartInfo(themeId);
            boolean rs = cardInfo != null && cardInfo.getChartId() != null;
            return rs;
        }
        catch (SQLException e) {
            throw new DashboardException((Throwable)e);
        }
    }
}

