/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.programablecard.domain;

import com.kingdee.bos.qing.common.exception.IntegratedRuntimeException;
import com.kingdee.bos.qing.manage.imexport.collector.util.ImportUtil;
import com.kingdee.bos.qing.manage.imexport.model.runtime.AbstractThemeImportModel;
import com.kingdee.bos.qing.manage.imexport.model.runtime.ProgramableCardImportModel;
import com.kingdee.bos.qing.programablecard.util.ChartRequestUtil;
import com.kingdee.bos.qing.util.CloseUtil;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.UUID;
import java.util.zip.ZipInputStream;

public class ProgramableCardImExporter {
    private static final String FILESUFFIX = ".properties";

    public void importChartFile(ZipInputStream zis, AbstractThemeImportModel themeCollectModel) throws IOException {
        FileOutputStream os = null;
        String fileName = UUID.randomUUID().toString();
        String dirPath = this.getImportPath();
        String fullPath = dirPath + File.separator + fileName + FILESUFFIX;
        try {
            ByteArrayInputStream bis = ImportUtil.getInputStreamFromZipInputStream((ZipInputStream)zis);
            File dir = new File(dirPath);
            File file = new File(fullPath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            byte[] buffer = new byte[1024];
            int offset = 0;
            os = new FileOutputStream(file);
            while ((offset = bis.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, offset);
            }
        }
        catch (IOException e) {
            try {
                this.clearFile(fullPath);
                throw e;
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{os});
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{os});
        ProgramableCardImportModel importModel = (ProgramableCardImportModel)themeCollectModel;
        importModel.setFileName(fileName);
        importModel.setFileFullPath(fullPath);
    }

    public String importChartFile(byte[] content) throws IOException, IntegratedRuntimeException {
        FileOutputStream os = null;
        String fileName = UUID.randomUUID().toString();
        String dirPath = this.getImportPath();
        String fullPath = dirPath + File.separator + fileName + FILESUFFIX;
        try {
            File dir = new File(dirPath);
            File file = new File(fullPath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            os = new FileOutputStream(file);
            ((OutputStream)os).write(content);
        }
        catch (IOException e) {
            try {
                this.clearFile(fullPath);
                throw e;
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{os});
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{os});
        String chartId = ChartRequestUtil.requestImportChart(fileName);
        return chartId;
    }

    private String getImportPath() {
        String prefix = System.getProperty("easweb.root").toString();
        String fullPath = prefix + File.separator + "webviews" + File.separator + "webDev" + File.separator + "chart" + File.separator + "qing" + File.separator + "import";
        return fullPath;
    }

    private void clearFile(String fullPath) {
        File file = new File(fullPath);
        file.delete();
    }
}

