/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.programablecard.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.manage.domain.AbstractThemeManageDomain;
import com.kingdee.bos.qing.manage.exception.ExportThemeException;
import com.kingdee.bos.qing.manage.exception.ImportThemeException;
import com.kingdee.bos.qing.manage.exception.ThemeManagementException;
import com.kingdee.bos.qing.manage.imexport.collector.ICollectable;
import com.kingdee.bos.qing.manage.imexport.domain.ImExportDomain;
import com.kingdee.bos.qing.manage.imexport.model.po.ExportThemeGroupModel;
import com.kingdee.bos.qing.manage.imexport.model.po.ExportThemeModel;
import com.kingdee.bos.qing.manage.imexport.model.runtime.AbstractThemeImportModel;
import com.kingdee.bos.qing.manage.imexport.model.runtime.ProgramableCardImportModel;
import com.kingdee.bos.qing.manage.model.ThemePO;
import com.kingdee.bos.qing.manage.model.ThemeVO;
import com.kingdee.bos.qing.map.imexport.model.ExportMapModel;
import com.kingdee.bos.qing.programablecard.dao.ProgramableCardDao;
import com.kingdee.bos.qing.programablecard.imexport.collector.ProgramableCardCollectorGetter;
import com.kingdee.bos.qing.programablecard.model.ProgramableCard;
import com.kingdee.bos.qing.programablecard.util.ChartRequestUtil;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class ProgramableCardManageDomain
extends AbstractThemeManageDomain {
    private ProgramableCardDao cardDao;

    private ProgramableCardDao getCardDao() {
        if (this.cardDao == null) {
            this.cardDao = new ProgramableCardDao(this.dbExcuter);
        }
        return this.cardDao;
    }

    public ProgramableCardManageDomain(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter, IScheduleEngine scheduleEngine) {
        super(qingContext, tx, dbExcuter, scheduleEngine);
    }

    protected void doOverwrite(String themeID) throws AbstractQingIntegratedException, SQLException {
        this.deleteChartByThemeId(themeID);
    }

    protected void collectThemeImportModel(ZipInputStream zis, AbstractThemeImportModel themeCollectModel) throws ImportThemeException, AbstractQingIntegratedException {
        HashMap<String, String> themeGroupNameUuidMap = new HashMap<String, String>();
        HashMap<String, String> themeNameUuidMap = new HashMap<String, String>();
        String selectedThemeGroupName = themeCollectModel.getGroupName();
        String selectedThemeName = themeCollectModel.getThemeName();
        ZipEntry zipEntry = null;
        String themeGroupName = null;
        String themeName = null;
        try {
            while ((zipEntry = zis.getNextEntry()) != null) {
                ICollectable collector;
                ByteArrayInputStream byteArrayInputStream;
                ExportThemeGroupModel themeGroupProperty;
                String zipEntryName = zipEntry.getName();
                String[] zipEntryPath = ImExportDomain.parseEntryNameToList((String)zipEntryName);
                if (zipEntryPath == null) continue;
                if (zipEntryName.endsWith("qing-theme-group.xml") && (themeGroupProperty = ExportThemeGroupModel.parseFromZipFile((ByteArrayInputStream)(byteArrayInputStream = ImExportDomain.getInputStreamFromZipInputStream((ZipInputStream)zis)))).getId() != null && themeGroupProperty.getName() != null) {
                    themeGroupNameUuidMap.put(themeGroupProperty.getId(), themeGroupProperty.getName());
                }
                if (themeGroupNameUuidMap.get(zipEntryPath[0]) != null) {
                    zipEntryPath[0] = (String)themeGroupNameUuidMap.get(zipEntryPath[0]);
                }
                if (!selectedThemeGroupName.equals(themeGroupName = zipEntryPath[0])) continue;
                if (zipEntryName.endsWith("qing-programablecard.xml")) {
                    byteArrayInputStream = ImExportDomain.getInputStreamFromZipInputStream((ZipInputStream)zis);
                    ExportThemeModel exportThemeModel = ExportThemeModel.parseFromZipFile((ByteArrayInputStream)byteArrayInputStream, (String[])zipEntryPath);
                    if (selectedThemeName.equals(exportThemeModel.getName())) {
                        themeCollectModel.setDescription(exportThemeModel.getDescription());
                    }
                    themeNameUuidMap.put(zipEntryPath[1], exportThemeModel.getName());
                }
                if (zipEntryPath.length >= 2) {
                    zipEntryPath[1] = themeName = (String)themeNameUuidMap.get(zipEntryPath[1]);
                } else {
                    themeName = null;
                }
                if (!selectedThemeName.equals(themeName) || (collector = ProgramableCardCollectorGetter.getCollector(zipEntryPath)) == null) continue;
                collector.collect(zis, zipEntryPath, themeCollectModel);
            }
        }
        catch (IOException e) {
            throw new ImportThemeException((Throwable)e);
        }
        catch (JDOMException e) {
            throw new ImportThemeException((Throwable)e);
        }
        catch (ModelParseException e) {
            throw new ImportThemeException((Throwable)e);
        }
    }

    protected void doImport(AbstractThemeImportModel themeCollectModel) throws ImportThemeException, AbstractQingIntegratedException {
        ProgramableCardImportModel importModel = (ProgramableCardImportModel)themeCollectModel;
        String fileName = importModel.getFileName();
        String themeId = importModel.getThemeID();
        String chartId = null;
        try {
            chartId = ChartRequestUtil.requestImportChart(fileName);
            LogUtil.info((String)("import chartFile success, programable cardId=" + chartId));
            this.getCardDao().saveChartInfo(themeId, chartId);
        }
        catch (AbstractQingIntegratedException e) {
            ChartRequestUtil.requestDelete(chartId);
            throw e;
        }
        catch (SQLException e) {
            ChartRequestUtil.requestDelete(chartId);
            throw new ImportThemeException((Throwable)e);
        }
        catch (IOException e) {
            ChartRequestUtil.requestDelete(chartId);
            throw new ImportThemeException((Throwable)e);
        }
        finally {
            File file = new File(importModel.getFileFullPath());
            file.delete();
        }
    }

    public void exportTheme(String themeGroupName, String themeGroupFolderPath, ThemeVO themeVo, boolean needPublish, ZipOutputStream zos) throws ExportThemeException, AbstractQingIntegratedException {
        String uuid = UUID.randomUUID().toString();
        String themeId = themeVo.getThemeID();
        String themeName = themeVo.getThemeName();
        ExportThemeModel exportModel = new ExportThemeModel();
        exportModel.setId(themeId);
        exportModel.setName(themeName);
        exportModel.setDescription(themeVo.getDescription());
        exportModel.setThemeType(themeVo.getThemeType());
        String folderPath = themeGroupFolderPath + File.separator + uuid;
        try {
            Element propertyElement = exportModel.toXml();
            String propertyFileName = folderPath + File.separator + "qing-programablecard.xml";
            zos.putNextEntry(new ZipEntry(propertyFileName));
            XmlUtil.save((Element)propertyElement, (OutputStream)zos);
            String chartFileName = folderPath + File.separator + "qing-programablecard-chart";
            ProgramableCard cardInfo = this.getCardDao().loadChartInfo(themeId);
            String chartId = cardInfo.getChartId();
            byte[] chartContent = ChartRequestUtil.requestExportChart(chartId);
            if (chartContent != null) {
                zos.putNextEntry(new ZipEntry(chartFileName));
                zos.write(chartContent);
            }
        }
        catch (IOException e) {
            throw new ExportThemeException((Throwable)e);
        }
        catch (SQLException e) {
            throw new ExportThemeException((Throwable)e);
        }
    }

    protected void doDelete(String userID, ThemeVO themeVO) throws AbstractQingIntegratedException, ThemeManagementException {
        try {
            String themeID = themeVO.getThemeID();
            this.deleteChartByThemeId(themeID);
        }
        catch (SQLException e) {
            throw new ThemeManagementException((Throwable)e);
        }
    }

    protected void doSaveOrUpdate(ThemePO themePO) throws AbstractQingIntegratedException, SQLException {
    }

    protected void doMove(String groupID, String themeID, String themeName) throws AbstractQingIntegratedException, SQLException {
    }

    protected void doCopy(Map<String, String> params, String oldID, String newID, ThemePO themePO, List<AbstractThemeManageDomain.IFileRollback> rollbackCollector) throws ThemeManagementException, AbstractQingIntegratedException {
        try {
            ProgramableCard oldCardModel = this.getCardDao().loadChartInfo(oldID);
            String oldChartId = oldCardModel.getChartId();
            if (oldChartId != null) {
                String newChartId = ChartRequestUtil.copyChartContent(oldChartId);
                this.getCardDao().saveChartInfo(newID, newChartId);
                ChartFileRollback rollbacker = new ChartFileRollback(newChartId);
                rollbackCollector.add(rollbacker);
            }
        }
        catch (SQLException e) {
            throw new ThemeManagementException((Throwable)e);
        }
    }

    private void deleteChartByThemeId(String themeId) throws AbstractQingIntegratedException, SQLException {
        ProgramableCard cardModel = this.getCardDao().loadChartInfo(themeId);
        if (cardModel == null) {
            return;
        }
        String chartId = cardModel.getChartId();
        this.getCardDao().deleteChartInfo(chartId);
        ChartRequestUtil.requestDelete(chartId);
    }

    public void collectExportMapModel(ThemeVO themeVo, List<ExportMapModel> exportMapModels, List<String> mapIdList, boolean withPublish) throws AbstractQingIntegratedException, SQLException {
    }

    public void updateMapRef(Map<String, String> importMapId, String themeId) throws AbstractQingIntegratedException, SQLException {
    }

    private static class ChartFileRollback
    implements AbstractThemeManageDomain.IFileRollback {
        private String chartId;

        public ChartFileRollback(String chartId) {
            this.chartId = chartId;
        }

        public void rollback() {
            try {
                ChartRequestUtil.requestDelete(this.chartId);
            }
            catch (AbstractQingIntegratedException e) {
                LogUtil.error((String)("delete programable chart failed when copy chart failed,chartId=" + this.chartId));
            }
        }
    }
}

