/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.appmenu.domain;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.imexport.model.po.AbstractPublishModel;
import com.kingdee.bos.qing.manage.exception.ExportThemeException;
import com.kingdee.bos.qing.manage.exception.ImportThemeException;
import com.kingdee.bos.qing.manage.exception.ThemeManagementException;
import com.kingdee.bos.qing.manage.imexport.collector.ICollectable;
import com.kingdee.bos.qing.manage.imexport.collector.PublishDsbCollectorGetter;
import com.kingdee.bos.qing.manage.imexport.collector.common.PublishInfoCollector;
import com.kingdee.bos.qing.manage.imexport.collector.dashboard.publish.PublishDsbModelCollector;
import com.kingdee.bos.qing.manage.imexport.collector.dashboard.publish.PublishDsbPictuerCollector;
import com.kingdee.bos.qing.manage.imexport.collector.dashboard.publish.PublishDsbPicturePropertyCollector;
import com.kingdee.bos.qing.manage.imexport.collector.dashboard.publish.PublishDsbRefCollector;
import com.kingdee.bos.qing.manage.imexport.collector.dashboard.publish.PublishDsbWidgetSchemaCollector;
import com.kingdee.bos.qing.manage.imexport.collector.dashboard.publish.PublishDsbWidgetSchemaPropertyCollector;
import com.kingdee.bos.qing.manage.imexport.collector.subject.publish.PublishBoxCollector;
import com.kingdee.bos.qing.manage.imexport.collector.subject.publish.PublishQsFileCollector;
import com.kingdee.bos.qing.manage.imexport.collector.subject.publish.PublishQsPropertyCollector;
import com.kingdee.bos.qing.manage.imexport.collector.subject.publish.PublishSchemaCollector;
import com.kingdee.bos.qing.manage.imexport.collector.subject.publish.PublishShcemaPropertyCollector;
import com.kingdee.bos.qing.manage.imexport.model.po.IDashboardExportFilePathGetter;
import com.kingdee.bos.qing.manage.imexport.model.po.ISubjectExportFilePathGetter;
import com.kingdee.bos.qing.manage.imexport.model.runtime.AbstractPublishImportModel;
import com.kingdee.bos.qing.manage.imexport.model.runtime.AbstractThemeImportModel;
import com.kingdee.bos.qing.manage.imexport.model.runtime.DashboardPublishImportModel;
import com.kingdee.bos.qing.manage.imexport.model.runtime.SubjectPublishImportModel;
import com.kingdee.bos.qing.manage.imexport.model.vo.ExportPublishConflictVO;
import com.kingdee.bos.qing.manage.model.ThemeVO;
import com.kingdee.bos.qing.programablecard.imexport.collector.dashboard.publish.PublishDsbProgramableCardCollector;
import com.kingdee.bos.qing.programablecard.imexport.collector.dashboard.publish.PublishDsbProgramableCardPropertyCollector;
import com.kingdee.bos.qing.publish.appmenu.dao.AppMenuDao;
import com.kingdee.bos.qing.publish.appmenu.model.AppMenuPublishModel;
import com.kingdee.bos.qing.publish.exception.PublishNameDuplicateException;
import com.kingdee.bos.qing.publish.exception.PublishSameSourceNameDuplicateException;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.model.PublishTarget;
import com.kingdee.bos.qing.publish.target.AbstractPublishTargetImexportDomain;
import com.kingdee.bos.qing.publish.util.PublishUtil;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.jdom2.Element;

public class AppMenuPublishTargetImexportDomain
extends AbstractPublishTargetImexportDomain {
    private AppMenuDao appMenuDao;

    public AppMenuPublishTargetImexportDomain(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter, IScheduleEngine scheduleEngine) {
        super(qingContext, tx, dbExcuter, scheduleEngine);
        this.appMenuDao = new AppMenuDao(qingContext, dbExcuter);
    }

    public AbstractPublishModel createNewPublishModel() {
        return new AppMenuPublishModel();
    }

    public void doExportPublishInfo(ZipOutputStream zos, String themeGroupName, PublishPO publishPo, ThemeVO themeVO, String themeFolderPath) throws ThemeManagementException, AbstractQingIntegratedException {
        try {
            String publishFloder = UUID.randomUUID().toString();
            PublishSourceEnum publishSourceType = publishPo.getPublishSourceType();
            AppMenuPublishModel appMenuPublishModel = (AppMenuPublishModel)this.initPublishModel(publishPo, themeGroupName, themeVO);
            String publishPrefixPath = themeFolderPath + File.separator + "easappmenu" + File.separator + publishFloder;
            String publishFloderPath = null;
            if (publishSourceType == PublishSourceEnum.subject) {
                publishFloderPath = publishPrefixPath + File.separator + "subject-pub-eas-appmenu.xml";
                this.getSubjectPublishSourceDomain().doExport(zos, publishPo, publishPrefixPath, (ISubjectExportFilePathGetter)appMenuPublishModel);
            } else if (publishSourceType == PublishSourceEnum.dashboard) {
                publishFloderPath = publishPrefixPath + File.separator + "dsb-pub-eas-appmenu.xml";
                this.getDashboardPublishSourceDomain().doExport(zos, publishPo.getId(), publishPrefixPath, (IDashboardExportFilePathGetter)appMenuPublishModel);
            }
            Element propertyElement = appMenuPublishModel.toXml();
            zos.putNextEntry(new ZipEntry(publishFloderPath));
            XmlUtil.save((Element)propertyElement, (OutputStream)zos);
        }
        catch (SQLException e) {
            throw new ExportThemeException((Throwable)e);
        }
        catch (IOException e) {
            throw new ExportThemeException((Throwable)e);
        }
    }

    public final void collectPublishInfo(ZipInputStream zis, String[] zipEntry, AbstractThemeImportModel exportThemeCollectModel) throws ImportThemeException, AbstractQingIntegratedException {
        if (zipEntry != null && zipEntry.length >= 3 && "easappmenu".equals(zipEntry[2])) {
            String entryName = zipEntry[zipEntry.length - 1];
            Object collector = null;
            collector = "subject-pub-eas-appmenu.xml".equals(entryName) ? new PublishInfoCollector((AbstractPublishModel)new AppMenuPublishModel(), (AbstractPublishImportModel)new SubjectPublishImportModel()) : ("dsb-pub-eas-appmenu.xml".equals(entryName) ? new PublishInfoCollector((AbstractPublishModel)new AppMenuPublishModel(), (AbstractPublishImportModel)new DashboardPublishImportModel()) : PublishDsbCollectorGetter.getCollector((String)entryName));
            if (collector != null) {
                collector.collect(zis, zipEntry, exportThemeCollectModel);
            }
        }
    }

    public void doImportPublishInfo(AbstractThemeImportModel themeImportModel, AbstractPublishImportModel publishImportModel, List<IQingFile> saveSuccessFiles) throws ThemeManagementException, AbstractQingIntegratedException {
        String themeId = themeImportModel.getThemeID();
        AbstractPublishModel publishModel = publishImportModel.getPublishModel();
        String publishId = PublishUtil.getPublishId((String)UUID.randomUUID().toString());
        String schemaId = this.getSchemaManageDao().genSchemaId();
        publishModel.setSchemaId(schemaId);
        publishModel.setPublishId(publishId);
        publishModel.setTagId(themeId);
        try {
            PublishPO publishPo = new PublishPO();
            this.savePublishImportInfo(themeImportModel, publishImportModel, publishPo, saveSuccessFiles);
            if ("0".equals(themeImportModel.getThemeType())) {
                String publishFolderPathName = this.getPathName(publishModel.getPath());
                String appMenyPath = themeImportModel.getNameSpace() + "/" + publishFolderPathName + "/" + publishModel.getName();
                themeImportModel.getImportAppmenuPathAndId().put(appMenyPath, publishId);
            }
        }
        catch (PublishNameDuplicateException e) {
            this.doPublishNameDuplicate(themeImportModel, publishModel);
        }
        catch (PublishSameSourceNameDuplicateException e) {
            this.doPublishNameDuplicate(themeImportModel, publishModel);
        }
        catch (SQLException e) {
            throw new ImportThemeException((Throwable)e);
        }
        catch (BOSException e) {
            throw new ImportThemeException((Throwable)e);
        }
    }

    private void doPublishNameDuplicate(AbstractThemeImportModel themeImportModel, AbstractPublishModel publishModel) throws ImportThemeException, AbstractQingIntegratedException {
        try {
            String userId = this.qingContext.getUserId();
            ThemeVO themeVO = this.getThemeDao().loadThemeIncludePreset(userId, publishModel.getTagId());
            String[] allPath = publishModel.getPath().split("/");
            String publishFolderPathName = "";
            for (int i = 1; i < allPath.length; ++i) {
                publishFolderPathName = publishFolderPathName + this.appMenuDao.getPageFolderByPageId(allPath[i]) + "/";
            }
            ExportPublishConflictVO exportPublicConflict = new ExportPublishConflictVO();
            String publishPath = Messages.getMLS((QingContext)this.qingContext, (String)"appMenu", (String)"\u5e94\u7528\u83dc\u5355", (Messages.ProjectName)Messages.ProjectName.QING_THEME) + " : " + publishFolderPathName + publishModel.getName();
            exportPublicConflict.setThemeName(themeVO.getThemeName());
            exportPublicConflict.setThemeType(themeVO.getThemeType());
            exportPublicConflict.setPublishPath(publishPath);
            themeImportModel.getConfilctPublishList().add(exportPublicConflict);
        }
        catch (SQLException e) {
            throw new ImportThemeException((Throwable)e);
        }
        catch (BOSException e) {
            throw new ImportThemeException((Throwable)e);
        }
    }

    private String getPathName(String path) throws BOSException, SQLException {
        String[] allPath = path.split("/");
        String publishFolderPathName = "";
        for (int i = 1; i < allPath.length; ++i) {
            publishFolderPathName = publishFolderPathName + this.appMenuDao.getPageFolderByPageId(allPath[i]) + "-";
        }
        return publishFolderPathName;
    }

    public PublishPO loadNewPublishPO(PublishTarget publishTarget, Map<String, String> tempFile) throws AbstractQingIntegratedException, SQLException {
        PublishPO publishPO = new PublishPO();
        publishPO.setPath(publishTarget.getPath());
        return publishPO;
    }

    public void doPublishNameDuplicate(List<ExportPublishConflictVO> confilctPublishList, ThemeVO themeVO, String importPath, String publishName) throws AbstractQingIntegratedException, ImportThemeException {
        try {
            String[] allPath = importPath.split("/");
            String publishFolderPathName = "";
            for (int i = 1; i < allPath.length; ++i) {
                publishFolderPathName = publishFolderPathName + this.appMenuDao.getPageFolderByPageId(allPath[i]) + "/";
            }
            ExportPublishConflictVO exportPublicConflict = new ExportPublishConflictVO();
            String publishPath = Messages.getMLS((QingContext)this.qingContext, (String)"appMenu", (String)"\u5e94\u7528\u83dc\u5355", (Messages.ProjectName)Messages.ProjectName.QING_THEME) + " : " + publishFolderPathName + publishName;
            exportPublicConflict.setThemeName(themeVO.getThemeName());
            exportPublicConflict.setThemeType(themeVO.getThemeType());
            exportPublicConflict.setPublishPath(publishPath);
            confilctPublishList.add(exportPublicConflict);
        }
        catch (SQLException e) {
            throw new ImportThemeException((Throwable)e);
        }
        catch (BOSException e) {
            throw new ImportThemeException((Throwable)e);
        }
    }

    static {
        PublishDsbCollectorGetter.registerCollector((String)"dsb-pub-eas-appmenu-ref.xml", (ICollectable)new PublishDsbRefCollector());
        PublishDsbCollectorGetter.registerCollector((String)"dsb-pub-eas-appmenu.model", (ICollectable)new PublishDsbModelCollector());
        PublishDsbCollectorGetter.registerCollector((String)"dsb-pub-eas-appmenu-schema.xml", (ICollectable)new PublishDsbWidgetSchemaPropertyCollector());
        PublishDsbCollectorGetter.registerCollector((String)"dsb-pub-eas-appmenu.schema", (ICollectable)new PublishDsbWidgetSchemaCollector());
        PublishDsbCollectorGetter.registerCollector((String)"dsb-pub-eas-appmenu-picture.xml", (ICollectable)new PublishDsbPicturePropertyCollector());
        PublishDsbCollectorGetter.registerCollector((String)"dsb-pub-eas-appmenu-picture", (ICollectable)new PublishDsbPictuerCollector());
        PublishDsbCollectorGetter.registerCollector((String)"dsb-pub-eas-appmenu-programablecard.xml", (ICollectable)new PublishDsbProgramableCardPropertyCollector());
        PublishDsbCollectorGetter.registerCollector((String)"dsb-pub-eas-appmenu-programablecard", (ICollectable)new PublishDsbProgramableCardCollector());
        PublishDsbCollectorGetter.registerCollector((String)"subject-pub-eas-appmenu-schema.xml", (ICollectable)new PublishShcemaPropertyCollector());
        PublishDsbCollectorGetter.registerCollector((String)"subject-pub-eas-appmenu.schema", (ICollectable)new PublishSchemaCollector());
        PublishDsbCollectorGetter.registerCollector((String)"eas-appmenu_qs.xml", (ICollectable)new PublishQsPropertyCollector());
        PublishDsbCollectorGetter.registerCollector((String)"eas-appmenu.qs", (ICollectable)new PublishQsFileCollector());
        PublishDsbCollectorGetter.registerCollector((String)"eas-appmenu.model", (ICollectable)new PublishBoxCollector());
    }
}

