/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.guimenu.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.context.QingIntegratedContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.exception.IntegratedRuntimeException;
import com.kingdee.bos.qing.publish.integrated.model.TreeMenuFolderNode;
import com.kingdee.bos.qing.publish.integrated.model.TreeMenuLeafNode;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.model.PublishVO;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.eas.base.permission.IMainMenuItem;
import com.kingdee.eas.base.permission.MainMenuItemFactory;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.base.uiframe.IMainFunctionMenu;
import com.kingdee.eas.base.uiframe.MainFunctionInfo;
import com.kingdee.eas.base.uiframe.MainFunctionMenuFactory;
import com.kingdee.eas.base.uiframe.MenuCacheFactory;
import com.kingdee.eas.base.uiframe.OpenMethod;
import com.kingdee.eas.base.uiframe.app.MainMenuQuickHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.math.RandomUtils;

public class GUIMenuDao {
    public static final String EAS_GUI_CENTER_ROOT_UUID = "EAS_GUI_CENTER_ROOT_UUID";
    private static final String PUBLISH_GUI_UICLASSNAME = "com.kingdee.eas.rpts.qinganalysis.ui.PublishedQingAnalysisExplorer";
    private static Map<String, TreeMenuFolderNode> ROOTNODE_MAP = new HashMap<String, TreeMenuFolderNode>();
    private QingContext qingContext;
    private IDBExcuter dbExcuter;

    public GUIMenuDao(QingContext qingContext, IDBExcuter dbExcuter) {
        this.qingContext = qingContext;
        this.dbExcuter = dbExcuter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeMenuFolderNode getGUIMenuTree(boolean isRefresh) throws SQLException {
        Map<String, TreeMenuFolderNode> map = ROOTNODE_MAP;
        synchronized (map) {
            if (!isRefresh && ROOTNODE_MAP.get(this.qingContext.getAccountId()) != null) {
                return ROOTNODE_MAP.get(this.qingContext.getAccountId());
            }
            QingIntegratedContext qingIntegratedContext = (QingIntegratedContext)this.qingContext;
            Context ctx = qingIntegratedContext.getBosContext();
            TreeMenuFolderNode guiRootNode = new TreeMenuFolderNode();
            guiRootNode.setName(EAS_GUI_CENTER_ROOT_UUID);
            guiRootNode.setDisplayName("EAS");
            HashMap<String, TreeMenuFolderNode> parentNodeMap = new HashMap<String, TreeMenuFolderNode>();
            parentNodeMap.put(EAS_GUI_CENTER_ROOT_UUID, guiRootNode);
            try {
                ArrayList<MainMenuItemInfo> allMenu = new ArrayList<MainMenuItemInfo>();
                MainMenuQuickHelper menuHelper = new MainMenuQuickHelper();
                MainFunctionInfo info = menuHelper.getInitMenuData(ctx);
                Iterator iter = info.getSubItemMap().values().iterator();
                ArrayList list = null;
                while (iter.hasNext()) {
                    list = (ArrayList)iter.next();
                    allMenu.addAll(list);
                }
                this.buildGUIMenuTree(allMenu, ctx, parentNodeMap);
                ROOTNODE_MAP.put(this.qingContext.getAccountId(), guiRootNode);
            }
            catch (Exception e) {
                throw new SQLException(e.getMessage(), e);
            }
            return guiRootNode;
        }
    }

    private void buildGUIMenuTree(List<MainMenuItemInfo> list, Context ctx, Map<String, TreeMenuFolderNode> parentNodeMap) throws UnsupportedEncodingException {
        Locale locale = ctx.getLocale();
        for (MainMenuItemInfo menuInfo : list) {
            if (!menuInfo.isVisible() || menuInfo.isIsLeaf() || !menuInfo.isEnabled() || menuInfo.getLevel() > 4) continue;
            int level = this.getMenuLeve(menuInfo);
            String displayName = menuInfo.getName(locale);
            MainMenuItemInfo parent = menuInfo.getParent();
            if (parent == null) {
                TreeMenuFolderNode parentNode = parentNodeMap.get(EAS_GUI_CENTER_ROOT_UUID);
                TreeMenuFolderNode fNode = new TreeMenuFolderNode();
                fNode.setName(GUIMenuDao.encodeMenuId(menuInfo.getId().toString()));
                fNode.setDisplayName(displayName);
                parentNode.addChild(fNode);
                parentNodeMap.put(GUIMenuDao.encodeMenuId(menuInfo.getId().toString()), fNode);
                continue;
            }
            String parentNodeId = GUIMenuDao.encodeMenuId(parent.getId().toString());
            TreeMenuFolderNode parentNode = parentNodeMap.get(parentNodeId);
            if (parentNode == null) {
                parentNode = new TreeMenuFolderNode();
                parentNode.setName(parentNodeId);
                parentNodeMap.put(parentNodeId, parentNode);
                continue;
            }
            if (level == 4) {
                TreeMenuLeafNode leafNode = new TreeMenuLeafNode();
                leafNode.setName(GUIMenuDao.encodeMenuId(menuInfo.getId().toString()));
                leafNode.setDisplayName(displayName);
                leafNode.setType("leaf");
                parentNode.addChild(leafNode);
                continue;
            }
            TreeMenuFolderNode fNode = new TreeMenuFolderNode();
            fNode.setName(GUIMenuDao.encodeMenuId(menuInfo.getId().toString()));
            fNode.setDisplayName(displayName);
            parentNode.addChild(fNode);
            parentNodeMap.put(GUIMenuDao.encodeMenuId(menuInfo.getId().toString()), fNode);
        }
    }

    private int getMenuLeve(MainMenuItemInfo menuInfo) {
        int level = 2;
        for (MainMenuItemInfo paretMenu = menuInfo.getParent(); paretMenu != null; paretMenu = paretMenu.getParent()) {
            if (++level != 4) continue;
            break;
        }
        return level;
    }

    private static String encodeMenuId(String id) throws UnsupportedEncodingException {
        return URLEncoder.encode(id, "UTF-8");
    }

    private static String decodeMenuId(String id) throws UnsupportedEncodingException {
        return URLDecoder.decode(id, "UTF-8");
    }

    public void saveGUIMenu(String publishId, String name, String publishPath) throws SQLException, AbstractQingIntegratedException {
        String[] paths = publishPath.split("/");
        String parentId = paths[paths.length - 1];
        String param = publishId + ";" + name;
        String menuItemId = null;
        try {
            QingIntegratedContext qingIntegratedContext = (QingIntegratedContext)this.qingContext;
            Context ctx = qingIntegratedContext.getBosContext();
            IMainMenuItem menu = MainMenuItemFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK menuPk = new ObjectUuidPK("id", new MainMenuItemInfo().getBOSType());
            menuPk.setKeyValue("id", (Object)GUIMenuDao.decodeMenuId(parentId));
            MainMenuItemInfo paretnItem = menu.getMainMenuItemInfo((IObjectPK)menuPk);
            MainMenuItemInfo mi = this.getMenuItemInfo(paretnItem, name, param, PUBLISH_GUI_UICLASSNAME);
            IObjectPK pk = menu.addnew((CoreBaseInfo)mi);
            menuItemId = pk.toString();
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw new SQLException("save GUI menu failed.", e);
        }
        this.dbExcuter.execute("INSERT INTO T_QING_PUBLISH_APPMENU(FPUBLISHID, FMENUITEMID) VALUES (?,?)", new Object[]{publishId, menuItemId});
        this.clearMenuItemCache();
    }

    private MainMenuItemInfo getMenuItemInfo(MainMenuItemInfo parent, String name, String param, String uiClassName) {
        String number = "qinganalysis" + System.currentTimeMillis() + RandomUtils.nextInt();
        MainMenuItemInfo mi = new MainMenuItemInfo();
        mi.setParent(parent);
        QingIntegratedContext qingIntegratedContext = (QingIntegratedContext)this.qingContext;
        Context ctx = qingIntegratedContext.getBosContext();
        LanguageCollection lc = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getSolution().getLanguages();
        int z = lc.size();
        for (int i = 0; i < z; ++i) {
            LanguageInfo li = lc.get(i);
            mi.setName(name, li.getLocale());
        }
        mi.setNumber(number);
        mi.setDescription("");
        mi.setUiClassName(uiClassName);
        mi.setUiClassParam(param);
        mi.setOpenMethod(OpenMethod.DEFAULT);
        mi.setOrder("255");
        mi.setEnabled(true);
        mi.setVisible(true);
        mi.setIsReport(false);
        return mi;
    }

    private void clearMenuItemCache() {
        IMainFunctionMenu imenu = null;
        try {
            QingIntegratedContext qingIntegratedContext = (QingIntegratedContext)this.qingContext;
            Context ctx = qingIntegratedContext.getBosContext();
            imenu = MainFunctionMenuFactory.getLocalInstance((Context)ctx);
            imenu.updateMenuCache("");
            MenuCacheFactory.getLocalInstance((Context)ctx).updateAllMenuCache();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void deleteGUIMenu(final String publishId) throws SQLException, AbstractQingIntegratedException {
        QingIntegratedContext qingIntegratedContext = (QingIntegratedContext)this.qingContext;
        final Context ctx = qingIntegratedContext.getBosContext();
        String sql = "SELECT FAPPCENTERID, FMENUITEMID FROM T_QING_PUBLISH_APPMENU where FPUBLISHID = ?";
        this.dbExcuter.query(sql, new Object[]{publishId}, (ResultHandler)new ResultHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    String menuID = rs.getString("FMENUITEMID");
                    try {
                        IMainMenuItem menu = MainMenuItemFactory.getLocalInstance((Context)ctx);
                        ObjectUuidPK menuPk_del = new ObjectUuidPK("id", new MainMenuItemInfo().getBOSType());
                        menuPk_del.setKeyValue("id", (Object)menuID);
                        menu.delete((IObjectPK)menuPk_del);
                    }
                    catch (BOSException e) {
                        throw new SQLException(e);
                    }
                    catch (EASBizException e) {
                        throw new SQLException(e);
                    }
                    String sqlDelAppMenuItem = "DELETE T_QING_PUBLISH_APPMENU WHERE FPUBLISHID=?";
                    try {
                        GUIMenuDao.this.dbExcuter.execute(sqlDelAppMenuItem, new Object[]{publishId});
                    }
                    catch (AbstractQingIntegratedException e) {
                        throw new SQLException(e);
                    }
                }
                return true;
            }
        });
        this.clearMenuItemCache();
    }

    public void updateGUIMenu(int updateType, PublishPO publishPO) throws SQLException, AbstractQingIntegratedException {
        String sql = "SELECT FMENUITEMID FROM T_QING_PUBLISH_APPMENU where FPUBLISHID = ?";
        String fmenuItemId = (String)this.dbExcuter.query(sql, new Object[]{publishPO.getId()}, (ResultHandler)new ResultHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getString("FMENUITEMID");
                }
                return null;
            }
        });
        if (fmenuItemId == null) {
            return;
        }
        QingIntegratedContext qingIntegratedContext = (QingIntegratedContext)this.qingContext;
        Context ctx = qingIntegratedContext.getBosContext();
        try {
            IMainMenuItem menu = MainMenuItemFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK menuPk = new ObjectUuidPK("id", new MainMenuItemInfo().getBOSType());
            menuPk.setKeyValue("id", (Object)fmenuItemId);
            MainMenuItemInfo itemInfo = menu.getMainMenuItemInfo((IObjectPK)menuPk);
            String[] paths = publishPO.getPath().split("/");
            String parentId = paths[paths.length - 1];
            menuPk.setKeyValue("id", (Object)GUIMenuDao.decodeMenuId(parentId));
            MainMenuItemInfo parentItem = menu.getMainMenuItemInfo((IObjectPK)menuPk);
            if (itemInfo == null) {
                String param = publishPO.getId() + ";" + publishPO.getName();
                itemInfo = this.getMenuItemInfo(parentItem, publishPO.getName(), param, PUBLISH_GUI_UICLASSNAME);
            }
            switch (updateType) {
                case 0: {
                    String name = publishPO.getName();
                    LanguageCollection lc = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getSolution().getLanguages();
                    int z = lc.size();
                    for (int i = 0; i < z; ++i) {
                        LanguageInfo li = lc.get(i);
                        itemInfo.setName(name, li.getLocale());
                    }
                    break;
                }
                case 1: {
                    itemInfo.setParent(parentItem);
                    break;
                }
                case 6: 
                case 7: {
                    String name = publishPO.getName();
                    LanguageCollection lc = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getSolution().getLanguages();
                    int z = lc.size();
                    for (int i = 0; i < z; ++i) {
                        LanguageInfo li = lc.get(i);
                        itemInfo.setName(name, li.getLocale());
                    }
                    itemInfo.setParent(parentItem);
                    break;
                }
            }
            menu.save((CoreBaseInfo)itemInfo);
            this.clearMenuItemCache();
        }
        catch (EASBizException e) {
            throw new SQLException(e.getMessage(), e);
        }
        catch (BOSException e) {
            throw new SQLException(e.getMessage(), e);
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException(e.getMessage(), e);
        }
    }

    public List<PublishVO> loadAllPublishInfos(final String userId) throws SQLException, AbstractQingIntegratedException {
        StringBuilder sqlSelect = new StringBuilder();
        sqlSelect.append("select p.fid, p.ftype, p.fsource, p.fname, p.fpath,  p.fcreatetime, p.fupdatetime, p.fschemaid , p.fanalysis, p.ftagid, p.fcarrydata, theme.fname as themeName, TQTG.fname as themeGroupName");
        sqlSelect.append(" from T_QING_PUBLISH p left join T_QING_Theme theme on theme.fid = p.ftagid left join t_qing_theme_group tqtg on tqtg.fid = theme.fthemegroupid where p.ftype=? and p.fcreatorId=? order by p.fcreatetime desc");
        Object[] params = new Object[]{4, userId};
        return (List)this.dbExcuter.query(sqlSelect.toString(), params, (ResultHandler)new ResultHandler<List<PublishVO>>(){

            public List<PublishVO> handle(ResultSet rs) throws SQLException {
                ArrayList users = null;
                ArrayList roles = null;
                ArrayList<PublishVO> listVO = new ArrayList<PublishVO>();
                PublishVO vo = null;
                while (rs.next()) {
                    String fid = rs.getString("fid");
                    if (vo != null && fid.equals(vo.getId())) continue;
                    vo = new PublishVO();
                    vo.setId(fid);
                    vo.setPublishTargetType(rs.getInt("ftype"));
                    vo.setName(rs.getString("fname"));
                    vo.setPath(rs.getString("fpath"));
                    vo.setSchemaId(rs.getString("fschemaid"));
                    vo.setCanAnalysis(rs.getBoolean("fanalysis"));
                    String publishSourceType = rs.getString("fsource");
                    vo.setPublishSourceType(publishSourceType);
                    if (PublishSourceEnum.bill.name().equals(publishSourceType) || PublishSourceEnum.control.name().equals(publishSourceType)) {
                        try {
                            vo.setPublishSourceName(IntegratedHelper.queryFormDisplayName((String)rs.getString("ftagid"), (String)publishSourceType, (QingContext)GUIMenuDao.this.qingContext, (IDBExcuter)GUIMenuDao.this.dbExcuter));
                            vo.setPublishSourceGroupName(IntegratedHelper.queryFormFullPath((String)rs.getString("ftagid"), (String)publishSourceType, (QingContext)GUIMenuDao.this.qingContext));
                        }
                        catch (IntegratedRuntimeException e) {
                            throw new SQLException(e);
                        }
                    } else {
                        vo.setPublishSourceName(rs.getString("themeName"));
                        vo.setPublishSourceGroupName(rs.getString("themeGroupName"));
                    }
                    vo.setTagId(rs.getString("ftagid"));
                    vo.setCarryData(rs.getBoolean("fcarrydata"));
                    vo.setCreateTime(Long.valueOf(rs.getTimestamp("fcreatetime").getTime()));
                    vo.setUpdateTime(Long.valueOf(rs.getTimestamp("fupdatetime").getTime()));
                    vo.setPreset(IntegratedHelper.getPresetUserId().equals(userId));
                    users = new ArrayList();
                    roles = new ArrayList();
                    vo.setUsers(users);
                    vo.setRoles(roles);
                    listVO.add(vo);
                }
                return listVO;
            }
        });
    }

    public List<PublishVO> loadPublishInfos(final String userId, String path) throws SQLException, AbstractQingIntegratedException {
        StringBuilder sqlSelect = new StringBuilder();
        sqlSelect.append("select p.fid, p.ftype, p.fsource, p.fname, p.fpath,  p.fcreatetime, p.fupdatetime, p.fschemaid , p.fanalysis, p.ftagid, p.fcarrydata, theme.fname as themeName, TQTG.fname as themeGroupName");
        sqlSelect.append(" from T_QING_PUBLISH p left join T_QING_Theme theme on theme.fid = p.ftagid left join t_qing_theme_group tqtg on tqtg.fid = theme.fthemegroupid where p.ftype=? and p.fcreatorId=? and p.fpath = ? order by p.fcreatetime");
        Object[] params = new Object[]{4, userId, path};
        return (List)this.dbExcuter.query(sqlSelect.toString(), params, (ResultHandler)new ResultHandler<List<PublishVO>>(){

            public List<PublishVO> handle(ResultSet rs) throws SQLException {
                ArrayList users = null;
                ArrayList roles = null;
                ArrayList<PublishVO> listVO = new ArrayList<PublishVO>();
                PublishVO vo = null;
                while (rs.next()) {
                    String fid = rs.getString("fid");
                    if (vo != null && fid.equals(vo.getId())) continue;
                    vo = new PublishVO();
                    vo.setId(fid);
                    vo.setPublishTargetType(rs.getInt("ftype"));
                    vo.setName(rs.getString("fname"));
                    vo.setPath(rs.getString("fpath"));
                    vo.setSchemaId(rs.getString("fschemaid"));
                    vo.setCanAnalysis(rs.getBoolean("fanalysis"));
                    String publishSourceType = rs.getString("fsource");
                    vo.setPublishSourceType(publishSourceType);
                    if (PublishSourceEnum.bill.name().equals(publishSourceType) || PublishSourceEnum.control.name().equals(publishSourceType)) {
                        try {
                            vo.setPublishSourceName(IntegratedHelper.queryFormDisplayName((String)rs.getString("ftagid"), (String)publishSourceType, (QingContext)GUIMenuDao.this.qingContext, (IDBExcuter)GUIMenuDao.this.dbExcuter));
                            vo.setPublishSourceGroupName(IntegratedHelper.queryFormFullPath((String)rs.getString("ftagid"), (String)publishSourceType, (QingContext)GUIMenuDao.this.qingContext));
                        }
                        catch (IntegratedRuntimeException e) {
                            throw new SQLException(e);
                        }
                    } else {
                        vo.setPublishSourceName(rs.getString("themeName"));
                        vo.setPublishSourceGroupName(rs.getString("themeGroupName"));
                    }
                    vo.setTagId(rs.getString("ftagid"));
                    vo.setCarryData(rs.getBoolean("fcarrydata"));
                    vo.setCreateTime(Long.valueOf(rs.getTimestamp("fcreatetime").getTime()));
                    vo.setUpdateTime(Long.valueOf(rs.getTimestamp("fupdatetime").getTime()));
                    vo.setPreset(IntegratedHelper.getPresetUserId().equals(userId));
                    users = new ArrayList();
                    roles = new ArrayList();
                    vo.setUsers(users);
                    vo.setRoles(roles);
                    listVO.add(vo);
                }
                return listVO;
            }
        });
    }

    public List<PublishVO> loadPublishInfosForDsb(String path, String userId, Set<String> roleIds) throws SQLException, AbstractQingIntegratedException {
        String sqlInQuestion = "?";
        if (roleIds != null && roleIds.size() > 0) {
            for (int i = 1; i < roleIds.size(); ++i) {
                sqlInQuestion = sqlInQuestion + ",?";
            }
        } else {
            sqlInQuestion = "null";
        }
        String sql = "SELECT DISTINCT FID, FPATH, FNAME, FCREATORID, FSCHEMAID, FTYPE, FANALYSIS, FSOURCE, FTAGID, FCARRYDATA FROM ( SELECT p.FID, p.FNAME, p.FPATH, p.FSCHEMAID, p.FCREATORID, p.FTYPE, p.FANALYSIS, p.FSOURCE, p.FTAGID, p.FCARRYDATA FROM T_QING_PERMPUBLISH perm INNER JOIN T_QING_PUBLISH p ON perm.FPUBLISHID=p.FID WHERE p.FTYPE=? and p.FPATH=? AND ((perm.FVIEWERID=? AND perm.FTYPE='0') OR (perm.FVIEWERID IN (" + sqlInQuestion + ") AND perm.FTYPE='1')) AND (p.FSOURCE = '" + PublishSourceEnum.subject.name() + "' or p.FSOURCE = '" + PublishSourceEnum.bill.name() + "' or p.FSOURCE = '" + PublishSourceEnum.control.name() + "') UNION SELECT p.FID, p.FNAME, p.FPATH, p.FSCHEMAID, p.FCREATORID, p.FTYPE, p.FANALYSIS, p.FSOURCE, p.FTAGID, p.FCARRYDATA FROM T_QING_PUBLISH p\tWHERE p.FCREATORID=? and FPATH=? AND (p.FSOURCE = '" + PublishSourceEnum.subject.name() + "' or p.FSOURCE = '" + PublishSourceEnum.bill.name() + "' or p.FSOURCE = '" + PublishSourceEnum.control.name() + "') ) t WHERE t.FID IS NOT NULL ORDER BY t.FNAME ASC";
        ArrayList<Object> queryValue = new ArrayList<Object>();
        queryValue.add(4);
        queryValue.add(path);
        queryValue.add(userId);
        queryValue.addAll(roleIds);
        queryValue.add(userId);
        queryValue.add(path);
        return (List)this.dbExcuter.query(sql, queryValue.toArray(), (ResultHandler)new ResultHandler<List<PublishVO>>(){

            public List<PublishVO> handle(ResultSet rs) throws SQLException {
                ArrayList<PublishVO> list = new ArrayList<PublishVO>();
                while (rs.next()) {
                    PublishVO vo = new PublishVO();
                    vo.setId(rs.getString("FID"));
                    vo.setPublishTargetType(rs.getInt("FTYPE"));
                    vo.setName(rs.getString("FNAME"));
                    vo.setPath(rs.getString("FPATH"));
                    vo.setSchemaId(rs.getString("FSCHEMAID"));
                    vo.setCanAnalysis(rs.getBoolean("FANALYSIS"));
                    String publishSourceType = rs.getString("FSOURCE");
                    vo.setPublishSourceType(publishSourceType);
                    vo.setTagId(rs.getString("FTAGID"));
                    vo.setCarryData(rs.getBoolean("FCARRYDATA"));
                    vo.setCreatorId(rs.getString("FCREATORID"));
                    list.add(vo);
                }
                return list;
            }
        });
    }

    public List<PublishVO> loadPublishInfosForDsb(String userId, Set<String> roleIds) throws SQLException, AbstractQingIntegratedException {
        final String presetUserId = IntegratedHelper.getPresetUserId();
        String sqlInQuestion = "?";
        if (roleIds != null && roleIds.size() > 0) {
            for (int i = 1; i < roleIds.size(); ++i) {
                sqlInQuestion = sqlInQuestion + ",?";
            }
        } else {
            sqlInQuestion = "null";
        }
        String sql = "SELECT DISTINCT FID, FPATH, FNAME, FCREATORID, FSCHEMAID, FTYPE, FANALYSIS, FSOURCE, FTAGID, FCARRYDATA, FCREATETIME FROM ( SELECT p.FID, p.FNAME, p.FPATH, p.FSCHEMAID, p.FCREATORID, p.FTYPE, p.FANALYSIS, p.FSOURCE, p.FTAGID, p.FCARRYDATA, p.FCREATETIME FROM T_QING_PERMPUBLISH perm INNER JOIN T_QING_PUBLISH p ON perm.FPUBLISHID=p.FID WHERE p.FTYPE=? AND ((perm.FVIEWERID=? AND perm.FTYPE='0') OR (perm.FVIEWERID IN (" + sqlInQuestion + ") AND perm.FTYPE='1')) AND (p.FSOURCE = '" + PublishSourceEnum.subject.name() + "' or p.FSOURCE = '" + PublishSourceEnum.bill.name() + "' or p.FSOURCE = '" + PublishSourceEnum.control.name() + "') UNION SELECT p.FID, p.FNAME, p.FPATH, p.FSCHEMAID, p.FCREATORID, p.FTYPE, p.FANALYSIS, p.FSOURCE, p.FTAGID, p.FCARRYDATA, p.FCREATETIME FROM T_QING_PUBLISH p\tWHERE p.FCREATORID=? AND p.FTYPE=? AND (p.FSOURCE = '" + PublishSourceEnum.subject.name() + "' or p.FSOURCE = '" + PublishSourceEnum.bill.name() + "' or p.FSOURCE = '" + PublishSourceEnum.control.name() + "') ) t WHERE t.FID IS NOT NULL ORDER BY t.FNAME ASC";
        ArrayList<Object> queryValue = new ArrayList<Object>();
        queryValue.add(4);
        queryValue.add(userId);
        queryValue.addAll(roleIds);
        queryValue.add(userId);
        queryValue.add(4);
        return (List)this.dbExcuter.query(sql, queryValue.toArray(), (ResultHandler)new ResultHandler<List<PublishVO>>(){

            public List<PublishVO> handle(ResultSet rs) throws SQLException {
                ArrayList<PublishVO> list = new ArrayList<PublishVO>();
                while (rs.next()) {
                    PublishVO vo = new PublishVO();
                    vo.setId(rs.getString("FID"));
                    vo.setPublishTargetType(rs.getInt("FTYPE"));
                    vo.setName(rs.getString("FNAME"));
                    vo.setPath(rs.getString("FPATH"));
                    vo.setSchemaId(rs.getString("FSCHEMAID"));
                    vo.setCanAnalysis(rs.getBoolean("FANALYSIS"));
                    String publishSourceType = rs.getString("FSOURCE");
                    vo.setPublishSourceType(publishSourceType);
                    vo.setTagId(rs.getString("FTAGID"));
                    vo.setCarryData(rs.getBoolean("FCARRYDATA"));
                    vo.setCreatorId(rs.getString("FCREATORID"));
                    vo.setPreset(presetUserId.equals(rs.getString("FCREATORID")));
                    vo.setCreateTime(Long.valueOf(rs.getTimestamp("FCREATETIME").getTime()));
                    list.add(vo);
                }
                return list;
            }
        });
    }
}

