/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.guimenu.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.publish.appmenu.exception.AppMenuException;
import com.kingdee.bos.qing.publish.appmenu.model.AppmenuPublishWithPublishName;
import com.kingdee.bos.qing.publish.domain.AbstractPublishManageDomain;
import com.kingdee.bos.qing.publish.exception.PublishException;
import com.kingdee.bos.qing.publish.guimenu.dao.GUIMenuDao;
import com.kingdee.bos.qing.publish.guimenu.exception.GUIMenuException;
import com.kingdee.bos.qing.publish.integrated.model.TreeMenuFolderNode;
import com.kingdee.bos.qing.publish.model.PublishVO;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.util.IntegratedHelper;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GUIMenuManageDomain
extends AbstractPublishManageDomain {
    private GUIMenuDao guiMenuDao;

    public GUIMenuManageDomain(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter, IScheduleEngine scheduleEngine) {
        super(qingContext, tx, dbExcuter, scheduleEngine);
        this.guiMenuDao = new GUIMenuDao(qingContext, dbExcuter);
    }

    public TreeMenuFolderNode getGUIMenuTree(boolean isManage, boolean isRefresh) throws GUIMenuException, AbstractQingIntegratedException {
        try {
            TreeMenuFolderNode appCenterMenuTree = this.guiMenuDao.getGUIMenuTree(isRefresh);
            if (isManage) {
                List allPaths = this.getPublishInfoDao().loadAllPublishPath(this.qingContext.getUserId(), 4);
                boolean isCurrentUserInQingAdminRole = IntegratedHelper.isCurrentUserInQingAdminRole((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter);
                if (isCurrentUserInQingAdminRole) {
                    List allPresetPaths = this.getPublishInfoDao().loadAllPublishPath(IntegratedHelper.getPresetUserId(), 4);
                    allPaths.addAll(0, allPresetPaths);
                }
                return TreeMenuFolderNode.rebulidMenuTree(appCenterMenuTree, allPaths);
            }
            return appCenterMenuTree;
        }
        catch (SQLException e) {
            throw new GUIMenuException(e.getMessage(), e);
        }
    }

    public List<PublishVO> loadPublishInfos(String path) throws AbstractQingIntegratedException, GUIMenuException {
        try {
            String userId = this.qingContext.getUserId();
            List<PublishVO> publishVOs = this.guiMenuDao.loadPublishInfos(userId, path);
            boolean isCurrentUserInQingAdminRole = IntegratedHelper.isCurrentUserInQingAdminRole((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter);
            if (isCurrentUserInQingAdminRole) {
                List<PublishVO> presetPublishVOs = this.guiMenuDao.loadPublishInfos(IntegratedHelper.getPresetUserId(), path);
                publishVOs.addAll(0, presetPublishVOs);
            }
            this.buildTreeMenuFolderNode(publishVOs);
            return publishVOs;
        }
        catch (PublishException e) {
            throw new GUIMenuException(e.getMessage(), e);
        }
        catch (SQLException e) {
            throw new GUIMenuException(e.getMessage(), e);
        }
    }

    public List<PublishVO> loadAllPublishInfos() throws AbstractQingIntegratedException, PublishException {
        try {
            String userId = this.qingContext.getUserId();
            List<PublishVO> publishVOs = this.guiMenuDao.loadAllPublishInfos(userId);
            boolean isCurrentUserInQingAdminRole = IntegratedHelper.isCurrentUserInQingAdminRole((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter);
            if (isCurrentUserInQingAdminRole) {
                List<PublishVO> presetPublishVOs = this.guiMenuDao.loadAllPublishInfos(IntegratedHelper.getPresetUserId());
                publishVOs.addAll(0, presetPublishVOs);
            }
            this.buildTreeMenuFolderNode(publishVOs);
            this.setPublishPermissionInfo(publishVOs);
            return publishVOs;
        }
        catch (SQLException e) {
            throw new AppMenuException(e.getMessage(), e);
        }
    }

    private void buildTreeMenuFolderNode(List<PublishVO> publishVOs) throws PublishException, AbstractQingIntegratedException, SQLException {
        if (publishVOs != null && !publishVOs.isEmpty()) {
            for (int i = 0; i < publishVOs.size(); ++i) {
                this.setPublishPermissionInfo(publishVOs.get(i));
            }
            TreeMenuFolderNode appCenterMenuTree = this.guiMenuDao.getGUIMenuTree(false);
            for (PublishVO vo : publishVOs) {
                String allPath = vo.getPath();
                allPath = allPath.replaceFirst("/EAS_GUI_CENTER_ROOT_UUID", "");
                String pathText = TreeMenuFolderNode.buildPathText(appCenterMenuTree, allPath);
                vo.setPathText(pathText);
            }
        }
    }

    public Map<String, Object> getGUITreeForDsb() throws AppMenuException, AbstractQingIntegratedException, GUIMenuException {
        try {
            TreeMenuFolderNode appCenterMenuTree = this.guiMenuDao.getGUIMenuTree(false);
            String userId = this.qingContext.getUserId();
            List allPaths = this.getPublishInfoDao().loadPublishForDsb(userId, IntegratedHelper.getUserRoleIds((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter), 4);
            TreeMenuFolderNode root = TreeMenuFolderNode.rebulidMenuTree(appCenterMenuTree, allPaths);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("appmenu", root);
            result.put("publish", this.loadPublishInfosForDsb(null));
            return result;
        }
        catch (SQLException e) {
            throw new AppMenuException(e.getMessage(), e);
        }
    }

    public List<AppmenuPublishWithPublishName> loadPublishInfosForDsb(String path) throws AbstractQingIntegratedException, GUIMenuException {
        try {
            String userId = this.qingContext.getUserId();
            List<PublishVO> publishVOs = null;
            publishVOs = path == null ? this.guiMenuDao.loadPublishInfosForDsb(userId, IntegratedHelper.getUserRoleIds((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter)) : this.guiMenuDao.loadPublishInfosForDsb(path, userId, IntegratedHelper.getUserRoleIds((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter));
            ArrayList<AppmenuPublishWithPublishName> appmenuPublishWithPublishNames = new ArrayList<AppmenuPublishWithPublishName>();
            if (publishVOs != null && !publishVOs.isEmpty()) {
                for (int i = 0; i < publishVOs.size(); ++i) {
                    PublishVO publishVO = publishVOs.get(i);
                    this.setPublishPermissionInfo(publishVOs.get(i));
                    AppmenuPublishWithPublishName appmenuPublishWithPublishName = new AppmenuPublishWithPublishName();
                    String publishPersonName = IntegratedHelper.getUserName((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (String)publishVO.getCreatorId());
                    appmenuPublishWithPublishName.setPublishVO(publishVO);
                    appmenuPublishWithPublishName.setPublisherName(publishPersonName);
                    appmenuPublishWithPublishNames.add(appmenuPublishWithPublishName);
                }
                TreeMenuFolderNode appCenterMenuTree = this.guiMenuDao.getGUIMenuTree(false);
                for (PublishVO vo : publishVOs) {
                    String allPath = vo.getPath();
                    allPath = allPath.replaceFirst("/EAS_GUI_CENTER_ROOT_UUID", "");
                    String pathText = TreeMenuFolderNode.buildPathText(appCenterMenuTree, allPath);
                    vo.setPathText(pathText);
                }
            }
            return appmenuPublishWithPublishNames;
        }
        catch (PublishException e) {
            throw new GUIMenuException(e.getMessage(), e);
        }
        catch (SQLException e) {
            throw new GUIMenuException(e.getMessage(), e);
        }
    }
}

