/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.guimenu.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.imexport.model.po.AbstractPublishModel;
import com.kingdee.bos.qing.manage.exception.ExportThemeException;
import com.kingdee.bos.qing.manage.exception.ImportThemeException;
import com.kingdee.bos.qing.manage.exception.ThemeManagementException;
import com.kingdee.bos.qing.manage.imexport.collector.ICollectable;
import com.kingdee.bos.qing.manage.imexport.collector.PublishDsbCollectorGetter;
import com.kingdee.bos.qing.manage.imexport.collector.common.PublishInfoCollector;
import com.kingdee.bos.qing.manage.imexport.collector.dashboard.publish.PublishDsbModelCollector;
import com.kingdee.bos.qing.manage.imexport.collector.dashboard.publish.PublishDsbPictuerCollector;
import com.kingdee.bos.qing.manage.imexport.collector.dashboard.publish.PublishDsbPicturePropertyCollector;
import com.kingdee.bos.qing.manage.imexport.collector.dashboard.publish.PublishDsbRefCollector;
import com.kingdee.bos.qing.manage.imexport.collector.dashboard.publish.PublishDsbWidgetSchemaCollector;
import com.kingdee.bos.qing.manage.imexport.collector.dashboard.publish.PublishDsbWidgetSchemaPropertyCollector;
import com.kingdee.bos.qing.manage.imexport.collector.subject.publish.PublishBoxCollector;
import com.kingdee.bos.qing.manage.imexport.collector.subject.publish.PublishQsFileCollector;
import com.kingdee.bos.qing.manage.imexport.collector.subject.publish.PublishQsPropertyCollector;
import com.kingdee.bos.qing.manage.imexport.collector.subject.publish.PublishSchemaCollector;
import com.kingdee.bos.qing.manage.imexport.collector.subject.publish.PublishShcemaPropertyCollector;
import com.kingdee.bos.qing.manage.imexport.model.po.IDashboardExportFilePathGetter;
import com.kingdee.bos.qing.manage.imexport.model.po.ISubjectExportFilePathGetter;
import com.kingdee.bos.qing.manage.imexport.model.runtime.AbstractPublishImportModel;
import com.kingdee.bos.qing.manage.imexport.model.runtime.AbstractThemeImportModel;
import com.kingdee.bos.qing.manage.imexport.model.runtime.DashboardPublishImportModel;
import com.kingdee.bos.qing.manage.imexport.model.runtime.SubjectPublishImportModel;
import com.kingdee.bos.qing.manage.imexport.model.vo.ExportPublishConflictVO;
import com.kingdee.bos.qing.manage.model.ThemeVO;
import com.kingdee.bos.qing.programablecard.imexport.collector.dashboard.publish.PublishDsbProgramableCardCollector;
import com.kingdee.bos.qing.programablecard.imexport.collector.dashboard.publish.PublishDsbProgramableCardPropertyCollector;
import com.kingdee.bos.qing.publish.exception.PublishNameDuplicateException;
import com.kingdee.bos.qing.publish.exception.PublishSameSourceNameDuplicateException;
import com.kingdee.bos.qing.publish.guimenu.dao.GUIMenuDao;
import com.kingdee.bos.qing.publish.guimenu.model.GUIMenuPublishModel;
import com.kingdee.bos.qing.publish.integrated.model.TreeMenuFolderNode;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.model.PublishTarget;
import com.kingdee.bos.qing.publish.target.AbstractPublishTargetImexportDomain;
import com.kingdee.bos.qing.publish.util.PublishUtil;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.jdom2.Element;

public class GUIMenuPublishTargetImexportDomain
extends AbstractPublishTargetImexportDomain {
    private GUIMenuDao guiMenuDao;

    public GUIMenuPublishTargetImexportDomain(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter, IScheduleEngine scheduleEngine) {
        super(qingContext, tx, dbExcuter, scheduleEngine);
        this.guiMenuDao = new GUIMenuDao(qingContext, dbExcuter);
    }

    public AbstractPublishModel createNewPublishModel() {
        return new GUIMenuPublishModel();
    }

    public void doExportPublishInfo(ZipOutputStream zos, String themeGroupName, PublishPO publishPo, ThemeVO themeVO, String themeFolderPath) throws ThemeManagementException, AbstractQingIntegratedException {
        try {
            String publishFloder = UUID.randomUUID().toString();
            PublishSourceEnum publishSourceType = publishPo.getPublishSourceType();
            GUIMenuPublishModel guiMenuPublishModel = (GUIMenuPublishModel)this.initPublishModel(publishPo, themeGroupName, themeVO);
            String publishPrefixPath = themeFolderPath + File.separator + "easguimenu" + File.separator + publishFloder;
            String publishFloderPath = null;
            if (publishSourceType == PublishSourceEnum.subject) {
                publishFloderPath = publishPrefixPath + File.separator + "subject-pub-eas-guimenu.xml";
                this.getSubjectPublishSourceDomain().doExport(zos, publishPo, publishPrefixPath, (ISubjectExportFilePathGetter)guiMenuPublishModel);
            } else if (publishSourceType == PublishSourceEnum.dashboard) {
                publishFloderPath = publishPrefixPath + File.separator + "dsb-pub-eas-guimenu.xml";
                this.getDashboardPublishSourceDomain().doExport(zos, publishPo.getId(), publishPrefixPath, (IDashboardExportFilePathGetter)guiMenuPublishModel);
            }
            Element propertyElement = guiMenuPublishModel.toXml();
            zos.putNextEntry(new ZipEntry(publishFloderPath));
            XmlUtil.save((Element)propertyElement, (OutputStream)zos);
        }
        catch (SQLException e) {
            throw new ExportThemeException((Throwable)e);
        }
        catch (IOException e) {
            throw new ExportThemeException((Throwable)e);
        }
    }

    public final void collectPublishInfo(ZipInputStream zis, String[] zipEntry, AbstractThemeImportModel exportThemeCollectModel) throws ImportThemeException, AbstractQingIntegratedException {
        if (zipEntry != null && zipEntry.length >= 3 && "easguimenu".equals(zipEntry[2])) {
            String entryName = zipEntry[zipEntry.length - 1];
            Object collector = null;
            collector = "subject-pub-eas-guimenu.xml".equals(entryName) ? new PublishInfoCollector((AbstractPublishModel)new GUIMenuPublishModel(), (AbstractPublishImportModel)new SubjectPublishImportModel()) : ("dsb-pub-eas-guimenu.xml".equals(entryName) ? new PublishInfoCollector((AbstractPublishModel)new GUIMenuPublishModel(), (AbstractPublishImportModel)new DashboardPublishImportModel()) : PublishDsbCollectorGetter.getCollector((String)entryName));
            if (collector != null) {
                collector.collect(zis, zipEntry, exportThemeCollectModel);
            }
        }
    }

    public void doImportPublishInfo(AbstractThemeImportModel themeImportModel, AbstractPublishImportModel publishImportModel, List<IQingFile> saveSuccessFiles) throws ThemeManagementException, AbstractQingIntegratedException {
        String themeId = themeImportModel.getThemeID();
        AbstractPublishModel publishModel = publishImportModel.getPublishModel();
        String publishId = PublishUtil.getPublishId((String)UUID.randomUUID().toString());
        String schemaId = this.getSchemaManageDao().genSchemaId();
        publishModel.setSchemaId(schemaId);
        publishModel.setPublishId(publishId);
        publishModel.setTagId(themeId);
        try {
            PublishPO publishPo = new PublishPO();
            this.savePublishImportInfo(themeImportModel, publishImportModel, publishPo, saveSuccessFiles);
            if ("0".equals(themeImportModel.getThemeType())) {
                String publishFolderPathName_old = this.getPathName_old(publishModel.getPath());
                String publishFolderPathName = this.getPathName(publishModel.getPath());
                String appMenyPath = themeImportModel.getNameSpace() + "/" + publishFolderPathName + "/" + publishModel.getName();
                String appMenyPath_old = themeImportModel.getNameSpace() + "/" + publishFolderPathName_old + "/" + publishModel.getName();
                themeImportModel.getImportGUIMenuPathAndId().put(appMenyPath, publishId);
                themeImportModel.getImportGUIMenuPathAndId().put(appMenyPath_old, publishId);
            }
        }
        catch (PublishNameDuplicateException e) {
            this.doPublishNameDuplicate(themeImportModel, publishModel);
        }
        catch (PublishSameSourceNameDuplicateException e) {
            this.doPublishNameDuplicate(themeImportModel, publishModel);
        }
        catch (SQLException e) {
            throw new ImportThemeException((Throwable)e);
        }
    }

    private void doPublishNameDuplicate(AbstractThemeImportModel themeImportModel, AbstractPublishModel publishModel) throws ImportThemeException, AbstractQingIntegratedException {
        try {
            String userId = this.qingContext.getUserId();
            ThemeVO themeVO = this.getThemeDao().loadThemeIncludePreset(userId, publishModel.getTagId());
            String themeName = themeVO.getThemeName();
            TreeMenuFolderNode guiMenuTree = this.guiMenuDao.getGUIMenuTree(false);
            String publishFolderPathName = TreeMenuFolderNode.buildPathText(guiMenuTree, publishModel.getPath());
            ExportPublishConflictVO exportPublicConflict = new ExportPublishConflictVO();
            String publishPath = Messages.getMLS((QingContext)this.qingContext, (String)"guiMenu", (String)"GUI\u83dc\u5355", (Messages.ProjectName)Messages.ProjectName.QING_THEME) + " : " + publishFolderPathName + publishModel.getName();
            exportPublicConflict.setThemeName(themeName);
            exportPublicConflict.setThemeType(themeVO.getThemeType());
            exportPublicConflict.setPublishPath(publishPath);
            themeImportModel.getConfilctPublishList().add(exportPublicConflict);
        }
        catch (SQLException e) {
            throw new ImportThemeException((Throwable)e);
        }
    }

    private String getPathName_old(String path) throws SQLException {
        TreeMenuFolderNode guiMenuTree = this.guiMenuDao.getGUIMenuTree(false);
        String publishFolderPathName = TreeMenuFolderNode.buildPathText(guiMenuTree, path);
        publishFolderPathName = publishFolderPathName.replaceAll("/", "-");
        return publishFolderPathName;
    }

    private String getPathName(String path) throws SQLException {
        TreeMenuFolderNode guiMenuTree = this.guiMenuDao.getGUIMenuTree(false);
        path = path.replaceFirst("/EAS_GUI_CENTER_ROOT_UUID", "");
        String publishFolderPathName = TreeMenuFolderNode.buildPathText(guiMenuTree, path);
        publishFolderPathName = publishFolderPathName.replaceAll("/", "-");
        return publishFolderPathName;
    }

    public PublishPO loadNewPublishPO(PublishTarget publishTarget, Map<String, String> tempFile) throws AbstractQingIntegratedException, SQLException {
        PublishPO publishPO = new PublishPO();
        publishPO.setPath(publishTarget.getPath());
        return publishPO;
    }

    public void doPublishNameDuplicate(List<ExportPublishConflictVO> confilctPublishList, ThemeVO themeVO, String importPath, String publishName) throws AbstractQingIntegratedException, ImportThemeException {
        try {
            TreeMenuFolderNode guiMenuTree = this.guiMenuDao.getGUIMenuTree(false);
            String publishFolderPathName = TreeMenuFolderNode.buildPathText(guiMenuTree, importPath);
            ExportPublishConflictVO exportPublicConflict = new ExportPublishConflictVO();
            String publishPath = Messages.getMLS((QingContext)this.qingContext, (String)"guiMenu", (String)"GUI\u83dc\u5355", (Messages.ProjectName)Messages.ProjectName.QING_THEME) + " : " + publishFolderPathName + publishName;
            exportPublicConflict.setThemeName(themeVO.getThemeName());
            exportPublicConflict.setThemeType(themeVO.getThemeType());
            exportPublicConflict.setPublishPath(publishPath);
            confilctPublishList.add(exportPublicConflict);
        }
        catch (SQLException e) {
            throw new ImportThemeException((Throwable)e);
        }
    }

    static {
        PublishDsbCollectorGetter.registerCollector((String)"dsb-pub-eas-guimenu-ref.xml", (ICollectable)new PublishDsbRefCollector());
        PublishDsbCollectorGetter.registerCollector((String)"dsb-pub-eas-guimenu.model", (ICollectable)new PublishDsbModelCollector());
        PublishDsbCollectorGetter.registerCollector((String)"dsb-pub-eas-guimenu-schema.xml", (ICollectable)new PublishDsbWidgetSchemaPropertyCollector());
        PublishDsbCollectorGetter.registerCollector((String)"dsb-pub-eas-guimenu.schema", (ICollectable)new PublishDsbWidgetSchemaCollector());
        PublishDsbCollectorGetter.registerCollector((String)"dsb-pub-eas-guimenu-picture.xml", (ICollectable)new PublishDsbPicturePropertyCollector());
        PublishDsbCollectorGetter.registerCollector((String)"dsb-pub-eas-guimenu-picture", (ICollectable)new PublishDsbPictuerCollector());
        PublishDsbCollectorGetter.registerCollector((String)"dsb-pub-eas-guimenu-programablecard.xml", (ICollectable)new PublishDsbProgramableCardPropertyCollector());
        PublishDsbCollectorGetter.registerCollector((String)"dsb-pub-eas-guimenu-programablecard", (ICollectable)new PublishDsbProgramableCardCollector());
        PublishDsbCollectorGetter.registerCollector((String)"subject-pub-eas-guimenu-schema.xml", (ICollectable)new PublishShcemaPropertyCollector());
        PublishDsbCollectorGetter.registerCollector((String)"subject-pub-eas-guimenu.schema", (ICollectable)new PublishSchemaCollector());
        PublishDsbCollectorGetter.registerCollector((String)"eas-guimenu_qs.xml", (ICollectable)new PublishQsPropertyCollector());
        PublishDsbCollectorGetter.registerCollector((String)"eas-guimenu.qs", (ICollectable)new PublishQsFileCollector());
        PublishDsbCollectorGetter.registerCollector((String)"eas-guimenu.model", (ICollectable)new PublishBoxCollector());
    }
}

