/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.lapp;

import com.kingdee.bos.Context;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.context.QingIntegratedContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.imexport.importer.LappTargetPublishImporter;
import com.kingdee.bos.qing.imexport.importer.pkg.publish.PublishImporterFactory;
import com.kingdee.bos.qing.publish.PublishManageDomianFactory;
import com.kingdee.bos.qing.publish.PublishServcieFactory;
import com.kingdee.bos.qing.publish.lapp.domain.LappContextDomain;
import com.kingdee.bos.qing.publish.lapp.model.DatacenterModel;
import com.kingdee.bos.qing.publish.lapp.model.LappContextModel;
import com.kingdee.bos.qing.publish.lapp.model.LappUser;
import com.kingdee.bos.qing.publish.lapp.util.LappContextUtils;
import com.kingdee.bos.qing.publish.lapp.util.UserContextConverter;
import com.kingdee.bos.qing.publish.model.PermissionInfo;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.target.PublishTargetDomainFactory;
import com.kingdee.bos.qing.publish.target.lapp.AbstractLappService;
import com.kingdee.bos.qing.publish.target.lapp.LappDomain;
import com.kingdee.bos.qing.publish.target.lapp.LappPublishTargetDomain;
import com.kingdee.bos.qing.publish.target.lapp.LappSyncDomain;
import com.kingdee.bos.qing.publish.target.lapp.model.LappContext;
import com.kingdee.bos.qing.publish.target.lapp.model.PublishLappConfigVO;
import com.kingdee.bos.qing.publish.target.lapp.model.ThirdPartyConfig;
import com.kingdee.bos.qing.publish.target.lapp.push.PushTargetType;
import com.kingdee.bos.qing.publish.target.lapp.push.chatrobot.wxqyh.WxqyhRobotPushAppInfo;
import com.kingdee.bos.qing.publish.target.lapp.strategy.ILappStrategy;
import com.kingdee.bos.qing.publish.target.lapp.util.LappHelper;
import com.kingdee.bos.qing.publish.util.PublishUtil;
import com.kingdee.bos.qing.response.IResponseWrap;
import com.kingdee.bos.qing.response.ResponseSuccessWrap;
import com.kingdee.bos.qing.response.ResponseUtil;
import com.kingdee.bos.qing.schedule.executer.impl.PushScheduleExecuter;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.base.common.DCManager;
import com.kingdee.eas.base.license.LicenseBaseInfo;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EASLappService
extends AbstractLappService {
    public static final String EAS_PRODUCT_TYPE = "EAS";
    private LappContextDomain lappContextDomain;
    private PushScheduleExecuter pushScheduleExecuter;

    public static void regist() {
        PublishServcieFactory.registPublishServcie((int)2, EASLappService.class);
        PublishTargetDomainFactory.registPublishTargetDomain((int)2, LappPublishTargetDomain.class);
        PublishManageDomianFactory.registPublishManageDomain((Integer)2, LappDomain.class);
        PublishImporterFactory.regist((int)2, LappTargetPublishImporter.class);
    }

    private QingIntegratedContext getQingIntegratedContext() {
        return (QingIntegratedContext)this.qingContext;
    }

    private LappContextDomain getLappContextDomain() {
        if (this.lappContextDomain == null) {
            this.lappContextDomain = new LappContextDomain(this.qingContext, this.dbExcuter, this.tx, this.scheduleEngine);
            this.lappContextDomain.setLappDomain(this.getPublishManageDomain());
        }
        return this.lappContextDomain;
    }

    private PushScheduleExecuter getPushScheduleExecuter() {
        if (this.pushScheduleExecuter == null) {
            this.pushScheduleExecuter = new PushScheduleExecuter();
            this.pushScheduleExecuter.setDbExcuter(this.dbExcuter);
            this.pushScheduleExecuter.setQingContext(this.qingContext);
            this.pushScheduleExecuter.setTx(this.tx);
            this.pushScheduleExecuter.setScheduleEngine(this.scheduleEngine);
        }
        return this.pushScheduleExecuter;
    }

    public byte[] getLappContext(Map<String, String> params) {
        try {
            String datacenterUUID = this.getLappSyncDomain().getSyncedDatacenterUUID();
            String appType = params.get("appType");
            Context ctx = this.getQingIntegratedContext().getBosContext();
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            String userId = userInfo.getId().toString();
            ArrayList<PublishLappConfigVO> publishLappConfigVOs = new ArrayList<PublishLappConfigVO>();
            LappContext lappContext = this.getLappContextDomain().getLappContext(ctx, appType, publishLappConfigVOs);
            LappContextModel lappContextModel = new LappContextModel();
            lappContextModel.setScene(EAS_PRODUCT_TYPE);
            lappContextModel.setEid(lappContext.getCorpId());
            lappContextModel.setLappUserId(lappContext.getLappUserId());
            lappContextModel.setLappUserType(lappContext.getLappUserType());
            lappContextModel.setUserName(userInfo.getName());
            lappContextModel.setAccountId(this.getQingIntegratedContext().getAccountId());
            lappContextModel.setServerHostUrl(LappHelper.getServerHostUrl());
            lappContextModel.setAppId(LappHelper.getAppId());
            lappContextModel.setMobileServerHostUrl(LappHelper.getMobileServerHostUrl());
            lappContextModel.setDatacenterUUID(datacenterUUID);
            boolean isQingAdminRole = IntegratedHelper.isCurrentUserInQingAdminRole((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter);
            lappContextModel.setQingAdminRole(isQingAdminRole);
            if (isQingAdminRole) {
                lappContextModel.setQingAdminRoleUserId(IntegratedHelper.getPresetUserId());
            }
            if (datacenterUUID != null && isQingAdminRole) {
                lappContextModel.setDatacenterEditor(true);
            }
            lappContextModel.setConfiguredPublishUrlPrefix(LappHelper.getConfiguredPublishUrlPrefix());
            lappContextModel.setExtraPublishUrlParamMap(new HashMap<String, String>());
            lappContextModel.setPublishLappConfigs(publishLappConfigVOs);
            lappContextModel.setSupportYzjImmediateExecution(LappContextUtils.supportYzjImmediateExecution());
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)lappContextModel));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] getShareContext(Map<String, String> params) {
        throw new UnsupportedOperationException("EAS\u4e0d\u652f\u6301 \u4e91\u4e4b\u5bb6\u5206\u4eab\u6d88\u606f");
    }

    public byte[] loadPushContext(Map<String, String> params) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        ILappStrategy lappStrategyImpl = (ILappStrategy)CustomStrategyRegistrar.getStrategy(ILappStrategy.class);
        WxqyhRobotPushAppInfo wxqyhAppInfo = lappStrategyImpl.getWxqyhAppInfo(this.dbExcuter);
        if (StringUtils.isNotEmpty((CharSequence)wxqyhAppInfo.getCorpId()) && StringUtils.isNotEmpty((CharSequence)wxqyhAppInfo.getAgentId())) {
            result.put(String.valueOf(PushTargetType.WXQYH_ROBOT.toPersistance()), true);
        }
        if (lappStrategyImpl.getMissonCloudServiceAccount() != null) {
            result.put(String.valueOf(PushTargetType.MISSION_CLOUD_SERVICE_ACCOUNT.toPersistance()), true);
        }
        return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(result));
    }

    public byte[] getLappContextsByIds(Map<String, String> params) {
        try {
            Context ctx = this.getQingIntegratedContext().getBosContext();
            String appType = params.get("appType");
            List userIds = (List)JsonUtil.decodeFromString((String)params.get("userIds"), List.class);
            AbstractLappService.LappContextResult result = this.getLappContextDomain().getLappContextsByIds(ctx, userIds, appType);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)result));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] getUserIdsByRoleId(Map<String, String> params) {
        ArrayList userInfos = new ArrayList();
        try {
            String roleIdStr = params.get("roleId");
            List roleIds = (List)JsonUtil.decodeFromString((String)roleIdStr, List.class);
            for (int i = 0; i < roleIds.size(); ++i) {
                String roleId = (String)roleIds.get(i);
                userInfos.addAll(IntegratedHelper.getUserIdsByRoleId((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (String)roleId));
            }
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
        return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(userInfos));
    }

    public LappContext getLappContext() {
        Context ctx = this.getQingIntegratedContext().getBosContext();
        return this.getLappContextDomain().getLappContext(ctx);
    }

    public byte[] checkSameSource(Map<String, String> params) {
        String publishId = params.get("publishId");
        String sourceId = params.get("sourceId");
        try {
            PublishPO oldInfo;
            PublishPO publishPO = this.getPublishManageDomain().checkSameSource(publishId);
            List permissionInfos = this.getPublishManageDomain().loadPublishPermissionInfo(publishId);
            HashSet<String> allUserId = new HashSet<String>();
            for (PermissionInfo permissionInfo : permissionInfos) {
                if (permissionInfo.getType() == 0) {
                    allUserId.add(permissionInfo.getViewerId());
                    continue;
                }
                if (permissionInfo.getType() != 1) continue;
                allUserId.addAll(IntegratedHelper.getUserIdsByRoleId((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (String)permissionInfo.getViewerId()));
            }
            if (sourceId != null && PublishUtil.isPublish((String)sourceId) && (oldInfo = this.getPublishInfoDao().getPublishInfoByInfoId(sourceId)) != null) {
                sourceId = oldInfo.getTagId();
            }
            boolean sameSource = true;
            if (publishPO != null) {
                sameSource = publishPO.getTagId().equals(sourceId);
            }
            HashMap<String, Serializable> result = new HashMap<String, Serializable>();
            result.put("sameSource", Boolean.valueOf(sameSource));
            result.put("permissionId", allUserId);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(result);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] doPush(Map<String, String> params) {
        String configId = params.get("configId");
        String timeStamp = params.get("timeStamp");
        String paramPathPrefix = params.get("paramPathPrefix");
        try {
            Context ctx = this.getQingIntegratedContext().getBosContext();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("sourceId", configId);
            map.put("timeStamp", timeStamp);
            map.put("paramPathPrefix", paramPathPrefix);
            this.getPushScheduleExecuter().execute(ctx, JsonUtil.encodeToString(map), this.qingContext.getUserId(), "");
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)true));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] getServerTimeStampForDoPush(Map<String, String> params) {
        try {
            String timeStamp = this.getPushScheduleExecuter().getServerTimeStampForDoPush();
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)timeStamp));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] getServerTimeStamp(Map<String, String> params) {
        try {
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)(System.currentTimeMillis() + ""));
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadThirdPartyConfig(Map<String, String> params) {
        ArrayList<ThirdPartyConfig.AppUserType> appUserTypes = new ArrayList<ThirdPartyConfig.AppUserType>();
        appUserTypes.add(ThirdPartyConfig.AppUserType.USER_NAME);
        appUserTypes.add(ThirdPartyConfig.AppUserType.PHONE);
        Context ctx = this.getQingIntegratedContext().getBosContext();
        String licenseCode = "";
        try {
            LicenseBaseInfo licenseBaseInfo = LicenseSrvAgentFactory.getLocalInstance((Context)ctx).getLicenseBaseInfo();
            licenseCode = licenseBaseInfo.getSerialNum();
        }
        catch (LicenseException e) {
            LogUtil.error((String)"get license code failed!", (Throwable)e);
        }
        try {
            ThirdPartyConfig thirdPartyConfig = this.getPublishManageDomain().loadThirdPartyConfig();
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("thirdPartyConfig", thirdPartyConfig);
            result.put("appUserTypes", appUserTypes);
            result.put("licenseCode", licenseCode);
            result.put("timestamp", UserContextConverter.RSAEncryptUtils.encryptByPublicKey(String.valueOf(System.currentTimeMillis())));
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(result));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadDatacenterInfo(Map<String, String> params) {
        try {
            Map<String, DatacenterModel> result = null;
            Context ctx = this.getQingIntegratedContext().getBosContext();
            String accountName = this.getAccountName(ctx);
            if (StringUtils.isBlank((CharSequence)accountName)) {
                result = new HashMap<String, Boolean>();
                result.put("isNeedSync", (DatacenterModel)((Object)Boolean.valueOf(false)));
            } else {
                LappSyncDomain lappSyncDomain = this.getLappSyncDomain();
                result = lappSyncDomain.loadDatacenterInfoMap();
                DatacenterModel datacenterModel = this.getDatacenterModel((String)result.get("datacenterUUID"), accountName);
                result.put("datacenterInfo", datacenterModel);
            }
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(result));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    private DatacenterModel getDatacenterModel(String datacenterUUID, String accountName) {
        DatacenterModel datacenterModel = new DatacenterModel();
        datacenterModel.setDatacenterUUID(datacenterUUID);
        datacenterModel.setAccountName(accountName);
        datacenterModel.setProductType(EAS_PRODUCT_TYPE);
        return datacenterModel;
    }

    private String getAccountName(Context ctx) {
        String accountName = null;
        try {
            ArrayList dcList = DCManager.getInstance().getDCList();
            for (DCInfo dcInfo : dcList) {
                if (!ctx.getAIS().equals(dcInfo.getNumber())) continue;
                accountName = dcInfo.getName("L2");
                if (StringUtils.isBlank((CharSequence)accountName)) {
                    accountName = dcInfo.getName("L3");
                }
                if (StringUtils.isBlank((CharSequence)accountName)) {
                    accountName = dcInfo.getName("L1");
                }
                break;
            }
        }
        catch (Exception e) {
            LogUtil.error((String)"\u83b7\u53d6\u8d26\u5957\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
        return accountName;
    }

    public byte[] loadPermissionLappContexts(Map<String, String> params) {
        try {
            Context ctx = this.getQingIntegratedContext().getBosContext();
            String appType = params.get("appType");
            List publishIds = (List)JsonUtil.decodeFromString((String)params.get("publishIds"), List.class);
            HashMap<String, Set<String>> permissionUserMap = new HashMap<String, Set<String>>();
            HashSet<String> allUserIds = new HashSet<String>();
            HashSet roleNames = new HashSet();
            this.getPublishManageDomain().collectPermissionUserInfos(permissionUserMap, allUserIds, roleNames, publishIds);
            Map<String, Object> result = this.getLappContextDomain().loadPermissionLappContexts(ctx, permissionUserMap, allUserIds, appType);
            result.put("roleNames", roleNames);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(result));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] getAllLappContextsByUserIds(Map<String, String> params) {
        try {
            List userIds = (List)JsonUtil.decodeFromString((String)params.get("userIds"), List.class);
            Context ctx = this.getQingIntegratedContext().getBosContext();
            Map<String, List<LappUser>> result = this.getLappContextDomain().getAllLappContextsByUserIds(ctx, userIds);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(result));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }
}

