/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.lapp.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.context.QingIntegratedContext;
import com.kingdee.bos.qing.publish.target.lapp.model.LappContext;
import com.kingdee.bos.qing.publish.target.lapp.util.LappHelper;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.portal.biz.common.util.XTServiceConfig;
import com.kingdee.util.ConfigurationItem;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public class LappContextUtils {
    public static Map<String, String> getEasLappContextForPublish(String userName) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("scene", "EAS");
        result.put("userName", userName);
        return result;
    }

    public static Map<String, String> getEasShareContext() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("userName", "hhp");
        result.put("userPictureFiled", "hhp");
        return result;
    }

    public static String getYzjEid(QingContext qingContext) {
        Context ctx = ((QingIntegratedContext)qingContext).getBosContext();
        String dbCode = ctx.getAIS();
        String eid = null;
        if (dbCode != null && !dbCode.isEmpty()) {
            eid = XTServiceConfig.getInstance().getEidByDbCode(dbCode);
        }
        return eid;
    }

    public static String getLappHomePageUrl() {
        return LappHelper.getLappHomePageUrl();
    }

    public static Map<String, String> getConfigProperties(LappContext.UserType userType) {
        LappContext.AppType appType = LappContext.AppType.getAppTypeByUserType((LappContext.UserType)userType);
        Map properties = null;
        ConfigurationItem configurationItem = XTServiceConfig.getInstance().getConfigurationItemByPath("QingLightAPP");
        if (configurationItem != null && (configurationItem = configurationItem.getChild(appType.toString())) != null) {
            properties = configurationItem.getProperties();
        }
        if (properties == null) {
            properties = new HashMap();
        }
        return properties;
    }

    public static boolean supportYzjImmediateExecution() {
        Map<String, String> properties = LappContextUtils.getConfigProperties(LappContext.UserType.YZJ_OPENID);
        return "true".equals(properties.get("supportImmediateExecution"));
    }

    public static class EncryptUtil {
        public static String encrypt(String content) {
            LogUtil.debug((String)("before encrypt: " + content));
            try {
                byte[] enCodeFormat = EncryptUtil.parseHexStr2Byte("A6911D1C8B7323762B67CF98B6C01437");
                SecretKeySpec key = new SecretKeySpec(enCodeFormat, "AES");
                Cipher cipher = Cipher.getInstance("AES");
                byte[] byteContent = content.getBytes("utf-8");
                cipher.init(1, key);
                byte[] result = cipher.doFinal(byteContent);
                String resultStr = EncryptUtil.parseByte2HexStr(result);
                LogUtil.debug((String)("after encrypt: " + resultStr));
                return resultStr;
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            catch (NoSuchPaddingException e) {
                e.printStackTrace();
            }
            catch (InvalidKeyException e) {
                e.printStackTrace();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (IllegalBlockSizeException e) {
                e.printStackTrace();
            }
            catch (BadPaddingException e) {
                e.printStackTrace();
            }
            return null;
        }

        public static String decrypt(String content) {
            try {
                byte[] enCodeFormat = EncryptUtil.parseHexStr2Byte("A6911D1C8B7323762B67CF98B6C01437");
                SecretKeySpec key = new SecretKeySpec(enCodeFormat, "AES");
                Cipher cipher = Cipher.getInstance("AES");
                cipher.init(2, key);
                byte[] result = cipher.doFinal(EncryptUtil.parseHexStr2Byte(content));
                return new String(result);
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            catch (NoSuchPaddingException e) {
                e.printStackTrace();
            }
            catch (InvalidKeyException e) {
                e.printStackTrace();
            }
            catch (IllegalBlockSizeException e) {
                e.printStackTrace();
            }
            catch (BadPaddingException e) {
                e.printStackTrace();
            }
            return null;
        }

        public static String parseByte2HexStr(byte[] buf) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < buf.length; ++i) {
                String hex = Integer.toHexString(buf[i] & 0xFF);
                if (hex.length() == 1) {
                    hex = '0' + hex;
                }
                sb.append(hex.toUpperCase());
            }
            return sb.toString();
        }

        public static byte[] parseHexStr2Byte(String hexStr) {
            if (hexStr.length() < 1) {
                return null;
            }
            byte[] result = new byte[hexStr.length() / 2];
            for (int i = 0; i < hexStr.length() / 2; ++i) {
                int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
                int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
                result[i] = (byte)(high * 16 + low);
            }
            return result;
        }
    }
}

