/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.schedule.executer;

import com.kingdee.bos.Context;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.init.QingInitializeHelper;
import com.kingdee.bos.qing.common.session.IGlobalQingSession;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.schedule.exception.ScheduleEngineException;
import com.kingdee.bos.qing.schedule.model.ExecuteStateEnum;
import com.kingdee.bos.qing.schedule.model.ScheduleExecutePO;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.util.concurrent.TimeUnit;

public abstract class AbstractScheduleExecuter {
    protected QingContext qingContext;
    protected ITransactionManagement tx;
    protected IDBExcuter dbExcuter;
    protected IScheduleEngine scheduleEngine;

    public void setQingContext(QingContext qingContext) {
        this.qingContext = qingContext;
        QingContext.setCurrent((QingContext)qingContext);
    }

    public void setTx(ITransactionManagement tx) {
        this.tx = tx;
    }

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void setScheduleEngine(IScheduleEngine scheduleEngine) {
        this.scheduleEngine = scheduleEngine;
    }

    public abstract void execute(Context var1, String var2, String var3, String var4) throws Exception;

    public void executeRunEmpty(Context ctx, String themeId, String userId, String orgId) throws Exception {
    }

    public void deleteJob(String pkId) {
        try {
            this.tx.beginRequired();
            this.scheduleEngine.deleteJob(this.qingContext, null, pkId);
        }
        catch (ScheduleEngineException e) {
            this.tx.markRollback();
            LogUtil.error((String)"qingschedule execute deleteJob error", (Throwable)e);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            LogUtil.error((String)"qingschedule execute deleteJob error", (Throwable)e);
        }
        finally {
            this.tx.end();
        }
    }

    public abstract ScheduleExecutePO getScheduleExecutePO(QingContext var1, String var2, ExecuteStateEnum var3);

    public boolean checkDoPushRequest(String timeStamp) {
        boolean isAuthorizedDoPushRequest = false;
        IGlobalQingSession qingGlobalQingSession = QingSessionUtil.getGlobalQingSessionImpl();
        String cacheTimeStamp = qingGlobalQingSession.get(this.getDoPushTimeStampCacheKey(timeStamp));
        if (cacheTimeStamp != null && cacheTimeStamp.equals(timeStamp)) {
            isAuthorizedDoPushRequest = true;
            qingGlobalQingSession.remove(this.getDoPushTimeStampCacheKey(timeStamp));
        }
        return isAuthorizedDoPushRequest;
    }

    public String getServerTimeStampForDoPush() {
        String timeStamp = String.valueOf(System.currentTimeMillis());
        IGlobalQingSession qingGlobalQingSession = QingSessionUtil.getGlobalQingSessionImpl();
        qingGlobalQingSession.set(this.getDoPushTimeStampCacheKey(timeStamp), timeStamp, 20, TimeUnit.SECONDS);
        return timeStamp;
    }

    private String getDoPushTimeStampCacheKey(String timeStamp) {
        String DO_PUSH_TIME_STAMP_CACHE_KEY_PREFIX = "Qing.Do.Push.Time.Stamp-";
        String doPushTimeStampCacheKey = "Qing.Do.Push.Time.Stamp-" + this.qingContext.getUserId() + "-" + timeStamp;
        return doPushTimeStampCacheKey;
    }

    static {
        String EAS_HOME = System.getProperty("EAS_HOME");
        if (StringUtils.isBlank((CharSequence)System.getProperty("QingAnalysis.TempDir"))) {
            String path = EAS_HOME + "/server/deploy/ctrlhome";
            System.setProperty("QingAnalysis.TempDir", path);
        }
        QingInitializeHelper.initializeOnStart();
    }
}

