/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.schedule.executer.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.datasource.DataSourceCreatorFactory;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.framework.server.msgpublish.ServerChannelMessagePublisher;
import com.kingdee.bos.qing.common.framework.server.task.ServerRequestInvokeContext;
import com.kingdee.bos.qing.common.i18n.EASMessages;
import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.core.brief.WarningRule;
import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.exception.PersistentModelTooModernException;
import com.kingdee.bos.qing.core.model.analysis.IPreferences;
import com.kingdee.bos.qing.core.model.analysis.IQingModel;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.core.model.meta.Meta;
import com.kingdee.bos.qing.datasource.spec.mult.MultiDataThreadLocalUtil;
import com.kingdee.bos.qing.datasource.util.DateUtil;
import com.kingdee.bos.qing.domain.AbstractDomain;
import com.kingdee.bos.qing.domain.WarningRuleDomain;
import com.kingdee.bos.qing.exceptionlog.domain.ExceptionLogDomain;
import com.kingdee.bos.qing.exceptionlog.model.ExceptionLog;
import com.kingdee.bos.qing.exceptionlog.model.ExceptionLogBizTypeEnum;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.preparedata.exception.PrepareDataException;
import com.kingdee.bos.qing.preparedata.handler.timingpush.TimingPushPrepareDataContext;
import com.kingdee.bos.qing.preparedata.preparedatacontext.AbstractPrepareDataContext;
import com.kingdee.bos.qing.preparedata.task.DataExtractTask;
import com.kingdee.bos.qing.preparedata.task.FromType;
import com.kingdee.bos.qing.publish.lapp.util.LappContextUtils;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.target.lapp.PushScheduleExecuteDomian;
import com.kingdee.bos.qing.publish.target.lapp.dao.LappDao;
import com.kingdee.bos.qing.publish.target.lapp.exception.ExecuteSqlException;
import com.kingdee.bos.qing.publish.target.lapp.exception.LappWarningRuleExcuteException;
import com.kingdee.bos.qing.publish.target.lapp.exception.LappWarningRuleUnMatchedException;
import com.kingdee.bos.qing.publish.target.lapp.model.LappSchedulePushConfigModel;
import com.kingdee.bos.qing.publish.target.lapp.model.PushRecord;
import com.kingdee.bos.qing.publish.target.lapp.model.PushThumbnailInfoModel;
import com.kingdee.bos.qing.publish.target.lapp.util.LappHelper;
import com.kingdee.bos.qing.publish.thumbnail.ThumbnailHelper;
import com.kingdee.bos.qing.publish.thumbnail.model.ThumbnailInfo;
import com.kingdee.bos.qing.publish.thumbnail.model.ThumbnailUrlModel;
import com.kingdee.bos.qing.schedule.exception.AbstractScheduleExecuteException;
import com.kingdee.bos.qing.schedule.executer.AbstractScheduleExecuter;
import com.kingdee.bos.qing.schedule.model.ExecuteStateEnum;
import com.kingdee.bos.qing.schedule.model.ScheduleExecutePO;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.ModelBookUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.jdom2.JDOMException;

public class PushScheduleExecuter
extends AbstractScheduleExecuter {
    public static final String LAPP_DASHBOARD_COMMUNICATE_TIMINGPUSH_THUMBNAIL = "dashboard_thumbnail.png";
    private PushScheduleExecuteDomian pushScheduleExecuteDomian;
    private LappDao lappDao;
    private ExceptionLogDomain exceptionLogDomain;

    private PushScheduleExecuteDomian getPushScheduleExecuteDomian() {
        if (this.pushScheduleExecuteDomian == null) {
            this.pushScheduleExecuteDomian = new PushScheduleExecuteDomian();
            this.pushScheduleExecuteDomian.setDbExcuter(this.dbExcuter);
            this.pushScheduleExecuteDomian.setQingContext(this.qingContext);
            this.pushScheduleExecuteDomian.setTx(this.tx);
            this.pushScheduleExecuteDomian.setScheduleEngine(this.scheduleEngine);
        }
        return this.pushScheduleExecuteDomian;
    }

    private LappDao getLappDao() {
        if (this.lappDao == null) {
            this.lappDao = new LappDao(this.dbExcuter);
        }
        return this.lappDao;
    }

    private ExceptionLogDomain getExceptionLogDomain() {
        if (this.exceptionLogDomain == null) {
            this.exceptionLogDomain = new ExceptionLogDomain(this.tx, this.dbExcuter);
        }
        return this.exceptionLogDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute(Context context, String params, String userId, String orgId) throws Exception {
        Map paramsMap = (Map)JsonUtil.decodeFromString((String)params, Map.class);
        String configId = paramsMap.get("sourceId").toString();
        boolean isConnAvailable = LappHelper.isConnAvailable();
        if (!isConnAvailable) {
            String recordId = this.savePushRecord(configId);
            int errorCode = 4300106;
            String errorMessage = Messages.getMLS((QingContext)this.qingContext, (String)"networkError", (String)"\u7f51\u7edc\u8fde\u63a5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc", (Messages.ProjectName)Messages.ProjectName.QING_THEME);
            ExceptionLog exceptionLog = new ExceptionLog();
            exceptionLog.setBizId(recordId);
            exceptionLog.setBizTypeEnum(ExceptionLogBizTypeEnum.ROBOT_PUSH);
            exceptionLog.setErrorCode(errorCode);
            exceptionLog.setErrorMessage(errorMessage);
            this.getExceptionLogDomain().insert(exceptionLog);
            return;
        }
        String analysisId = null;
        MultiDataThreadLocalUtil.setAsyncJoin((Boolean)false);
        LappSchedulePushConfigModel pushConfigModel = new LappSchedulePushConfigModel();
        PublishPO publishPO = new PublishPO();
        ArrayList savedQingFiles = new ArrayList();
        String tag = UUID.randomUUID().toString();
        Exception exception = null;
        boolean immediatelyPush = false;
        try {
            long timeStamp = System.currentTimeMillis();
            if (paramsMap.get("timeStamp") != null) {
                timeStamp = Long.parseLong((String)paramsMap.get("timeStamp"));
                immediatelyPush = true;
            }
            this.pushExtractData(tag, configId, timeStamp, immediatelyPush);
            ServerRequestInvokeContext.staticCheckInterrupt();
            if (immediatelyPush) {
                ServerChannelMessagePublisher.publish((String)("ExtractData" + timeStamp), (String)"pushing");
            }
            this.tx.beginRequired();
            Map<String, String> yzjInfo = LappContextUtils.getEasShareContext();
            Map<String, String> lappContext = LappContextUtils.getEasLappContextForPublish(context.getUserName());
            String sParamPathPrefix = paramsMap.get("paramPathPrefix").toString();
            pushConfigModel = this.getPushScheduleExecuteDomian().getPushConfigById(configId);
            publishPO = this.getPushScheduleExecuteDomian().savePublish(tag, configId, lappContext, savedQingFiles);
            PushThumbnailInfoModel pushThumbnailInfoModel = this.getLappDao().loadThumbnailInfo(configId);
            String thumbnailFileName = null;
            if (pushThumbnailInfoModel != null) {
                ModelBook modelBook = this.loadSchemaContent(configId, pushThumbnailInfoModel);
                if (!immediatelyPush && !this.checkByWarningRuleMatched(pushConfigModel, tag)) {
                    throw new LappWarningRuleUnMatchedException();
                }
                thumbnailFileName = this.generateMobileImage(tag, pushThumbnailInfoModel, publishPO.getId(), modelBook, publishPO.getSchemaId());
            } else {
                thumbnailFileName = LAPP_DASHBOARD_COMMUNICATE_TIMINGPUSH_THUMBNAIL;
                String thumbnailPath = pushConfigModel.getThumbnailPath();
                if (StringUtils.isNotEmpty((CharSequence)thumbnailPath)) {
                    IQingFile localImagePath = null;
                    if (thumbnailPath.indexOf("{") > -1) {
                        ThumbnailUrlModel thumbnailUrlModel = ThumbnailUrlModel.fromJsonObject((String)thumbnailPath);
                        localImagePath = (IQingFile)thumbnailUrlModel.getImageIQingFile();
                        localImagePath = ThumbnailHelper.generateCompressImage((IQingFileVisitor)localImagePath, (int)800, (int)400, (AbstractQingFileType)QingTempFileType.EXPORT, null, null);
                    } else {
                        QingPersistentFileType abstractQingFileType = QingPersistentFileType.CARD_THUMBNAIL;
                        localImagePath = (IQingFile)FileFactory.newFileVisitor((AbstractQingFileType)abstractQingFileType, (String)thumbnailPath);
                        localImagePath = ThumbnailHelper.generateCompressImage((IQingFileVisitor)localImagePath, (int)0, (int)0, (AbstractQingFileType)QingTempFileType.EXPORT, null, null);
                    }
                    if (localImagePath != null && localImagePath.exists()) {
                        thumbnailFileName = ThumbnailHelper.upload((IQingFile)localImagePath);
                    }
                }
            }
            analysisId = this.getPushScheduleExecuteDomian().saveLappContent(thumbnailFileName, sParamPathPrefix, pushConfigModel, publishPO, yzjInfo, lappContext);
            this.tx.end();
        }
        catch (Exception e) {
            this.tx.markRollback();
            exception = e;
            if (immediatelyPush) {
                if (e instanceof InterruptedException) return;
            }
            ExceptionLog exceptionLog = new ExceptionLog();
            exceptionLog.bindException((Throwable)e);
            throw new AbstractScheduleExecuteException(exceptionLog.getErrorMessage(), exceptionLog.getErrorCode(), e);
        }
        MultiDataThreadLocalUtil.remove();
        if (exception == null) return;
        FileFactory.clearFile(savedQingFiles);
        this.getPushScheduleExecuteDomian().deleteAnalysis(pushConfigModel.getId(), analysisId);
        if (immediatelyPush) return;
        this.savePushRecordAndErrorInfo(configId, exception);
        return;
        finally {
            this.tx.end();
            MultiDataThreadLocalUtil.remove();
            if (exception != null) {
                FileFactory.clearFile(savedQingFiles);
                this.getPushScheduleExecuteDomian().deleteAnalysis(pushConfigModel.getId(), analysisId);
                if (!immediatelyPush) {
                    this.savePushRecordAndErrorInfo(configId, exception);
                }
            }
        }
    }

    private boolean checkByWarningRuleMatched(LappSchedulePushConfigModel pushConfigModel, String tag) throws AbstractQingIntegratedException, SQLException, PersistentModelParseException, PersistentModelTooModernException, IOException, LappWarningRuleExcuteException, JDOMException {
        boolean warningRuleMatched = true;
        if (StringUtils.isEmpty((CharSequence)pushConfigModel.getWarningRuleName())) {
            return warningRuleMatched;
        }
        byte[] schemaContent = this.getLappDao().getSchemaContent(pushConfigModel.getId());
        ModelBook modelBook = ModelBookUtil.fromByte((byte[])schemaContent);
        IQingModel model = ((ModelBook.ModelPage)modelBook.getPages().get(0)).getModel();
        IPreferences preferences = ((ModelBook.ModelPage)modelBook.getPages().get(0)).getPreferences();
        ModelBook.ModelPage.prepareForExecuting((Meta)modelBook.getMeta(), (IQingModel)model, (IPreferences)preferences);
        ArrayList<String> warningRuleNames = new ArrayList<String>();
        warningRuleNames.add(pushConfigModel.getWarningRuleName());
        AbstractDomain.IDataSourceCreator dataSourceCreator = DataSourceCreatorFactory.getDataSourceCreator((QingContext)this.qingContext, (String)tag);
        WarningRuleDomain warningRuleDomain = new WarningRuleDomain(dataSourceCreator);
        Map warningRuleResult = warningRuleDomain.execute(model, warningRuleNames);
        WarningRule warningRule = (WarningRule)warningRuleResult.get(pushConfigModel.getWarningRuleName());
        if (null != warningRule && warningRule.isError()) {
            throw new LappWarningRuleExcuteException(warningRule.getErrorMessage(), warningRule.getErrorCode());
        }
        if (null != warningRule && !warningRule.isMatched()) {
            warningRuleMatched = false;
        }
        return warningRuleMatched;
    }

    @Override
    public ScheduleExecutePO getScheduleExecutePO(QingContext qingContext, String params, ExecuteStateEnum executeStateEnum) {
        Map paramsMap = (Map)JsonUtil.decodeFromString((String)params, Map.class);
        String sourceId = paramsMap.get("sourceId").toString();
        String scheduleName = EASMessages.getMLS(qingContext, "pushSchedule", "\u8f7b\u5206\u6790\u673a\u5668\u4eba\u63a8\u9001\u5b9a\u65f6\u4efb\u52a1-") + sourceId;
        String sourceName = EASMessages.getMLS(qingContext, "pushSchedule", "\u8f7b\u5206\u6790\u673a\u5668\u4eba\u63a8\u9001\u5b9a\u65f6\u4efb\u52a1-") + sourceId;
        if (paramsMap.get("sourceName") != null) {
            sourceName = paramsMap.get("sourceName").toString();
        }
        String scheduleNameEnum = "pushExecute";
        ScheduleExecutePO scheduleExecutePO = new ScheduleExecutePO();
        scheduleExecutePO.setTenantId(qingContext.getTenantId());
        scheduleExecutePO.setUserId(qingContext.getUserId());
        scheduleExecutePO.setScheduleName(scheduleName);
        scheduleExecutePO.setSourceId(sourceId);
        scheduleExecutePO.setSourceName(sourceName);
        scheduleExecutePO.setScheduleExecuterNameEnum(scheduleNameEnum);
        scheduleExecutePO.setExecuteStateEnum(executeStateEnum);
        return scheduleExecutePO;
    }

    private void savePushRecordAndErrorInfo(String configId, Exception e) throws AbstractQingIntegratedException, SQLException, ExecuteSqlException {
        ExceptionLog exceptionLog = new ExceptionLog();
        exceptionLog.bindException((Throwable)e);
        String recordId = this.savePushRecord(configId);
        this.getPushScheduleExecuteDomian().saveErrorInfo(recordId, exceptionLog);
    }

    private void pushExtractData(String tag, String configId, long timeStamp, boolean immediatelyPush) throws PrepareDataException {
        TimingPushPrepareDataContext timingPushPrepareDataContext = new TimingPushPrepareDataContext();
        timingPushPrepareDataContext.setQingContext(this.qingContext);
        timingPushPrepareDataContext.setDbExcuter(this.dbExcuter);
        timingPushPrepareDataContext.setTx(this.tx);
        timingPushPrepareDataContext.setScheduleEngine(this.scheduleEngine);
        timingPushPrepareDataContext.setTag(tag);
        timingPushPrepareDataContext.setFromType(FromType.timingPushRobot);
        timingPushPrepareDataContext.setDealProgresss(immediatelyPush);
        timingPushPrepareDataContext.setStartBySchedule(true);
        timingPushPrepareDataContext.setTimeStamp(timeStamp);
        timingPushPrepareDataContext.setConfigId(configId);
        DataExtractTask dataExtractTask = new DataExtractTask((AbstractPrepareDataContext)timingPushPrepareDataContext);
        try {
            dataExtractTask.call();
        }
        catch (PrepareDataException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PrepareDataException((Throwable)e);
        }
    }

    private String getServicePrefixUrl() {
        String sParamPathPrefix = System.getProperty("cas.server.url");
        if (sParamPathPrefix.indexOf("/eassso") > 0) {
            sParamPathPrefix = sParamPathPrefix.substring(0, sParamPathPrefix.indexOf("/eassso"));
        }
        if (sParamPathPrefix.endsWith("/")) {
            sParamPathPrefix = sParamPathPrefix.substring(0, sParamPathPrefix.lastIndexOf(47));
        }
        return sParamPathPrefix;
    }

    private String savePushRecord(String configId) throws AbstractQingIntegratedException, ExecuteSqlException, SQLException {
        try {
            this.tx.beginRequired();
            LappSchedulePushConfigModel pushConfigModel = this.getPushScheduleExecuteDomian().getPushConfigById(configId);
            String userId = this.qingContext.getUserId();
            PushRecord pushRecordModel = new PushRecord();
            pushRecordModel.setConfigId(configId);
            if (pushConfigModel.getNameRule() != null) {
                Locale locale = this.qingContext.getIi18nContext().getLanManager().getLocale();
                String dateStr = DateUtil.date2StrByLang((Locale)locale, (String)pushConfigModel.getNameRule(), (Date)new Date());
                pushConfigModel.setName(pushConfigModel.getName() + dateStr);
            }
            pushRecordModel.setName(pushConfigModel.getName());
            String string = this.getLappDao().savePushRecord(pushRecordModel, userId);
            return string;
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (ExecuteSqlException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
        }
    }

    private ModelBook loadSchemaContent(String configId, PushThumbnailInfoModel pushThumbnailInfoModel) throws AbstractQingIntegratedException, SQLException, PersistentModelParseException, PersistentModelTooModernException, JDOMException, IOException {
        byte[] schemaContentBytes = null;
        List outsideRef = new ArrayList();
        if (pushThumbnailInfoModel != null) {
            schemaContentBytes = this.getLappDao().getSchemaContent(pushThumbnailInfoModel.getId());
            outsideRef = this.getLappDao().loadSchemaRef(pushThumbnailInfoModel.getId());
        } else {
            schemaContentBytes = this.getLappDao().getSchemaContent(configId);
            outsideRef = this.getLappDao().loadSchemaRef(configId);
        }
        ModelBook modelBook = ModelBookUtil.fromByte((byte[])schemaContentBytes);
        modelBook.fixReferences(outsideRef);
        return modelBook;
    }

    public String generateMobileImage(String tag, PushThumbnailInfoModel pushThumbnailInfoModel, String publishId, ModelBook modelBook, String schemaId) throws Exception {
        ThumbnailInfo thumbnailInfo = new ThumbnailInfo();
        thumbnailInfo.setPublishId(publishId);
        if (pushThumbnailInfoModel == null || pushThumbnailInfoModel.getApeWidth() == 0) {
            thumbnailInfo.setApertureLeft(0);
            thumbnailInfo.setApertureTop(0);
            thumbnailInfo.setApertureHeight(360);
            thumbnailInfo.setApertureWidth(720);
            thumbnailInfo.setScrollLeft(0);
            thumbnailInfo.setScrollTop(0);
        } else {
            thumbnailInfo.setApertureLeft(pushThumbnailInfoModel.getApeLeft());
            thumbnailInfo.setApertureTop(pushThumbnailInfoModel.getApeTop());
            thumbnailInfo.setApertureHeight(pushThumbnailInfoModel.getApeHeight());
            thumbnailInfo.setApertureWidth(pushThumbnailInfoModel.getApeWidth());
            thumbnailInfo.setScrollLeft(pushThumbnailInfoModel.getScoLeft());
            thumbnailInfo.setScrollTop(pushThumbnailInfoModel.getScoTop());
        }
        thumbnailInfo.setSchemaId(schemaId);
        AbstractDomain.IDataSourceCreator dataSourceCreator = DataSourceCreatorFactory.getDataSourceCreator((QingContext)this.qingContext, (String)tag);
        IQingFile localImagePath = ThumbnailHelper.generateMobileImage((ModelBook)modelBook, (AbstractDomain.IDataSourceCreator)dataSourceCreator, (II18nContext)this.qingContext.getIi18nContext(), (ThumbnailInfo)thumbnailInfo);
        return ThumbnailHelper.upload((IQingFile)localImagePath);
    }
}

