/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.schedule.resource;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.schedule.domain.AbstractScheduleExecuteDomain;
import com.kingdee.bos.qing.schedule.model.ScheduleExecuteVO;
import com.kingdee.bos.qing.util.StringUtils;
import java.sql.ResultSet;
import java.sql.SQLException;

public class LappThumbnailScheduleExecuteGetter
extends AbstractScheduleExecuteDomain {
    public LappThumbnailScheduleExecuteGetter(QingContext qingContext, IDBExcuter dbExcuter, ITransactionManagement tx) {
        super(qingContext, dbExcuter, tx);
    }

    public ScheduleExecuteVO findById(String id) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT SE.FID, SE.FUSERID, SE.FSCHEDULENAME, SE.FSOURCEID, SE.FSOURCENAME, SE.FEXECUTESTATE, SE.FEXECUTETIME, SE.FMETHODNAME,SE.FENDTIME, P.FID AS PUBLISHID,  P.FNAME AS PUBLISHNAME,P.FPATH AS PUBLISHPATH,P.FTYPE AS PUBLISHTYPE, PG.FNAME AS PUBLISHGROUPNAME  FROM      (SELECT SE.FID, SE.FUSERID, SE.FSCHEDULENAME, SE.FSOURCEID, SE.FSOURCENAME, SE.FEXECUTESTATE, SE.FEXECUTETIME, SE.FMETHODNAME,SE.FENDTIME FROM T_QING_SCHEDULE_EXECUTE SE      WHERE SE.FID=? AND SE.FMETHODNAME='updateLappThumbnail') SE  LEFT JOIN T_QING_THUMBNAIL TH ON SE.FSOURCEID=TH.FANAID  LEFT JOIN T_QING_PUBLISH P ON TH.FPUBLISHID=P.FID  LEFT JOIN T_QING_PUBLISH_GROUP PG ON P.FPATH=PG.FID ";
        Object[] params = new Object[]{id};
        return (ScheduleExecuteVO)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<ScheduleExecuteVO>(){

            public ScheduleExecuteVO handle(ResultSet rs) throws SQLException {
                ScheduleExecuteVO scheduleExecute = new ScheduleExecuteVO();
                if (rs.next()) {
                    scheduleExecute.setId(rs.getString("FID"));
                    scheduleExecute.setScheduleName(rs.getString("FSCHEDULENAME"));
                    String sourceId = StringUtils.isNotBlank((CharSequence)rs.getString("PUBLISHID")) ? rs.getString("PUBLISHID") : rs.getString("FSOURCEID");
                    scheduleExecute.setSourceId(sourceId);
                    String publishName = rs.getString("PUBLISHNAME");
                    String publishPath = rs.getString("PUBLISHPATH");
                    String publishType = rs.getString("PUBLISHTYPE");
                    String methodName = rs.getString("FMETHODNAME");
                    scheduleExecute.setSourceName(publishName);
                    scheduleExecute.setSourcePath(publishPath);
                    scheduleExecute.setSourceTargetType(publishType);
                    scheduleExecute.setUserId(rs.getString("FUSERID"));
                    scheduleExecute.setMethodName(methodName);
                    scheduleExecute.setExecuteState(rs.getInt("FEXECUTESTATE"));
                    scheduleExecute.setExecuteTime(Long.valueOf(rs.getTimestamp("FEXECUTETIME").getTime()));
                    if (rs.getTimestamp("FENDTIME") != null) {
                        scheduleExecute.setEndTime(Long.valueOf(rs.getTimestamp("FENDTIME").getTime()));
                    }
                }
                return scheduleExecute;
            }
        });
    }
}

