/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.datasource;

import com.kingdee.bos.qing.common.cache.ISessionCacheable;
import com.kingdee.bos.qing.common.cache.MultiFileDataSource;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.datasource.AbstractImpl;
import com.kingdee.bos.qing.common.session.IQingSession;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.data.domain.visitor.BoxDataSourceWrap;
import com.kingdee.bos.qing.data.domain.visitor.DSModelBuilder;
import com.kingdee.bos.qing.data.model.designtime.Box;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.model.MultiDataSourceWrap;
import com.kingdee.bos.qing.datasource.spec.AbstractSingleDataSourceVisitor;
import com.kingdee.bos.qing.datasource.spec.IDataSourceVisitor;
import com.kingdee.bos.qing.datasource.spec.IMetaVisitor;
import com.kingdee.bos.qing.datasource.spec.mult.MultiDataSourceVisitor;
import com.kingdee.bos.qing.filesystem.manager.ClientAndTmpFileRelationManager;
import com.kingdee.bos.qing.subject.domain.MultiDataSourceWrapCacheListener;
import java.util.Map;
import java.util.Set;

public class MultiFileDataSourceCreator
extends AbstractImpl {
    private MultiFileDataSource multiFileDataSource;
    protected QingContext qingContext;

    public MultiFileDataSourceCreator(QingContext qingContext, MultiFileDataSource multiFileDataSource) {
        this.multiFileDataSource = multiFileDataSource;
        this.qingContext = qingContext;
    }

    public IMetaVisitor createMetaVisitor() throws AbstractDataSourceException {
        return this.createDataSourceVisitor();
    }

    protected void fixBox(Box box) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDataSourceVisitor createDataSourceVisitor() throws AbstractDataSourceException {
        ClientAndTmpFileRelationManager.enableBind((boolean)true);
        try {
            Map<Set<String>, AbstractSingleDataSourceVisitor> dataFileVisitorMaps = this.multiFileDataSource.getDataFileVisitorMaps();
            Box box = this.multiFileDataSource.getBoxModel();
            DSModelBuilder dsModelBuilder = new DSModelBuilder(box, dataFileVisitorMaps);
            Map dsMetaEntityMap = dsModelBuilder.getErEntityMap();
            Map entityMap = dsModelBuilder.getEntityMap();
            Map sourceMap = dsModelBuilder.getSourceMap();
            BoxDataSourceWrap multiDataSourceWrap = new BoxDataSourceWrap(this.qingContext, this.multiFileDataSource.getThemeId(), sourceMap, entityMap, box.getRelations(), this.multiFileDataSource.getOriginalCreatorId(), dsMetaEntityMap, dataFileVisitorMaps);
            multiDataSourceWrap.addCacheListener((MultiDataSourceWrap.CacheListener)new MultiDataSourceWrapCacheListener(this.multiFileDataSource));
            IQingSession qingSession = QingSessionUtil.getQingSessionImpl();
            qingSession.setCache((ISessionCacheable)this.multiFileDataSource);
            MultiDataSourceVisitor multiDataSourceVisitor = dsModelBuilder.createDataSourceVistor((MultiDataSourceWrap)multiDataSourceWrap);
            return multiDataSourceVisitor;
        }
        finally {
            ClientAndTmpFileRelationManager.enableBind((boolean)false);
        }
    }
}

