/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.core.exception.PersistentModelTooModernException;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.dashboard.dao.DashboardSerializationUtil;
import com.kingdee.bos.qing.dashboard.exception.DashboardEncryptedLicenseException;
import com.kingdee.bos.qing.dashboard.exception.DashboardException;
import com.kingdee.bos.qing.dashboard.exception.NotSelectMapException;
import com.kingdee.bos.qing.dashboard.exception.PersistentModelParseException;
import com.kingdee.bos.qing.dashboard.model.DashboardModel;
import com.kingdee.bos.qing.dashboard.model.DashboardModelUtil;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.dashboard.reference.IRefHandler;
import com.kingdee.bos.qing.dashboard.reference.ISecondPublishable;
import com.kingdee.bos.qing.dashboard.reference.impl.RefHandlerFactory;
import com.kingdee.bos.qing.manage.dao.IThemeDao;
import com.kingdee.bos.qing.manage.dao.IThemeGroupDao;
import com.kingdee.bos.qing.manage.dao.impl.ThemeDaoImpl;
import com.kingdee.bos.qing.manage.dao.impl.ThemeGroupDaoImpl;
import com.kingdee.bos.qing.manage.exception.EncryptedLicenseCheckException;
import com.kingdee.bos.qing.map.dao.MapManageDao;
import com.kingdee.bos.qing.map.model.MapVO;
import com.kingdee.bos.qing.publish.dao.DashboardPublishDao;
import com.kingdee.bos.qing.publish.dao.PublishInfoDao;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Element;

public class DashboardRuntimeDomain {
    private IDBExcuter dbExcuter;
    private ITransactionManagement tx;
    private QingContext context;
    private Map<RefTypeEnum, IRefHandler> refHandlerMap;
    private DashboardPublishDao dashboardPublishDao;
    private PublishInfoDao publishInfoDao;
    private IThemeGroupDao iThemeGroupDao;
    private IThemeDao iThemeDao;
    private MapManageDao mapManageDao;

    public DashboardRuntimeDomain(QingContext context, ITransactionManagement tx, IDBExcuter dbExcuter) {
        this.context = context;
        this.tx = tx;
        this.dbExcuter = dbExcuter;
    }

    public IRefHandler getRefHandler(RefTypeEnum refType) {
        IRefHandler refHandler;
        if (this.refHandlerMap == null) {
            this.refHandlerMap = new EnumMap<RefTypeEnum, IRefHandler>(RefTypeEnum.class);
        }
        if ((refHandler = this.refHandlerMap.get(refType)) == null) {
            refHandler = RefHandlerFactory.createHandler(refType, this.dbExcuter, this.context, this.tx);
            this.refHandlerMap.put(refType, refHandler);
        }
        return refHandler;
    }

    public DashboardPublishDao getDashboardPublishDao() {
        if (this.dashboardPublishDao == null) {
            this.dashboardPublishDao = new DashboardPublishDao(this.dbExcuter);
        }
        return this.dashboardPublishDao;
    }

    private PublishInfoDao getPublishInfoDao() {
        if (this.publishInfoDao == null) {
            this.publishInfoDao = new PublishInfoDao(this.dbExcuter);
        }
        return this.publishInfoDao;
    }

    protected IThemeGroupDao getThemeGroupDao() {
        if (this.iThemeGroupDao == null) {
            this.iThemeGroupDao = new ThemeGroupDaoImpl(this.dbExcuter);
        }
        return this.iThemeGroupDao;
    }

    protected IThemeDao getThemeDao() {
        if (this.iThemeDao == null) {
            this.iThemeDao = new ThemeDaoImpl(this.dbExcuter);
        }
        return this.iThemeDao;
    }

    private MapManageDao getMapManageDao() {
        if (this.mapManageDao == null) {
            this.mapManageDao = new MapManageDao();
            this.mapManageDao.setDbExcuter(this.dbExcuter);
        }
        return this.mapManageDao;
    }

    public DashboardModel loadDsbModel(String publishId) throws AbstractQingIntegratedException, DashboardException {
        try {
            DashboardModel dashboardModel = null;
            InputStream dashboardModelContent = this.getDashboardPublishDao().loadDsbModelContentStream(publishId);
            if (dashboardModelContent != null) {
                dashboardModel = DashboardSerializationUtil.toModel(dashboardModelContent);
                List<ReferenceMap> refItems = this.getDashboardPublishDao().getRefList(publishId);
                dashboardModel.fixReferences(refItems);
            }
            return dashboardModel;
        }
        catch (PersistentModelParseException e) {
            throw new DashboardException((Throwable)e);
        }
        catch (SQLException e) {
            throw new DashboardException((Throwable)e);
        }
        catch (EncryptedLicenseCheckException e) {
            throw new DashboardEncryptedLicenseException(e.getMessage(), e.getErrorCode());
        }
    }

    public ModelBook loadSchema(String publishId, ReferenceMap ref) throws AbstractQingIntegratedException, DashboardException {
        try {
            ModelBook modelBook = null;
            byte[] refContent = this.selectRefContent(publishId, ref);
            if (refContent != null) {
                List<OutsideReference> outSideRef = this.getDashboardPublishDao().loadSchemaRefOfUser((String)ref.get((Object)"id"));
                if (outSideRef.size() == 0) {
                    outSideRef = this.getDashboardPublishDao().loadSchemaRef((String)ref.get((Object)"id"));
                }
                modelBook = DashboardModelUtil.byteToSchemaModel(refContent);
                if (outSideRef.size() > 0) {
                    this.setOutSideRefName(outSideRef);
                    modelBook.fixReferences(outSideRef);
                }
            }
            return modelBook;
        }
        catch (com.kingdee.bos.qing.core.exception.PersistentModelParseException e) {
            throw PersistentModelParseException.createParseError((Throwable)e);
        }
        catch (PersistentModelTooModernException e) {
            throw PersistentModelParseException.createParseError((Throwable)e);
        }
        catch (SQLException e) {
            throw new DashboardException((Throwable)e);
        }
    }

    public void setOutSideRefName(List<OutsideReference> outerRefList) throws AbstractQingIntegratedException, SQLException {
        for (int i = 0; i < outerRefList.size(); ++i) {
            OutsideReference outerRef = outerRefList.get(i);
            String mapId = outerRef.getRefToId();
            MapVO mapVO = this.getMapManageDao().loadMap(mapId);
            outerRef.setRefName(mapVO.getMapName());
        }
    }

    public void saveSchema(String publishId, ReferenceMap ref, ModelBook modelBook) throws AbstractQingIntegratedException, DashboardException {
        byte[] refContentBytes = XmlUtil.toByteArray((Element)modelBook.toXml());
        try {
            this.tx.beginRequired();
            String uid = ref.getUid();
            List outSideRef = modelBook.pickReferences();
            for (int i = 0; i < outSideRef.size(); ++i) {
                if (((OutsideReference)outSideRef.get(i)).getUid() != null) continue;
                throw new NotSelectMapException();
            }
            String userId = this.context.getUserId();
            this.getDashboardPublishDao().deleteOuterRefOfUser((String)ref.get((Object)"id"));
            this.getDashboardPublishDao().deleteRefContentUser(userId, publishId, uid);
            this.saveOuterRef(outSideRef, ref);
            this.getDashboardPublishDao().saveRefContentUser(userId, publishId, ref, refContentBytes);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new DashboardException((Throwable)e);
        }
        finally {
            this.tx.end();
        }
    }

    public void saveOuterRef(List<OutsideReference> outsideRefList, ReferenceMap refMap) throws AbstractQingIntegratedException, SQLException {
        for (int i = 0; i < outsideRefList.size(); ++i) {
            OutsideReference outsideRef = outsideRefList.get(i);
            ReferenceMap newRefMap = new ReferenceMap();
            newRefMap.setRefToFullPath(outsideRef.getRefToFullPath());
            newRefMap.setRefToId(outsideRef.getRefToId());
            newRefMap.setRefType(outsideRef.getRefType());
            newRefMap.setUid(outsideRef.getUid());
            this.getDashboardPublishDao().saveRefInfoOfUser(newRefMap, (String)refMap.get((Object)"id"));
        }
    }

    public ModelBook resetAndGetPubSchema(String publishId, ReferenceMap referenceMap) throws AbstractQingIntegratedException, DashboardException {
        byte[] refContent = null;
        try {
            this.tx.beginRequired();
            String uid = referenceMap.getUid();
            String userId = this.context.getUserId();
            this.getDashboardPublishDao().deleteRefContentUser(userId, publishId, uid);
            this.getDashboardPublishDao().deleteOuterRefOfUser((String)referenceMap.get((Object)"id"));
            refContent = this.getDashboardPublishDao().loadRefContent(publishId, uid);
            if (refContent != null) {
                List<OutsideReference> outsideRef = this.getDashboardPublishDao().loadSchemaRef((String)referenceMap.get((Object)"id"));
                ModelBook modelBook = DashboardModelUtil.byteToSchemaModel(refContent);
                modelBook.fixReferences(outsideRef);
                ModelBook modelBook2 = modelBook;
                return modelBook2;
            }
            ModelBook modelBook = null;
            return modelBook;
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (com.kingdee.bos.qing.core.exception.PersistentModelParseException e) {
            this.tx.markRollback();
            throw PersistentModelParseException.createParseError((Throwable)e);
        }
        catch (PersistentModelTooModernException e) {
            this.tx.markRollback();
            throw PersistentModelParseException.createParseError((Throwable)e);
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new DashboardException((Throwable)e);
        }
        finally {
            this.tx.end();
        }
    }

    public byte[] selectRefContent(String publishId, ReferenceMap ref) throws AbstractQingIntegratedException, SQLException {
        String uid = ref.getUid();
        String userId = this.context.getUserId();
        byte[] refContent = this.getDashboardPublishDao().selectRefContentUser(userId, publishId, uid);
        if (refContent == null) {
            refContent = this.getDashboardPublishDao().loadRefContent(publishId, uid);
        }
        return refContent;
    }

    public Map<String, String> getPublishDsbRefInfo(String publishId, ReferenceMap referenceMap) throws AbstractQingIntegratedException, DashboardException {
        try {
            HashMap<String, String> result = new HashMap<String, String>();
            PublishPO publishPO = this.getPublishInfoDao().getPublishInfoByInfoId(publishId);
            if (publishPO == null) {
                return null;
            }
            String refPK = this.getDashboardPublishDao().getRefPK(publishId, referenceMap.getUid());
            result.put("refPK", refPK);
            String refType = referenceMap.getRefType();
            RefTypeEnum refTypeEnum = RefTypeEnum.valueOf((String)refType);
            result.put("refType", refTypeEnum.name());
            result.put("refUid", referenceMap.getUid());
            result.put("isPreset", "" + publishPO.isPreset());
            result.put("publishTargetType", "" + publishPO.getPublishTargetType());
            IRefHandler refHandler = this.getRefHandler(refTypeEnum);
            if (refHandler instanceof ISecondPublishable) {
                ((ISecondPublishable)((Object)refHandler)).collectSecondPublishInfo(referenceMap, result);
            }
            if (publishPO.isCarryData()) {
                result.put("haveToCarryData", "true");
            }
            return result;
        }
        catch (SQLException e) {
            throw new DashboardException((Throwable)e);
        }
    }

    public void updateRefToId(String fullPath, String refToId, String refType) throws AbstractQingIntegratedException {
        try {
            String userId = this.context.getUserId();
            List<ReferenceMap> pubRefInfo = this.getDashboardPublishDao().loadRefListByFullPath(fullPath, refType, userId);
            for (int j = 0; j < pubRefInfo.size(); ++j) {
                ReferenceMap ref = pubRefInfo.get(j);
                ref.setRefToId(refToId);
                ref.setRefToFullPath(null);
                this.getDashboardPublishDao().updateRef(ref);
            }
        }
        catch (SQLException e) {
            LogUtil.error((String)"fail to upload ref", (Throwable)e);
        }
    }

    public void updateRefFullPath(String refToId, String fullPath, String refType) throws AbstractQingIntegratedException {
        try {
            String userId = this.context.getUserId();
            List<ReferenceMap> pubRefInfo = this.getDashboardPublishDao().loadRefListByRefToId(refToId, refType, userId);
            for (int i = 0; i < pubRefInfo.size(); ++i) {
                ReferenceMap ref = pubRefInfo.get(i);
                ref.setRefToId(" ");
                ref.setRefToFullPath(fullPath);
                this.getDashboardPublishDao().updateRef(ref);
            }
        }
        catch (SQLException e) {
            LogUtil.error((String)"fail to update ref", (Throwable)e);
        }
    }

    public List<ReferenceMap> getRefList(String publishId) throws AbstractQingIntegratedException, SQLException {
        return this.getDashboardPublishDao().getRefList(publishId);
    }

    public List<OutsideReference> loadOutsideReferences(String fid) throws AbstractQingIntegratedException, SQLException {
        return this.getDashboardPublishDao().loadSchemaRef(fid);
    }
}

