/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard.reference;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.ref.AbstractSwitchPathAndIdHandler;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.model.PushTargetType;
import com.kingdee.bos.qing.publish.target.lapp.dao.LappDao;
import com.kingdee.bos.qing.publish.target.lapp.model.LappSchedulePushConfigModel;
import com.kingdee.bos.qing.publish.thumbnail.model.ThumbnailUrlModel;
import java.sql.SQLException;
import java.util.List;

public class TimedPushLappUpdateRefPathAndIdHandle
implements AbstractSwitchPathAndIdHandler.IUpdateRefPathAndIdHandler {
    private LappDao lappDao;
    private IDBExcuter dbExcuter;
    private QingContext context;

    public TimedPushLappUpdateRefPathAndIdHandle(QingContext context, ITransactionManagement tx, IDBExcuter dbExcuter) {
        this.context = context;
        this.dbExcuter = dbExcuter;
    }

    private LappDao getLappDao() {
        if (this.lappDao == null) {
            this.lappDao = new LappDao(this.dbExcuter);
        }
        return this.lappDao;
    }

    public void updateRefIdToPath(RefTypeEnum refType, String refPath, String refToId, String userId) throws AbstractQingIntegratedException, SQLException {
        String dashboardSource = String.valueOf(PublishSourceEnum.dashboard);
        List<LappSchedulePushConfigModel> lappConfigs = this.getLappDao().loadTimedPublishRefConfigInfo(userId, dashboardSource, PushTargetType.YZJ_ROBOT, refToId);
        for (LappSchedulePushConfigModel lappConfig : lappConfigs) {
            String thumbnailPath = lappConfig.getThumbnailPath();
            ThumbnailUrlModel thumbnailUrlModel = ThumbnailUrlModel.fromJsonObject(thumbnailPath);
            thumbnailUrlModel.setImageFileName("");
            thumbnailUrlModel.setImageFullPathModel(thumbnailUrlModel.getImageFullPathfromJson(refPath));
            thumbnailPath = thumbnailUrlModel.toJsonObject();
            lappConfig.setThumbnailPath(thumbnailPath);
            this.getLappDao().updateConfigInfoThumbnail(lappConfig, userId);
        }
    }

    public void updateRefPathToId(RefTypeEnum refType, String refPath, String refId, String userId) throws AbstractQingIntegratedException, SQLException {
        String dashboardSource = String.valueOf(PublishSourceEnum.dashboard);
        List<LappSchedulePushConfigModel> lappConfigs = this.getLappDao().loadTimedPublishRefConfigInfo(userId, dashboardSource, PushTargetType.YZJ_ROBOT, refPath);
        for (LappSchedulePushConfigModel lappConfig : lappConfigs) {
            String thumbnailPath = lappConfig.getThumbnailPath();
            ThumbnailUrlModel thumbnailUrlModel = ThumbnailUrlModel.fromJsonObject(thumbnailPath);
            thumbnailUrlModel.setImageFileName(refId);
            thumbnailUrlModel.setImageFullPathModel(null);
            thumbnailPath = thumbnailUrlModel.toJsonObject();
            lappConfig.setThumbnailPath(thumbnailPath);
            this.getLappDao().updateConfigInfoThumbnail(lappConfig, userId);
        }
    }

    public int getTimedPublishRefTime(String imageName) throws AbstractQingIntegratedException, SQLException {
        String dashboardSource = String.valueOf(PublishSourceEnum.dashboard);
        String userId = this.context.getUserId();
        int publishConfigTimes = this.getLappDao().getTimedPublishRefTimeOfImage(userId, dashboardSource, PushTargetType.YZJ_ROBOT, imageName);
        return publishConfigTimes;
    }
}

