/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard.reference.impl;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.dashboard.reference.AbstractRefHandler;
import com.kingdee.bos.qing.dashboard.reference.IRefHandler;
import com.kingdee.bos.qing.dashboard.reference.impl.CardHandler;
import com.kingdee.bos.qing.dashboard.reference.impl.ExtreportAppHandler;
import com.kingdee.bos.qing.dashboard.reference.impl.PictureHandler;
import com.kingdee.bos.qing.dashboard.reference.impl.QingCenterHandler;
import com.kingdee.bos.qing.dashboard.reference.impl.SubjectHandler;
import com.kingdee.bos.qing.dashboard.reference.impl.UnsupportedWidgetSourceHandler;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.EnumMap;
import java.util.Map;

public class RefHandlerFactory {
    private static Map<RefTypeEnum, Class<? extends AbstractRefHandler>> map = new EnumMap<RefTypeEnum, Class<? extends AbstractRefHandler>>(RefTypeEnum.class);

    public static IRefHandler createHandler(RefTypeEnum typeEnum, IDBExcuter dbExcuter, QingContext context, ITransactionManagement tx) {
        AbstractRefHandler instance;
        Class<? extends AbstractRefHandler> clazz = map.get(typeEnum);
        try {
            if (clazz != null) {
                if (RefHandlerFactory.isMultipleSources(typeEnum)) {
                    Constructor<? extends AbstractRefHandler> constructor = clazz.getDeclaredConstructor(RefTypeEnum.class);
                    instance = constructor.newInstance(typeEnum);
                } else {
                    instance = clazz.newInstance();
                }
            } else {
                instance = new UnsupportedWidgetSourceHandler();
            }
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        instance.setDbExcuter(dbExcuter);
        instance.setContext(context);
        instance.setTx(tx);
        return instance;
    }

    public static void registerRefHandler(RefTypeEnum refType, Class<? extends AbstractRefHandler> clazz) {
        if (map.get(refType) == null) {
            map.put(refType, clazz);
        }
    }

    public static boolean isSupport(RefTypeEnum refType) {
        return map.get(refType) != null;
    }

    private static boolean isMultipleSources(RefTypeEnum refType) {
        boolean isMultipleSources = false;
        String refTypeStr = refType.toPersistance();
        if (refTypeStr.contains("qingcenter") || refTypeStr.contains("appmenu")) {
            isMultipleSources = true;
        }
        return isMultipleSources;
    }

    static {
        map.put(RefTypeEnum.picture, PictureHandler.class);
        map.put(RefTypeEnum.subject, SubjectHandler.class);
        map.put(RefTypeEnum.card, CardHandler.class);
        map.put(RefTypeEnum.qingcenter, QingCenterHandler.class);
        map.put(RefTypeEnum.qingcenter_rpt, QingCenterHandler.class);
        map.put(RefTypeEnum.qingcenter_qing, QingCenterHandler.class);
        map.put(RefTypeEnum.qingreport, ExtreportAppHandler.class);
    }
}

