/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.exporter.qhf.domain.scene;

import com.kingdee.bos.qing.common.cache.AbstractDataSource;
import com.kingdee.bos.qing.common.cache.ThemeDataSource;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.session.IQingSession;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.data.domain.source.SourceDomainFactory;
import com.kingdee.bos.qing.data.domain.source.db.AbstractDBSourceDomain;
import com.kingdee.bos.qing.data.exception.UnSupportDataSourceException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.Box;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.bos.qing.data.model.designtime.source.IFileSavable;
import com.kingdee.bos.qing.imexport.exporter.qhf.domain.scene.AbstractSchemaObjsQHFExporter;
import com.kingdee.bos.qing.imexport.model.PackageMeta;
import com.kingdee.bos.qing.imexport.model.SchemaInfo;
import com.kingdee.bos.qing.imexport.model.SchemaObject;
import com.kingdee.bos.qing.imexport.model.subject.AnalysisObject;
import com.kingdee.bos.qing.imexport.model.subject.DBInfo;
import com.kingdee.bos.qing.imexport.model.subject.DataModelingObject;
import com.kingdee.bos.qing.imexport.model.subject.SubjectObject;
import com.kingdee.bos.qing.imexport.model.subject.SubjectQsInfo;
import com.kingdee.bos.qing.imexport.strategy.IQHFStrategy;
import com.kingdee.bos.qing.imexport.util.ImExportUtil;
import com.kingdee.bos.qing.macro.domain.MacroCommonDomain;
import com.kingdee.bos.qing.manage.dao.IThemeDao;
import com.kingdee.bos.qing.manage.dao.IThemeGroupDao;
import com.kingdee.bos.qing.manage.dao.impl.ThemeDaoImpl;
import com.kingdee.bos.qing.manage.dao.impl.ThemeGroupDaoImpl;
import com.kingdee.bos.qing.manage.model.ThemeGroupVO;
import com.kingdee.bos.qing.manage.model.ThemePO;
import com.kingdee.bos.qing.schema.model.SchemaBO;
import com.kingdee.bos.qing.subject.dao.BoxSerializationUtil;
import com.kingdee.bos.qing.subject.dao.ISubjectDao;
import com.kingdee.bos.qing.subject.dao.impl.SubjectDaoImpl;
import com.kingdee.bos.qing.util.IntegratedHelper;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jdom2.JDOMException;

public abstract class AbstractSubjectQHFExporter
extends AbstractSchemaObjsQHFExporter {
    private IThemeDao iThemeDao;
    private ISubjectDao iSubjectDao;
    private IThemeGroupDao themeGroupDao;
    private MacroCommonDomain macroDomain;

    public AbstractSubjectQHFExporter(QingContext qingContext, IDBExcuter dbExcuter, ITransactionManagement tx) {
        super(qingContext, dbExcuter, tx);
    }

    private IThemeDao getThemeDao() {
        if (this.iThemeDao == null) {
            this.iThemeDao = new ThemeDaoImpl(this.dbExcuter);
        }
        return this.iThemeDao;
    }

    private ISubjectDao getSubjectDao() {
        if (this.iSubjectDao == null) {
            this.iSubjectDao = new SubjectDaoImpl(this.dbExcuter);
        }
        return this.iSubjectDao;
    }

    private IThemeGroupDao getThemeGroupDao() {
        if (this.themeGroupDao == null) {
            this.themeGroupDao = new ThemeGroupDaoImpl(this.dbExcuter);
        }
        return this.themeGroupDao;
    }

    private MacroCommonDomain getMacroDomain() {
        if (this.macroDomain == null) {
            this.macroDomain = new MacroCommonDomain(this.dbExcuter, this.qingContext);
        }
        return this.macroDomain;
    }

    protected abstract List<SchemaBO> loadSchemaList(String var1, String var2) throws AbstractQingIntegratedException, SQLException;

    @Override
    public void export(Map<String, String> params, PackageMeta meta) throws AbstractQingException, SQLException, IOException, JDOMException {
        String themeId = params.get("themeId");
        String tag = params.get("tag");
        ThemePO themePO = this.getThemeDao().getThemeByID(themeId);
        if (themePO == null) {
            return;
        }
        SubjectObject subjectObj = new SubjectObject();
        subjectObj.setThemeVO(themePO.toVo());
        String userId = themePO.getUserID();
        ThemeGroupVO themeGroupVO = this.getThemeGroupDao().loadThemeGroupByGroupId(userId, themePO.getGroupID());
        subjectObj.setThemeGroupVO(themeGroupVO);
        Box box = this.getSubjectDao().loadSubjectModelIncludePreset(userId, themePO.getThemeID());
        if (box != null) {
            List<DBInfo> dbInfos;
            DataModelingObject dataModelingObj = new DataModelingObject();
            List macroUids = box.collectMacroUid();
            for (String macroUid : macroUids) {
                meta.getResources().addMacroUid(macroUid);
            }
            InputStream dbStream = this.getSubjectDao().loadSubjectModelStream(this.qingContext.getUserId(), themePO.getThemeID());
            byte[] boxBytes = BoxSerializationUtil.toBytes(box, null, dbStream);
            String boxTempFileName = ImExportUtil.writeBytesToExportTempFile(boxBytes);
            dataModelingObj.setBoxFileName(boxTempFileName);
            if (box.getSources() != null && !box.getSources().isEmpty()) {
                HashSet<String> dsFileNames = new HashSet<String>(16);
                for (AbstractSource source : box.getSources()) {
                    if (!(source instanceof IFileSavable)) continue;
                    IFileSavable iFileSavable = (IFileSavable)source;
                    String fileUrl = ((IFileSavable)source).getFileUrl();
                    String fileName = iFileSavable.getFileName();
                    String fileExtension = "";
                    if (fileName.indexOf(".") > -1) {
                        fileExtension = fileName.substring(fileName.lastIndexOf("."));
                    }
                    dsFileNames.add(fileUrl + fileExtension);
                }
                dataModelingObj.setDsFileNames(dsFileNames);
            }
            if ((dbInfos = this.getDBInfos(box.getSources())) != null && !dbInfos.isEmpty()) {
                dataModelingObj.setDbInfos(dbInfos);
            }
            subjectObj.setDataModelingObj(dataModelingObj);
        }
        AnalysisObject analysisObj = new AnalysisObject();
        List<SchemaObject> extraSchemaObjects = this.getExtraSchemaObjects(params, tag, meta);
        ArrayList<SchemaObject> schemaObjs = new ArrayList<SchemaObject>(10);
        List<SchemaBO> schemaList = this.loadSchemaList(themePO.getThemeID(), userId);
        for (SchemaBO schemaBO : schemaList) {
            SchemaObject schemaObj = new SchemaObject();
            SchemaInfo schemaInfo = new SchemaInfo();
            schemaInfo.setSchemaBO(schemaBO);
            byte[] schemaContent = this.getSchemaDao().loadSchemaContent(schemaBO.getfId());
            String schemaContentFileName = ImExportUtil.writeBytesToExportTempFile(schemaContent);
            schemaInfo.setSchemaContentFile(schemaContentFileName);
            schemaObj.setSchemaInfo(schemaInfo);
            List<OutsideReference> outSideRefList = this.getOutsideRefs(schemaBO, meta);
            schemaObj.setOutSideRefs(outSideRefList);
            schemaObjs.add(schemaObj);
        }
        schemaObjs.addAll(extraSchemaObjects);
        analysisObj.setSchemaObjs(schemaObjs);
        SubjectQsInfo subjectQsInfo = new SubjectQsInfo();
        IQingSession qingSession = QingSessionUtil.getQingSessionImpl();
        AbstractDataSource dataSource = (AbstractDataSource)qingSession.getCache(AbstractDataSource.getCacheKey(tag), AbstractDataSource.class);
        if (dataSource != null) {
            ThemeDataSource themeDataSource = (ThemeDataSource)dataSource;
            Map<String, String> dataFiles = themeDataSource.getDataFiles();
            subjectQsInfo.setQs(dataFiles);
            subjectQsInfo.setExtractTimestamp(themeDataSource.getExtractDataTime());
            subjectQsInfo.setOriginalCreatorId(themeDataSource.getOriginalCreatorId());
            subjectQsInfo.setOriginalCreatorName(IntegratedHelper.getUserName((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (String)themeDataSource.getOriginalCreatorId()));
            subjectQsInfo.setExtractDataTraceSpans(themeDataSource.getExtractDataTraceSpans());
            analysisObj.setSubjectQsInfo(subjectQsInfo);
        }
        subjectObj.setAnalysisObj(analysisObj);
        meta.getSubjectObjs().add(subjectObj);
    }

    private List<DBInfo> getDBInfos(List<AbstractSource> sourceList) throws UnSupportDataSourceException, SQLException {
        ArrayList<DBInfo> dbInfos = new ArrayList<DBInfo>();
        for (AbstractSource source : sourceList) {
            IQHFStrategy qhfStrategy = (IQHFStrategy)CustomStrategyRegistrar.getStrategy(IQHFStrategy.class);
            if (qhfStrategy == null) {
                throw new RuntimeException("cannot found the implement of IQHFStrategy.");
            }
            DBSource dbSource = qhfStrategy.getDBSource(source, this.qingContext);
            if (dbSource == null) continue;
            AbstractDBSourceDomain dbSourceDomain = (AbstractDBSourceDomain)SourceDomainFactory.getSourceDomain((AbstractSource)dbSource);
            String dbVersion = dbSourceDomain.getDbVersion(dbSource);
            DBInfo dbInfo = new DBInfo();
            dbInfo.setSourceId(dbSource.getName());
            dbInfo.setDbType(dbSource.getDbType().toPersistance());
            dbInfo.setDbVersion(dbVersion);
            dbInfos.add(dbInfo);
        }
        return dbInfos;
    }
}

