/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.importer.qhf.domain.dm;

import com.kingdee.bos.qing.common.cache.ThemeDataSource;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.data.model.designtime.Box;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.imexport.importer.exception.ImportCacheNotFoundException;
import com.kingdee.bos.qing.imexport.importer.exception.ImportNoInfoFoundException;
import com.kingdee.bos.qing.imexport.importer.qhf.domain.dm.QHFCacheNotFoundException;
import com.kingdee.bos.qing.imexport.model.ImportedModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class QHFDmUtil {
    public static Box loadModel(String tag) throws ImportNoInfoFoundException {
        String cacheKey = ThemeDataSource.getCacheKey(tag);
        ThemeDataSource themeDataSource = (ThemeDataSource)QingSessionUtil.getCache((String)cacheKey, ThemeDataSource.class);
        if (themeDataSource != null) {
            return themeDataSource.getBoxModel();
        }
        throw new ImportNoInfoFoundException();
    }

    public static IQingFileVisitor getEntityQsFile(String tag, String entityName) throws QHFCacheNotFoundException, ImportNoInfoFoundException {
        String cacheKey = ThemeDataSource.getCacheKey(tag);
        ThemeDataSource themeDataSource = (ThemeDataSource)QingSessionUtil.getCache((String)cacheKey, ThemeDataSource.class);
        if (themeDataSource != null) {
            Map<String, String> dataFiles = themeDataSource.getDataFiles();
            String qsFileName = dataFiles.get(entityName);
            IQingFileVisitor qsFile = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.TEMP_QS, (String)qsFileName);
            return qsFile;
        }
        throw new ImportNoInfoFoundException();
    }

    public static List<String> loadSystemVarTypes(String packageMetaTag) throws ImportCacheNotFoundException {
        String cacheKey = ImportedModel.getCacheKey(packageMetaTag);
        ImportedModel importedModel = (ImportedModel)QingSessionUtil.getCache((String)cacheKey, ImportedModel.class);
        if (importedModel != null) {
            Map<String, String> varTypes = importedModel.getPackageMeta().getEnvironment().getUserContext().getSystemVars();
            return new ArrayList<String>(varTypes.keySet());
        }
        throw new ImportCacheNotFoundException();
    }
}

