/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.importer.qhf.domain.modelparser.common;

import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.common.trace.TraceSpan;
import com.kingdee.bos.qing.dashboard.dao.DashboardSerializationUtil;
import com.kingdee.bos.qing.dashboard.exception.PersistentModelParseException;
import com.kingdee.bos.qing.dashboard.model.DashboardModel;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.dashboard.reference.IExImportable;
import com.kingdee.bos.qing.dashboard.reference.IPrepareDataable;
import com.kingdee.bos.qing.dashboard.reference.IRefHandler;
import com.kingdee.bos.qing.dashboard.reference.impl.RefHandlerFactory;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.imexport.importer.exception.ImportEncryptedLicenseCheckException;
import com.kingdee.bos.qing.imexport.importer.exception.ImportException;
import com.kingdee.bos.qing.imexport.importer.qhf.model.SourceTypeVO;
import com.kingdee.bos.qing.imexport.importer.qhf.model.TraceSpanVO;
import com.kingdee.bos.qing.imexport.importer.qhf.model.datasourceinfovo.AbstractDataSourceInfoVO;
import com.kingdee.bos.qing.imexport.importer.qhf.model.datasourceinfovo.DsbDataSourceInfoVO;
import com.kingdee.bos.qing.imexport.importer.qhf.model.datasourceinfovo.DsbRefDataSourceInfoVO;
import com.kingdee.bos.qing.imexport.importer.qhf.model.datasourceinfovo.GeneralDataSourceInfoVO;
import com.kingdee.bos.qing.imexport.model.ImportedModel;
import com.kingdee.bos.qing.imexport.model.dashboard.DsbRefObject;
import com.kingdee.bos.qing.imexport.util.ImExportUtil;
import com.kingdee.bos.qing.imexport.util.QHFDsbUtil;
import com.kingdee.bos.qing.manage.exception.EncryptedLicenseCheckException;
import com.kingdee.bos.qing.manage.model.ThemeGroupVO;
import com.kingdee.bos.qing.manage.model.ThemeVO;
import com.kingdee.bos.qing.util.BoxUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AbstractDsbModelParser {
    private Map<RefTypeEnum, IRefHandler> refHandlerMap;

    protected IRefHandler getRefHandler(RefTypeEnum refType) {
        IRefHandler refHandler;
        if (this.refHandlerMap == null) {
            this.refHandlerMap = new HashMap<RefTypeEnum, IRefHandler>();
        }
        if ((refHandler = this.refHandlerMap.get(refType)) == null) {
            refHandler = RefHandlerFactory.createHandler(refType, null, null, null);
            this.refHandlerMap.put(refType, refHandler);
        }
        return refHandler;
    }

    protected void cacheDsbRefsDataSource(String tag, ImportedModel importedModel, List<DsbRefObject> dsbRefObjs, String dashboardUniqueId, boolean isPublished) throws ImportException {
        if (dsbRefObjs != null) {
            for (DsbRefObject dsbRefObj : dsbRefObjs) {
                ReferenceMap referenceMap = dsbRefObj.getReferenceMap();
                String refType = referenceMap.getRefType();
                RefTypeEnum refTypeEnum = RefTypeEnum.valueOf((String)refType);
                IRefHandler refHandler = this.getRefHandler(refTypeEnum);
                if (!(refHandler instanceof IExImportable)) continue;
                String uid = referenceMap.getUid();
                String refTag = QHFDsbUtil.getRefUniqueKeyForImport(tag, dashboardUniqueId, isPublished, uid);
                ((IExImportable)((Object)refHandler)).cacheQHFDataSource(refTag, referenceMap, importedModel);
            }
        }
    }

    protected DsbDataSourceInfoVO getDsbDataSourceInfo(String tag, String dashboardUniqueId, boolean isPublished, ThemeVO themeVO, ThemeGroupVO themeGroupVO, String dsbModelFileName, List<DsbRefObject> dsbRefObjects, ImportedModel importedModel) throws ImportException {
        try {
            DsbDataSourceInfoVO dsbDataSourceInfoVO = new DsbDataSourceInfoVO();
            dsbDataSourceInfoVO.setSourceType(SourceTypeVO.SourceTypeEnum.dsb.name());
            dsbDataSourceInfoVO.setGroupName(themeGroupVO.getThemeGroupName());
            dsbDataSourceInfoVO.setDescription(themeVO.getDescription());
            dsbDataSourceInfoVO.setName(themeVO.getThemeName());
            String dashboardModelContentFileName = importedModel.getTempFileMap().get(dsbModelFileName);
            InputStream dasbModelStream = BoxUtil.getBoxStreamByFileName(dashboardModelContentFileName, (AbstractQingFileType)QingTempFileType.UPLOAD);
            if (dasbModelStream != null) {
                DashboardModel dashboardModel = DashboardSerializationUtil.toModel(dasbModelStream);
                if (dsbRefObjects != null) {
                    HashMap<String, DsbRefDataSourceInfoVO> uniqueRefDataSourceInfoMap = new HashMap<String, DsbRefDataSourceInfoVO>();
                    for (DsbRefObject dsbRefObject : dsbRefObjects) {
                        String refTag;
                        ReferenceMap referenceMap = dsbRefObject.getReferenceMap();
                        String uid = referenceMap.getUid();
                        String refType = referenceMap.getRefType();
                        RefTypeEnum refTypeEnum = RefTypeEnum.valueOf((String)refType);
                        IRefHandler refHandler = this.getRefHandler(refTypeEnum);
                        if (!(refHandler instanceof IPrepareDataable) || (refTag = ((IPrepareDataable)((Object)refHandler)).getQHFUniqueRefId(referenceMap.getRefToId(), importedModel.getPackageMeta())) == null || !(refHandler instanceof IExImportable)) continue;
                        String widgetDisplayName = dashboardModel.searchReferenceWidgetDisplayName(referenceMap.getUid());
                        if (uniqueRefDataSourceInfoMap.containsKey(refTag)) {
                            DsbRefDataSourceInfoVO dsbRefDataSourceInfoVO = (DsbRefDataSourceInfoVO)uniqueRefDataSourceInfoMap.get(refTag);
                            if (dsbRefDataSourceInfoVO == null) continue;
                            dsbRefDataSourceInfoVO.getWidgetDisplayNames().add(widgetDisplayName);
                            continue;
                        }
                        AbstractDataSourceInfoVO dataSourceInfoVO = ((IExImportable)((Object)refHandler)).getQHFDataSourceInfo(tag, referenceMap, importedModel);
                        DsbRefDataSourceInfoVO dsbRefDataSourceInfoVO = new DsbRefDataSourceInfoVO();
                        dsbRefDataSourceInfoVO.setDataSourceInfoVO(dataSourceInfoVO);
                        dsbRefDataSourceInfoVO.getWidgetDisplayNames().add(widgetDisplayName);
                        String refDataSourceTag = QHFDsbUtil.getRefUniqueKeyForImport(tag, dashboardUniqueId, isPublished, uid);
                        dsbRefDataSourceInfoVO.setRefDataSourceTag(refDataSourceTag);
                        uniqueRefDataSourceInfoMap.put(refTag, dsbRefDataSourceInfoVO);
                        dsbDataSourceInfoVO.getDsbRefDataSourceInfoVOs().add(dsbRefDataSourceInfoVO);
                    }
                }
            }
            return dsbDataSourceInfoVO;
        }
        catch (IOException e) {
            throw new ImportException(e);
        }
        catch (PersistentModelParseException e) {
            throw new ImportException(e);
        }
        catch (EncryptedLicenseCheckException e) {
            throw new ImportEncryptedLicenseCheckException(e.getMessage(), e.getErrorCode());
        }
    }

    protected List<TraceSpanVO> getTraceSpanInfo(String tag, String dsbModelFileName, List<DsbRefObject> dsbRefObjects, ImportedModel importedModel) throws ImportException {
        try {
            ArrayList<TraceSpanVO> traceSpanVOList = new ArrayList<TraceSpanVO>(10);
            String dashboardModelContentFileName = importedModel.getTempFileMap().get(dsbModelFileName);
            InputStream dasbModelStream = BoxUtil.getBoxStreamByFileName(dashboardModelContentFileName, (AbstractQingFileType)QingTempFileType.UPLOAD);
            if (dasbModelStream != null) {
                DashboardModel dashboardModel = DashboardSerializationUtil.toModel(dasbModelStream);
                if (dsbRefObjects != null) {
                    for (DsbRefObject dsbRefObject : dsbRefObjects) {
                        GeneralDataSourceInfoVO generalDataSourceInfoVO;
                        List<TraceSpan> extractDataTraceSpans;
                        IRefHandler refHandler;
                        ReferenceMap referenceMap = dsbRefObject.getReferenceMap();
                        String refType = referenceMap.getRefType();
                        RefTypeEnum refTypeEnum = RefTypeEnum.valueOf((String)refType);
                        if (refTypeEnum == RefTypeEnum.picture || !((refHandler = this.getRefHandler(refTypeEnum)) instanceof IExImportable)) continue;
                        String widgetDisplayName = dashboardModel.searchReferenceWidgetDisplayName(referenceMap.getUid());
                        TraceSpanVO widgetNodeTraceSpanVO = new TraceSpanVO();
                        widgetNodeTraceSpanVO.setLevel(0);
                        widgetNodeTraceSpanVO.setDescription(widgetDisplayName);
                        traceSpanVOList.add(widgetNodeTraceSpanVO);
                        AbstractDataSourceInfoVO dataSourceInfoVO = ((IExImportable)((Object)refHandler)).getQHFDataSourceInfo(tag, referenceMap, importedModel);
                        if (dataSourceInfoVO != null && (extractDataTraceSpans = (generalDataSourceInfoVO = (GeneralDataSourceInfoVO)dataSourceInfoVO).getExtractDataTraceSpans()) != null && !extractDataTraceSpans.isEmpty()) {
                            TraceSpanVO extractDataNodeTraceSpanVO = new TraceSpanVO();
                            extractDataNodeTraceSpanVO.setLevel(1);
                            extractDataNodeTraceSpanVO.setDescription(Messages.getMLS((String)"dataExtract", (String)"\u6570\u636e\u62bd\u53d6", (Messages.ProjectName)Messages.ProjectName.QING_THEME));
                            traceSpanVOList.add(extractDataNodeTraceSpanVO);
                            List<TraceSpanVO> extractDataTraceSpanVOs = ImExportUtil.traceSpansToVOs(extractDataTraceSpans, 2);
                            traceSpanVOList.addAll(extractDataTraceSpanVOs);
                        }
                        String joinTraceFileName = dsbRefObject.getJoinTraceFile();
                        List<TraceSpanVO> joinTraceSpanVOs = ImExportUtil.getTraceSpanVOsByZipTraceFileName(joinTraceFileName, importedModel, 1, Messages.getMLS((String)"joinTask", (String)"JOIN\u4efb\u52a1", (Messages.ProjectName)Messages.ProjectName.QING_THEME));
                        traceSpanVOList.addAll(joinTraceSpanVOs);
                        String executeTraceFileName = dsbRefObject.getExecuteTraceFile();
                        List<TraceSpanVO> executeTraceSpanVOs = ImExportUtil.getTraceSpanVOsByZipTraceFileName(executeTraceFileName, importedModel, 1, Messages.getMLS((String)"schemaExecute", (String)"\u65b9\u6848\u6267\u884c", (Messages.ProjectName)Messages.ProjectName.QING_THEME));
                        traceSpanVOList.addAll(executeTraceSpanVOs);
                    }
                }
            }
            return traceSpanVOList;
        }
        catch (IOException e) {
            throw new ImportException(e);
        }
        catch (PersistentModelParseException e) {
            throw new ImportException(e);
        }
        catch (EncryptedLicenseCheckException e) {
            throw new ImportEncryptedLicenseCheckException(e.getMessage(), e.getErrorCode());
        }
    }
}

