/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.importer.qhf.domain.modelparser.publish;

import com.kingdee.bos.qing.imexport.importer.qhf.domain.modelparser.publish.IPublishModelParser;
import com.kingdee.bos.qing.imexport.importer.qhf.domain.modelparser.publish.impl.PublishDsbModelParser;
import com.kingdee.bos.qing.imexport.importer.qhf.domain.modelparser.publish.impl.PublishEmbeddedModelParser;
import com.kingdee.bos.qing.imexport.importer.qhf.domain.modelparser.publish.impl.PublishSubjectModelParser;
import com.kingdee.bos.qing.imexport.model.QHFSceneTypeEnum;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;

public class PublishModelParserFactory {
    public static IPublishModelParser getParserByPublishSourceType(PublishSourceEnum publishSourceType) {
        switch (publishSourceType) {
            case subject: {
                return new PublishSubjectModelParser();
            }
            case bill: {
                return new PublishEmbeddedModelParser();
            }
            case dashboard: {
                return new PublishDsbModelParser();
            }
        }
        throw new RuntimeException("can't confirm publishSourceType");
    }

    public static IPublishModelParser getParserBySceneType(String sceneType) {
        QHFSceneTypeEnum sceneTypeEnum = QHFSceneTypeEnum.valueOf(sceneType);
        switch (sceneTypeEnum) {
            case publishSubjectLonger: 
            case publishSubjectSquare: {
                return new PublishSubjectModelParser();
            }
            case publishEmbeddedLonger: 
            case publishEmbeddedSquare: {
                return new PublishEmbeddedModelParser();
            }
            case publishDsb: {
                return new PublishDsbModelParser();
            }
        }
        throw new RuntimeException("can't confirm sceneTypeEnum");
    }
}

