/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.importer.qhf.domain.modelparser.publish.impl;

import com.kingdee.bos.qing.imexport.importer.exception.ImportException;
import com.kingdee.bos.qing.imexport.importer.exception.ImportNoInfoFoundException;
import com.kingdee.bos.qing.imexport.importer.qhf.domain.modelparser.common.AbstractEmbeddedModelParser;
import com.kingdee.bos.qing.imexport.importer.qhf.domain.modelparser.publish.IPublishModelParser;
import com.kingdee.bos.qing.imexport.importer.qhf.model.TraceSpanVO;
import com.kingdee.bos.qing.imexport.importer.qhf.model.datasourceinfovo.EmbededDataSourceInfoVO;
import com.kingdee.bos.qing.imexport.model.ImportedModel;
import com.kingdee.bos.qing.imexport.model.SchemaObject;
import com.kingdee.bos.qing.imexport.model.embeddeddata.EmbeddedDataInfo;
import com.kingdee.bos.qing.imexport.model.embeddeddata.EmbeddedDataObject;
import com.kingdee.bos.qing.imexport.model.embeddeddata.EmbeddedDataQsInfo;
import com.kingdee.bos.qing.imexport.model.publish.AbstractPublishObject;
import com.kingdee.bos.qing.imexport.model.publish.LongerSquarePublishObject;
import com.kingdee.bos.qing.imexport.model.publish.embedded.EmbeddedCarryDataInfo;
import com.kingdee.bos.qing.publish.model.PublishPO;
import java.util.List;

public class PublishEmbeddedModelParser
extends AbstractEmbeddedModelParser
implements IPublishModelParser {
    @Override
    public void cacheDataSource(String tag, ImportedModel importedModel) throws ImportException {
        List<AbstractPublishObject> publishObjs = importedModel.getPackageMeta().getPublishObjs();
        if (publishObjs != null && !publishObjs.isEmpty()) {
            AbstractPublishObject publishObject = publishObjs.get(0);
            PublishPO publishPO = publishObject.getPublishPO();
            if (publishPO.isCarryData()) {
                this.cachePublishedCarryDataDataSource(tag, publishObject, importedModel);
            } else {
                String id = publishPO.getId();
                this.cacheNotCarryDataDataSourceById(tag, id, importedModel);
            }
        }
    }

    @Override
    public EmbededDataSourceInfoVO getDataSourceInfo(String tag, PublishPO publishPO, ImportedModel importedModel) throws ImportException {
        block4: {
            block3: {
                if (!publishPO.isCarryData()) break block3;
                List<AbstractPublishObject> publishObjects = importedModel.getPackageMeta().getPublishObjs();
                if (publishObjects == null || publishObjects.isEmpty()) break block4;
                for (AbstractPublishObject publishObject : publishObjects) {
                    if (publishObject == null || !publishPO.getId().equals(publishObject.getPublishPO().getId())) continue;
                    EmbeddedCarryDataInfo embeddedCarryDataInfo = (EmbeddedCarryDataInfo)publishObject.getCarryDataInfo();
                    EmbeddedDataInfo embeddedDataInfo = embeddedCarryDataInfo.getEmbeddedDataInfo();
                    return embeddedDataInfo.getDataSourceInfoVO();
                }
                break block4;
            }
            List<EmbeddedDataObject> embeddedDataObjs = importedModel.getPackageMeta().getEmbeddedDataObjs();
            if (embeddedDataObjs != null && !embeddedDataObjs.isEmpty()) {
                for (EmbeddedDataObject embeddedDataObject : embeddedDataObjs) {
                    if (embeddedDataObject == null || !publishPO.getId().equals(embeddedDataObject.getEmbeddedDataInfo().getId())) continue;
                    return this.getDataSourceInfoByEmbeddedDataObject(embeddedDataObject, importedModel);
                }
            }
        }
        throw new ImportNoInfoFoundException();
    }

    @Override
    public void cacheDataSourceByPublishPO(String tag, PublishPO publishPO, ImportedModel importedModel) throws ImportException {
        if (publishPO.isCarryData()) {
            List<AbstractPublishObject> publishObjects = importedModel.getPackageMeta().getPublishObjs();
            if (publishObjects != null && !publishObjects.isEmpty()) {
                for (AbstractPublishObject publishObject : publishObjects) {
                    if (publishObject == null || !publishPO.getId().equals(publishObject.getPublishPO().getId())) continue;
                    this.cachePublishedCarryDataDataSource(tag, publishObject, importedModel);
                    break;
                }
            }
        } else {
            String id = publishPO.getId();
            this.cacheNotCarryDataDataSourceById(tag, id, importedModel);
        }
    }

    @Override
    public List<TraceSpanVO> getTraceSpanInfo(String tag, PublishPO publishPO, ImportedModel importedModel) throws ImportException {
        List<AbstractPublishObject> publishObjects = importedModel.getPackageMeta().getPublishObjs();
        if (publishObjects != null && !publishObjects.isEmpty()) {
            for (AbstractPublishObject publishObject : publishObjects) {
                if (publishObject == null || !publishPO.getId().equals(publishObject.getPublishPO().getId())) continue;
                LongerSquarePublishObject longerSquarePublishObject = (LongerSquarePublishObject)publishObject;
                List<SchemaObject> schemaObjects = longerSquarePublishObject.getSchemaObjs();
                EmbeddedDataQsInfo embeddedDataQsInfo = null;
                if (publishPO.isCarryData()) {
                    EmbeddedCarryDataInfo embeddedCarryDataInfo = (EmbeddedCarryDataInfo)publishObject.getCarryDataInfo();
                    embeddedDataQsInfo = embeddedCarryDataInfo.getEmbeddedDataQsInfo();
                } else {
                    List<EmbeddedDataObject> embeddedDataObjs = importedModel.getPackageMeta().getEmbeddedDataObjs();
                    if (embeddedDataObjs != null && !embeddedDataObjs.isEmpty()) {
                        for (EmbeddedDataObject embeddedDataObject : embeddedDataObjs) {
                            if (!publishPO.getId().equals(embeddedDataObject.getEmbeddedDataInfo().getId())) continue;
                            embeddedDataQsInfo = embeddedDataObject.getEmbeddedDataQsInfo();
                            break;
                        }
                    }
                }
                return this.getTraceSpanInfo(embeddedDataQsInfo, schemaObjects, importedModel);
            }
        }
        return null;
    }

    private void cacheNotCarryDataDataSourceById(String tag, String id, ImportedModel importedModel) throws ImportException {
        List<EmbeddedDataObject> embeddedDataObjs = importedModel.getPackageMeta().getEmbeddedDataObjs();
        if (embeddedDataObjs != null && !embeddedDataObjs.isEmpty()) {
            for (EmbeddedDataObject embeddedDataObject : embeddedDataObjs) {
                if (!id.equals(embeddedDataObject.getEmbeddedDataInfo().getId())) continue;
                this.cacheDataSource(embeddedDataObject.getEmbeddedDataQsInfo(), tag, importedModel);
                break;
            }
        }
    }

    private void cachePublishedCarryDataDataSource(String tag, AbstractPublishObject publishObject, ImportedModel importedModel) throws ImportException {
        try {
            EmbeddedCarryDataInfo embeddedCarryDataInfo = (EmbeddedCarryDataInfo)publishObject.getCarryDataInfo();
            this.cacheDataSource(embeddedCarryDataInfo.getEmbeddedDataQsInfo(), tag, importedModel);
        }
        catch (Exception e) {
            throw new ImportException(e);
        }
    }
}

