/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.importer.qhf.domain.modelparser.scene.impl;

import com.kingdee.bos.qing.imexport.importer.exception.ImportException;
import com.kingdee.bos.qing.imexport.importer.exception.ImportNoInfoFoundException;
import com.kingdee.bos.qing.imexport.importer.qhf.domain.modelparser.common.AbstractDsbModelParser;
import com.kingdee.bos.qing.imexport.importer.qhf.domain.modelparser.scene.IModelParser;
import com.kingdee.bos.qing.imexport.importer.qhf.model.EntranceInfoVO;
import com.kingdee.bos.qing.imexport.importer.qhf.model.TraceSpanVO;
import com.kingdee.bos.qing.imexport.importer.qhf.model.datasourceinfovo.DsbDataSourceInfoVO;
import com.kingdee.bos.qing.imexport.model.ImportedModel;
import com.kingdee.bos.qing.imexport.model.SchemaObject;
import com.kingdee.bos.qing.imexport.model.dashboard.DashboardObject;
import com.kingdee.bos.qing.imexport.model.dashboard.DsbRefObject;
import java.util.List;

public class DsbModelParser
extends AbstractDsbModelParser
implements IModelParser {
    @Override
    public void cacheDataSource(String tag, ImportedModel importedModel) throws ImportException {
        List<DashboardObject> dashboardObjects = importedModel.getPackageMeta().getDashboardObjs();
        if (dashboardObjects != null && !dashboardObjects.isEmpty()) {
            DashboardObject dashboardObject = dashboardObjects.get(0);
            this.cacheDsbRefsDataSource(tag, importedModel, dashboardObject.getDsbRefObjs(), dashboardObject.getThemeVO().getThemeID(), false);
        }
    }

    @Override
    public DsbDataSourceInfoVO getDataSourceInfo(String tag, ImportedModel importedModel) throws ImportException {
        DashboardObject dashboardObject;
        List<DashboardObject> dashboardObjs = importedModel.getPackageMeta().getDashboardObjs();
        if (dashboardObjs != null && !dashboardObjs.isEmpty() && (dashboardObject = dashboardObjs.get(0)) != null) {
            List<DsbRefObject> dsbRefObjects = dashboardObject.getDsbRefObjs();
            return this.getDsbDataSourceInfo(tag, dashboardObject.getThemeVO().getThemeID(), false, dashboardObject.getThemeVO(), dashboardObject.getThemeGroupVO(), dashboardObject.getDsbModelFileName(), dsbRefObjects, importedModel);
        }
        throw new ImportNoInfoFoundException();
    }

    @Override
    public EntranceInfoVO getEntranceInfo(String tag, ImportedModel importedModel) {
        EntranceInfoVO entranceInfoVO = new EntranceInfoVO();
        entranceInfoVO.setEntranceType(EntranceInfoVO.EntranceTypeEnum.dsb.name());
        return entranceInfoVO;
    }

    @Override
    public List<SchemaObject> getSchemaObjs(ImportedModel importedModel) {
        return null;
    }

    @Override
    public List<TraceSpanVO> getTraceSpanInfo(String tag, ImportedModel importedModel) throws ImportException {
        DashboardObject dashboardObject;
        List<DashboardObject> dashboardObjs = importedModel.getPackageMeta().getDashboardObjs();
        if (dashboardObjs != null && !dashboardObjs.isEmpty() && (dashboardObject = dashboardObjs.get(0)) != null) {
            return this.getTraceSpanInfo(tag, dashboardObject.getDsbModelFileName(), dashboardObject.getDsbRefObjs(), importedModel);
        }
        return null;
    }
}

