/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.importer.qhf.domain.modelparser.scene.impl;

import com.kingdee.bos.qing.imexport.importer.exception.ImportException;
import com.kingdee.bos.qing.imexport.importer.exception.ImportNoInfoFoundException;
import com.kingdee.bos.qing.imexport.importer.qhf.domain.modelparser.common.AbstractEmbeddedModelParser;
import com.kingdee.bos.qing.imexport.importer.qhf.domain.modelparser.scene.IModelParser;
import com.kingdee.bos.qing.imexport.importer.qhf.model.EntranceInfoVO;
import com.kingdee.bos.qing.imexport.importer.qhf.model.TraceSpanVO;
import com.kingdee.bos.qing.imexport.importer.qhf.model.datasourceinfovo.AbstractDataSourceInfoVO;
import com.kingdee.bos.qing.imexport.model.ImportedModel;
import com.kingdee.bos.qing.imexport.model.SchemaObject;
import com.kingdee.bos.qing.imexport.model.embeddeddata.EmbeddedDataObject;
import java.util.List;

public class EmbeddedModelParser
extends AbstractEmbeddedModelParser
implements IModelParser {
    @Override
    public void cacheDataSource(String tag, ImportedModel importedModel) throws ImportException {
        EmbeddedDataObject embeddedDataObject;
        List<EmbeddedDataObject> embeddedDataObjs = importedModel.getPackageMeta().getEmbeddedDataObjs();
        if (embeddedDataObjs != null && !embeddedDataObjs.isEmpty() && (embeddedDataObject = embeddedDataObjs.get(0)) != null) {
            this.cacheDataSource(embeddedDataObject.getEmbeddedDataQsInfo(), tag, importedModel);
        }
    }

    @Override
    public List<SchemaObject> getSchemaObjs(ImportedModel importedModel) throws ImportNoInfoFoundException {
        EmbeddedDataObject embeddedDataObj;
        List<EmbeddedDataObject> embeddedDataObjs = importedModel.getPackageMeta().getEmbeddedDataObjs();
        if (embeddedDataObjs != null && !embeddedDataObjs.isEmpty() && (embeddedDataObj = embeddedDataObjs.get(0)) != null) {
            return embeddedDataObj.getSchemaObjs();
        }
        return null;
    }

    @Override
    public EntranceInfoVO getEntranceInfo(String tag, ImportedModel importedModel) {
        EntranceInfoVO entranceInfoVO = new EntranceInfoVO();
        entranceInfoVO.setEntranceType(EntranceInfoVO.EntranceTypeEnum.embedded.name());
        return entranceInfoVO;
    }

    @Override
    public AbstractDataSourceInfoVO getDataSourceInfo(String tag, ImportedModel importedModel) throws ImportException {
        EmbeddedDataObject embeddedDataObj;
        List<EmbeddedDataObject> embeddedDataObjs = importedModel.getPackageMeta().getEmbeddedDataObjs();
        if (embeddedDataObjs != null && !embeddedDataObjs.isEmpty() && (embeddedDataObj = embeddedDataObjs.get(0)) != null) {
            return this.getDataSourceInfoByEmbeddedDataObject(embeddedDataObj, importedModel);
        }
        throw new ImportNoInfoFoundException();
    }

    @Override
    public List<TraceSpanVO> getTraceSpanInfo(String tag, ImportedModel importedModel) throws ImportException {
        EmbeddedDataObject embeddedDataObj;
        List<EmbeddedDataObject> embeddedDataObjs = importedModel.getPackageMeta().getEmbeddedDataObjs();
        if (embeddedDataObjs != null && !embeddedDataObjs.isEmpty() && (embeddedDataObj = embeddedDataObjs.get(0)) != null) {
            return this.getTraceSpanInfo(embeddedDataObj.getEmbeddedDataQsInfo(), embeddedDataObj.getSchemaObjs(), importedModel);
        }
        return null;
    }
}

