/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.importer.qhf.domain.modelparser.scene.impl;

import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.imexport.importer.exception.ImportException;
import com.kingdee.bos.qing.imexport.importer.exception.ImportNoInfoFoundException;
import com.kingdee.bos.qing.imexport.importer.qhf.domain.modelparser.publish.IPublishModelParser;
import com.kingdee.bos.qing.imexport.importer.qhf.domain.modelparser.publish.PublishModelParserFactory;
import com.kingdee.bos.qing.imexport.importer.qhf.domain.modelparser.scene.IDsbRefModelParser;
import com.kingdee.bos.qing.imexport.importer.qhf.domain.modelparser.scene.IModelParser;
import com.kingdee.bos.qing.imexport.importer.qhf.model.EntranceInfoVO;
import com.kingdee.bos.qing.imexport.importer.qhf.model.PublishEntranceInfoVO;
import com.kingdee.bos.qing.imexport.importer.qhf.model.TraceSpanVO;
import com.kingdee.bos.qing.imexport.importer.qhf.model.datasourceinfovo.AbstractDataSourceInfoVO;
import com.kingdee.bos.qing.imexport.model.ImportedModel;
import com.kingdee.bos.qing.imexport.model.QHFSceneTypeEnum;
import com.kingdee.bos.qing.imexport.model.SchemaObject;
import com.kingdee.bos.qing.imexport.model.publish.AbstractPublishObject;
import com.kingdee.bos.qing.imexport.model.publish.LongerSquarePublishObject;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.model.PublishTarget;
import com.kingdee.bos.qing.publish.target.analysiscenter.model.QingCenterPathModel;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.util.List;

public class PublishModelParser
implements IModelParser,
IDsbRefModelParser {
    @Override
    public void cacheDataSource(String tag, ImportedModel importedModel) throws ImportException {
        String sceneType = importedModel.getPackageMeta().getEnvironment().getSceneType();
        IPublishModelParser publishModelParser = PublishModelParserFactory.getParserBySceneType(sceneType);
        publishModelParser.cacheDataSource(tag, importedModel);
    }

    @Override
    public List<SchemaObject> getSchemaObjs(ImportedModel importedModel) throws ImportNoInfoFoundException {
        AbstractPublishObject publishObj;
        List<AbstractPublishObject> publishObjs = importedModel.getPackageMeta().getPublishObjs();
        if (publishObjs != null && !publishObjs.isEmpty() && (publishObj = publishObjs.get(0)) != null) {
            LongerSquarePublishObject longerSquarePublishObj = (LongerSquarePublishObject)publishObj;
            return longerSquarePublishObj.getSchemaObjs();
        }
        return null;
    }

    @Override
    public EntranceInfoVO getEntranceInfo(String tag, ImportedModel importedModel) throws ImportNoInfoFoundException {
        AbstractPublishObject publishObj;
        PublishEntranceInfoVO entranceInfoVO = new PublishEntranceInfoVO();
        entranceInfoVO.setEntranceType(EntranceInfoVO.EntranceTypeEnum.publish.name());
        List<AbstractPublishObject> publishObjs = importedModel.getPackageMeta().getPublishObjs();
        if (publishObjs != null && !publishObjs.isEmpty() && (publishObj = publishObjs.get(0)) != null) {
            PublishPO publishPO = publishObj.getPublishPO();
            PublishTarget publishTarget = publishObj.getPublishTarget();
            PublishEntranceInfoVO.PublishInfoVO publishInfoVO = new PublishEntranceInfoVO.PublishInfoVO();
            publishInfoVO.setCreatorName(publishObj.getCreatorName());
            publishInfoVO.setCarryData(publishPO.isCarryData());
            publishInfoVO.setCreatorId(publishPO.getCreatorId());
            publishInfoVO.setName(publishPO.getName());
            publishInfoVO.setPath(publishTarget.getPath());
            publishInfoVO.setPathName(this.getPublishPathName(publishTarget));
            publishInfoVO.setPreset(publishPO.isPreset());
            publishInfoVO.setPublishSourceType(publishPO.getPublishSourceType().name());
            publishInfoVO.setPublishTargetType(publishTarget.getTargetType());
            entranceInfoVO.setPublishInfoVO(publishInfoVO);
            return entranceInfoVO;
        }
        return entranceInfoVO;
    }

    @Override
    public AbstractDataSourceInfoVO getDataSourceInfo(String tag, ImportedModel importedModel) throws ImportException {
        List<AbstractPublishObject> publishObjs = importedModel.getPackageMeta().getPublishObjs();
        if (publishObjs != null && !publishObjs.isEmpty()) {
            AbstractPublishObject publishObj = null;
            if (importedModel.getPackageMeta().getEnvironment().getSceneType().equals(QHFSceneTypeEnum.publishDsb.toPersistance())) {
                for (AbstractPublishObject abstractPublishObject : publishObjs) {
                    if (abstractPublishObject.getPublishPO().getPublishSourceType() != PublishSourceEnum.dashboard) continue;
                    publishObj = abstractPublishObject;
                    break;
                }
            } else {
                publishObj = publishObjs.get(0);
            }
            if (publishObj != null) {
                PublishPO publishPO = publishObj.getPublishPO();
                IPublishModelParser publishModelParser = PublishModelParserFactory.getParserByPublishSourceType(publishPO.getPublishSourceType());
                return publishModelParser.getDataSourceInfo(tag, publishPO, importedModel);
            }
        }
        throw new ImportNoInfoFoundException();
    }

    @Override
    public void cacheDataSourceById(String tag, String publishId, ImportedModel importedModel) throws ImportException {
        List<AbstractPublishObject> publishObjs = importedModel.getPackageMeta().getPublishObjs();
        if (publishObjs != null && !publishObjs.isEmpty()) {
            for (AbstractPublishObject publishObject : publishObjs) {
                PublishPO publishPO = publishObject.getPublishPO();
                if (!publishId.equals(publishPO.getId())) continue;
                IPublishModelParser publishModelParser = PublishModelParserFactory.getParserByPublishSourceType(publishPO.getPublishSourceType());
                publishModelParser.cacheDataSourceByPublishPO(tag, publishPO, importedModel);
                break;
            }
        }
    }

    @Override
    public AbstractDataSourceInfoVO getQHFDataSourceInfo(String tag, ReferenceMap referenceMap, ImportedModel importedModel) throws ImportException {
        List<AbstractPublishObject> publishObjs = importedModel.getPackageMeta().getPublishObjs();
        if (publishObjs != null && !publishObjs.isEmpty()) {
            for (AbstractPublishObject publishObject : publishObjs) {
                PublishPO publishPO = publishObject.getPublishPO();
                if (!referenceMap.getRefToId().equals(publishPO.getId())) continue;
                PublishSourceEnum publishSourceEnum = publishPO.getPublishSourceType();
                IPublishModelParser publishModelParser = PublishModelParserFactory.getParserByPublishSourceType(publishSourceEnum);
                return publishModelParser.getDataSourceInfo(tag, publishPO, importedModel);
            }
        }
        throw new ImportNoInfoFoundException();
    }

    @Override
    public List<TraceSpanVO> getTraceSpanInfo(String tag, ImportedModel importedModel) throws ImportException {
        AbstractPublishObject publishObj;
        List<AbstractPublishObject> publishObjs = importedModel.getPackageMeta().getPublishObjs();
        if (publishObjs != null && !publishObjs.isEmpty() && (publishObj = publishObjs.get(0)) != null) {
            PublishPO publishPO = publishObj.getPublishPO();
            IPublishModelParser publishModelParser = PublishModelParserFactory.getParserByPublishSourceType(publishPO.getPublishSourceType());
            return publishModelParser.getTraceSpanInfo(tag, publishPO, importedModel);
        }
        return null;
    }

    private String getPublishPathName(PublishTarget publishTarget) {
        if (publishTarget.getTargetType() == 1) {
            QingCenterPathModel qingCenterPathModel = (QingCenterPathModel)JsonUtil.decodeFromString((String)publishTarget.getPath(), QingCenterPathModel.class);
            String centerName1 = qingCenterPathModel.getCenterName1();
            String centerName2 = qingCenterPathModel.getCenterName2();
            String centerName3 = qingCenterPathModel.getCenterName3();
            String centerName4 = qingCenterPathModel.getCenterName4();
            String publishPathName = centerName1;
            if (StringUtils.isNotEmpty((CharSequence)centerName2)) {
                publishPathName = publishPathName + '/' + centerName2;
            }
            if (StringUtils.isNotEmpty((CharSequence)centerName3)) {
                publishPathName = publishPathName + '/' + centerName3;
            }
            if (StringUtils.isNotEmpty((CharSequence)centerName4)) {
                publishPathName = publishPathName + '/' + centerName4;
            }
            return publishPathName;
        }
        if (publishTarget.getTargetType() == 0) {
            return publishTarget.getPathName();
        }
        if (publishTarget.getTargetType() == 5) {
            return publishTarget.getPath();
        }
        return publishTarget.getPath();
    }
}

