/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.importer.qhf.domain.modelparser.scene.impl;

import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.imexport.importer.exception.ImportEncryptedLicenseCheckException;
import com.kingdee.bos.qing.imexport.importer.exception.ImportException;
import com.kingdee.bos.qing.imexport.importer.qhf.domain.modelparser.common.AbstractSubjectModelParser;
import com.kingdee.bos.qing.imexport.importer.qhf.domain.modelparser.scene.IDsbRefModelParser;
import com.kingdee.bos.qing.imexport.importer.qhf.domain.modelparser.scene.IModelParser;
import com.kingdee.bos.qing.imexport.importer.qhf.model.EntranceInfoVO;
import com.kingdee.bos.qing.imexport.importer.qhf.model.TraceSpanVO;
import com.kingdee.bos.qing.imexport.importer.qhf.model.datasourceinfovo.AbstractDataSourceInfoVO;
import com.kingdee.bos.qing.imexport.importer.qhf.model.datasourceinfovo.SubjectDataSourceInfoVO;
import com.kingdee.bos.qing.imexport.model.ImportedModel;
import com.kingdee.bos.qing.imexport.model.SchemaObject;
import com.kingdee.bos.qing.imexport.model.subject.AnalysisObject;
import com.kingdee.bos.qing.imexport.model.subject.SubjectObject;
import com.kingdee.bos.qing.manage.exception.EncryptedLicenseCheckException;
import java.io.IOException;
import java.util.List;
import org.jdom2.JDOMException;

public class SubjectModelParser
extends AbstractSubjectModelParser
implements IModelParser,
IDsbRefModelParser {
    @Override
    public void cacheDataSource(String tag, ImportedModel importedModel) throws ImportException {
        try {
            SubjectObject subjectObject;
            List<SubjectObject> subjectObjects = importedModel.getPackageMeta().getSubjectObjs();
            if (subjectObjects != null && !subjectObjects.isEmpty() && (subjectObject = subjectObjects.get(0)) != null) {
                this.cacheDataSource(subjectObject.getAnalysisObj().getSubjectQsInfo(), subjectObject.getDataModelingObj(), tag, importedModel);
            }
        }
        catch (EncryptedLicenseCheckException e) {
            throw new ImportEncryptedLicenseCheckException(e.getMessage(), e.getErrorCode());
        }
        catch (IOException e) {
            throw new ImportException(e);
        }
        catch (JDOMException e) {
            throw new ImportException(e);
        }
        catch (ModelParseException e) {
            throw new ImportException(e);
        }
    }

    @Override
    public List<SchemaObject> getSchemaObjs(ImportedModel importedModel) {
        AnalysisObject analysisObj;
        SubjectObject subjectObj;
        List<SubjectObject> subjectObjs = importedModel.getPackageMeta().getSubjectObjs();
        if (subjectObjs != null && !subjectObjs.isEmpty() && (subjectObj = subjectObjs.get(0)) != null && (analysisObj = subjectObj.getAnalysisObj()) != null) {
            return analysisObj.getSchemaObjs();
        }
        return null;
    }

    @Override
    public EntranceInfoVO getEntranceInfo(String tag, ImportedModel importedModel) {
        EntranceInfoVO entranceInfoVO = new EntranceInfoVO();
        entranceInfoVO.setEntranceType(EntranceInfoVO.EntranceTypeEnum.subject.name());
        return entranceInfoVO;
    }

    @Override
    public AbstractDataSourceInfoVO getDataSourceInfo(String tag, ImportedModel importedModel) throws ImportException {
        SubjectObject subjectObj;
        List<SubjectObject> subjectObjs = importedModel.getPackageMeta().getSubjectObjs();
        if (subjectObjs != null && !subjectObjs.isEmpty() && (subjectObj = subjectObjs.get(0)) != null) {
            return this.getDataSourceInfoBySubjectObject(subjectObj, importedModel);
        }
        throw new RuntimeException("no info was found");
    }

    @Override
    public void cacheDataSourceById(String tag, String subjectId, ImportedModel importedModel) throws ImportException {
        block3: {
            try {
                List<SubjectObject> subjectObjs = importedModel.getPackageMeta().getSubjectObjs();
                if (subjectObjs == null || subjectObjs.isEmpty()) break block3;
                for (SubjectObject subjectObject : subjectObjs) {
                    if (!subjectId.equals(subjectObject.getThemeVO().getThemeID())) continue;
                    this.cacheDataSource(subjectObject.getAnalysisObj().getSubjectQsInfo(), subjectObject.getDataModelingObj(), tag, importedModel);
                    break;
                }
            }
            catch (Exception e) {
                throw new ImportException(e);
            }
        }
    }

    @Override
    public SubjectDataSourceInfoVO getQHFDataSourceInfo(String tag, ReferenceMap referenceMap, ImportedModel importedModel) throws ImportException {
        List<SubjectObject> subjectObjs = importedModel.getPackageMeta().getSubjectObjs();
        if (subjectObjs != null && !subjectObjs.isEmpty()) {
            for (SubjectObject subjectObject : subjectObjs) {
                if (!referenceMap.getRefToId().equals(subjectObject.getThemeVO().getThemeID())) continue;
                return this.getDataSourceInfoBySubjectObject(subjectObject, importedModel);
            }
        }
        return null;
    }

    @Override
    public List<TraceSpanVO> getTraceSpanInfo(String tag, ImportedModel importedModel) throws ImportException {
        SubjectObject subjectObj;
        List<SubjectObject> subjectObjs = importedModel.getPackageMeta().getSubjectObjs();
        if (subjectObjs != null && !subjectObjs.isEmpty() && (subjectObj = subjectObjs.get(0)) != null) {
            return this.getTraceSpanInfo(subjectObj.getAnalysisObj().getSubjectQsInfo(), subjectObj.getAnalysisObj().getSchemaObjs(), importedModel);
        }
        throw new RuntimeException("no info was found");
    }
}

