/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.model;

import com.kingdee.bos.qing.imexport.model.integration.IntegratedType;
import com.kingdee.bos.qing.imexport.model.integration.IntegratedXmlHelper;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipOutputStream;
import org.jdom2.Content;
import org.jdom2.Element;

public class Integration {
    private static final String ELEMENT_NAME = "Integrations";
    private Map<IntegratedType, AbstractIntegratedSubNode> integrations;

    public void addSubNode(IntegratedType type, AbstractIntegratedSubNode subNode) {
        if (this.integrations == null) {
            this.integrations = new HashMap<IntegratedType, AbstractIntegratedSubNode>();
        }
        this.integrations.put(type, subNode);
    }

    public AbstractIntegratedSubNode getSubNodes(IntegratedType type) {
        if (this.integrations == null) {
            return null;
        }
        return this.integrations.get((Object)type);
    }

    public boolean hasContent() {
        if (this.integrations == null) {
            return false;
        }
        return !this.integrations.isEmpty();
    }

    public Element toXml() {
        if (this.hasContent()) {
            Element xml = new Element(ELEMENT_NAME);
            boolean stillEmpty = true;
            Collection<AbstractIntegratedSubNode> subNodes = this.integrations.values();
            for (AbstractIntegratedSubNode subNode : subNodes) {
                Element integratedNode = subNode.toXml();
                if (integratedNode == null) continue;
                stillEmpty = false;
                xml.addContent((Content)integratedNode);
            }
            if (stillEmpty) {
                return null;
            }
            return xml;
        }
        return null;
    }

    public void fromXml(Element metaElement, String type, String version) {
        Element integrationElement = metaElement.getChild(ELEMENT_NAME);
        if (integrationElement == null) {
            return;
        }
        this.integrations = IntegratedXmlHelper.getIntegrationFromXml(integrationElement, type, version);
    }

    public void exportFile(ZipOutputStream zos) throws IOException {
        if (!this.hasContent()) {
            return;
        }
        Collection<AbstractIntegratedSubNode> subNodes = this.integrations.values();
        for (AbstractIntegratedSubNode subNode : subNodes) {
            subNode.exportFile(zos);
        }
    }

    public static abstract class AbstractIntegratedSubNode {
        public abstract Element toXml();

        public abstract void exportFile(ZipOutputStream var1) throws IOException;
    }
}

