/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.model;

import com.kingdee.bos.qing.common.trace.TraceSpan;
import com.kingdee.bos.qing.imexport.model.SchemaNamespaceEnum;
import com.kingdee.bos.qing.imexport.util.ImExportUtil;
import com.kingdee.bos.qing.schema.model.SchemaBO;
import com.kingdee.bos.qing.schema.model.SchemaTypeEnum;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jdom2.Element;

public class SchemaInfo {
    private SchemaBO schemaBO;
    private String schemaContentFile;
    protected List<TraceSpan> joinTraceSpans;
    private String joinTraceFile;
    protected List<TraceSpan> executeTraceSpans;
    private String executeTraceFile;

    public String getSchemaContentFile() {
        return this.schemaContentFile;
    }

    public void setSchemaContentFile(String schemaContentFile) {
        this.schemaContentFile = schemaContentFile;
    }

    public SchemaBO getSchemaBO() {
        return this.schemaBO;
    }

    public void setSchemaBO(SchemaBO schemaBO) {
        this.schemaBO = schemaBO;
    }

    public List<TraceSpan> getJoinTraceSpans() {
        return this.joinTraceSpans;
    }

    public void setJoinTraceSpans(List<TraceSpan> joinTraceSpans) {
        this.joinTraceSpans = joinTraceSpans;
    }

    public List<TraceSpan> getExecuteTraceSpans() {
        return this.executeTraceSpans;
    }

    public void setExecuteTraceSpans(List<TraceSpan> executeTraceSpans) {
        this.executeTraceSpans = executeTraceSpans;
    }

    public String getJoinTraceFile() {
        return this.joinTraceFile;
    }

    public void setJoinTraceFile(String joinTraceFile) {
        this.joinTraceFile = joinTraceFile;
    }

    public String getExecuteTraceFile() {
        return this.executeTraceFile;
    }

    public void setExecuteTraceFile(String executeTraceFile) {
        this.executeTraceFile = executeTraceFile;
    }

    public Element toXml() {
        Element schemaElement = new Element("Schema");
        schemaElement.setAttribute("id", this.schemaBO.getfId());
        schemaElement.setAttribute("type", SchemaTypeEnum.getSchemaTypeEnum(this.schemaBO.getSource()).name());
        schemaElement.setAttribute("default", String.valueOf(this.schemaBO.IsDefault()));
        schemaElement.setAttribute("name", this.schemaBO.getSchemaName());
        schemaElement.setAttribute("seq", String.valueOf(this.schemaBO.getSeq()));
        schemaElement.setAttribute("nameSpace", SchemaNamespaceEnum.getSchemaNamespaceEnum(this.schemaBO.getSchemaType()).name());
        if (this.joinTraceSpans != null && !this.joinTraceSpans.isEmpty()) {
            this.joinTraceFile = UUID.randomUUID().toString() + ".trace";
            schemaElement.setAttribute("joinTraceFile", this.joinTraceFile);
        }
        if (this.executeTraceSpans != null && !this.executeTraceSpans.isEmpty()) {
            this.executeTraceFile = UUID.randomUUID().toString() + ".trace";
            schemaElement.setAttribute("executeTraceFile", this.executeTraceFile);
        }
        return schemaElement;
    }

    public void exportFile(ZipOutputStream zos) throws IOException {
        String traceFilePath;
        String schemaContentFilePath = "schema" + File.separator + this.schemaBO.getfId() + ".schema";
        ImExportUtil.exportFile(zos, this.schemaContentFile, schemaContentFilePath);
        if (this.joinTraceSpans != null && !this.joinTraceSpans.isEmpty()) {
            traceFilePath = "trace" + File.separator + this.joinTraceFile;
            zos.putNextEntry(new ZipEntry(traceFilePath));
            XmlUtil.save((Element)ImExportUtil.traceSpansToXml(this.joinTraceSpans), (OutputStream)zos);
            zos.flush();
        }
        if (this.executeTraceSpans != null && !this.executeTraceSpans.isEmpty()) {
            traceFilePath = "trace" + File.separator + this.executeTraceFile;
            zos.putNextEntry(new ZipEntry(traceFilePath));
            XmlUtil.save((Element)ImExportUtil.traceSpansToXml(this.executeTraceSpans), (OutputStream)zos);
            zos.flush();
        }
    }

    public void fromXml(Element schemaElement, String type, String version) {
        this.schemaBO = new SchemaBO();
        String id = schemaElement.getAttributeValue("id");
        this.schemaBO.setfId(id);
        this.schemaBO.setSource(SchemaTypeEnum.valueOf(schemaElement.getAttributeValue("type")).getType());
        this.schemaBO.setIsDefault("true".equals(schemaElement.getAttributeValue("default")));
        this.schemaBO.setSchemaName(schemaElement.getAttributeValue("name"));
        this.schemaBO.setSeq(Integer.parseInt(schemaElement.getAttributeValue("seq")));
        this.schemaBO.setSchemaType(SchemaNamespaceEnum.valueOf(schemaElement.getAttributeValue("nameSpace")).getType());
        this.schemaContentFile = id + ".schema";
        this.joinTraceFile = schemaElement.getAttributeValue("joinTraceFile");
        this.executeTraceFile = schemaElement.getAttributeValue("executeTraceFile");
    }

    public void endCleanFiles() {
        ImExportUtil.deleteExportFile(this.schemaContentFile);
    }
}

