/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.model;

import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.imexport.model.SchemaInfo;
import com.kingdee.bos.qing.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipOutputStream;
import org.jdom2.Content;
import org.jdom2.Element;

public class SchemaObject {
    private SchemaInfo schemaInfo;
    private List<OutsideReference> outSideRefs;

    public SchemaInfo getSchemaInfo() {
        return this.schemaInfo;
    }

    public void setSchemaInfo(SchemaInfo schemaInfo) {
        this.schemaInfo = schemaInfo;
    }

    public List<OutsideReference> getOutSideRefs() {
        return this.outSideRefs;
    }

    public void setOutSideRefs(List<OutsideReference> outSideRefs) {
        this.outSideRefs = outSideRefs;
    }

    public Element toXml() {
        Element schemaElement = this.schemaInfo.toXml();
        if (this.outSideRefs != null && !this.outSideRefs.isEmpty()) {
            Element refsElement = new Element("Refs");
            for (OutsideReference outsideReference : this.outSideRefs) {
                Element refElement = new Element("Ref");
                if (StringUtils.isNotBlank((CharSequence)outsideReference.getRefToId())) {
                    refElement.setAttribute("refToId", outsideReference.getRefToId());
                }
                if (StringUtils.isNotBlank((CharSequence)outsideReference.getRefToFullPath())) {
                    refElement.setAttribute("fullPath", outsideReference.getRefToFullPath());
                }
                refElement.setAttribute("uid", outsideReference.getUid());
                refElement.setAttribute("refType", outsideReference.getRefType());
                refsElement.addContent((Content)refElement);
            }
            schemaElement.addContent((Content)refsElement);
        }
        return schemaElement;
    }

    public void exportFile(ZipOutputStream zos) throws IOException {
        this.schemaInfo.exportFile(zos);
    }

    public void fromXml(Element schemaObjElement, String type, String version) {
        List refElements;
        this.schemaInfo = new SchemaInfo();
        this.schemaInfo.fromXml(schemaObjElement, type, version);
        Element refsElement = schemaObjElement.getChild("Refs");
        if (refsElement != null && (refElements = refsElement.getChildren("Ref")) != null) {
            this.outSideRefs = new ArrayList<OutsideReference>(10);
            for (Element refElement : refElements) {
                OutsideReference outsideReference = new OutsideReference();
                outsideReference.setRefToFullPath(refElement.getAttributeValue("fullPath"));
                outsideReference.setRefToId(refElement.getAttributeValue("refToId"));
                outsideReference.setUid(refElement.getAttributeValue("uid"));
                outsideReference.setRefType(refElement.getAttributeValue("refType"));
                this.outSideRefs.add(outsideReference);
            }
        }
    }

    public void endCleanFiles() {
        if (this.schemaInfo != null) {
            this.schemaInfo.endCleanFiles();
        }
    }
}

