/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.model.dashboard;

import com.kingdee.bos.qing.common.namespace.NameSpace;
import com.kingdee.bos.qing.imexport.model.dashboard.DsbRefObject;
import com.kingdee.bos.qing.imexport.util.ImExportUtil;
import com.kingdee.bos.qing.manage.model.ThemeGroupVO;
import com.kingdee.bos.qing.manage.model.ThemeVO;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipOutputStream;
import org.jdom2.Content;
import org.jdom2.Element;

public class DashboardObject {
    private ThemeGroupVO themeGroupVO;
    private ThemeVO themeVO;
    private String dsbModelFileName;
    private List<DsbRefObject> dsbRefObjs;

    public ThemeGroupVO getThemeGroupVO() {
        return this.themeGroupVO;
    }

    public void setThemeGroupVO(ThemeGroupVO themeGroupVO) {
        this.themeGroupVO = themeGroupVO;
    }

    public ThemeVO getThemeVO() {
        return this.themeVO;
    }

    public void setThemeVO(ThemeVO themeVO) {
        this.themeVO = themeVO;
    }

    public String getDsbModelFileName() {
        return this.dsbModelFileName;
    }

    public void setDsbModelFileName(String dsbModelFileName) {
        this.dsbModelFileName = dsbModelFileName;
    }

    public List<DsbRefObject> getDsbRefObjs() {
        return this.dsbRefObjs;
    }

    public void setDsbRefObjs(List<DsbRefObject> dsbRefObjs) {
        this.dsbRefObjs = dsbRefObjs;
    }

    public Element toXml() {
        Element dashboardElement = new Element("Dashboard");
        dashboardElement.setAttribute("id", this.themeVO.getThemeID());
        dashboardElement.setAttribute("name", this.themeVO.getThemeName());
        String nameSpace = this.themeVO.isPreset() ? NameSpace.system.toPersistance() : NameSpace.user.toPersistance();
        dashboardElement.setAttribute("nameSpace", nameSpace);
        dashboardElement.setAttribute("category", this.themeGroupVO.getThemeGroupName());
        if (StringUtils.isNotBlank((CharSequence)this.themeVO.getDescription())) {
            Element descElement = new Element("Desc");
            XmlUtil.addCDATA((Element)descElement, (String)this.themeVO.getDescription());
            dashboardElement.addContent((Content)descElement);
        }
        if (StringUtils.isNotBlank((CharSequence)this.dsbModelFileName)) {
            Element modelElement = new Element("Model");
            modelElement.setAttribute("file", this.getDashboardModelFileName());
            dashboardElement.addContent((Content)modelElement);
        }
        if (this.dsbRefObjs != null && !this.dsbRefObjs.isEmpty()) {
            Element refsElement = new Element("Refs");
            for (DsbRefObject dsbRefObj : this.dsbRefObjs) {
                refsElement.addContent((Content)dsbRefObj.toXml());
            }
            dashboardElement.addContent((Content)refsElement);
        }
        return dashboardElement;
    }

    private String getDashboardModelFileName() {
        return this.themeVO.getThemeID() + ".dsb";
    }

    public void exportFile(ZipOutputStream zos) throws IOException {
        this.exportDashboardModelFile(zos);
        this.exportDsbRefObjsFile(zos);
    }

    private void exportDashboardModelFile(ZipOutputStream zos) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)this.dsbModelFileName)) {
            String dsbModelFilePath = "model" + File.separator + this.getDashboardModelFileName();
            ImExportUtil.exportFile(zos, this.dsbModelFileName, dsbModelFilePath);
        }
    }

    private void exportDsbRefObjsFile(ZipOutputStream zos) throws IOException {
        if (this.dsbRefObjs != null) {
            for (DsbRefObject dsbRefObj : this.dsbRefObjs) {
                dsbRefObj.exportFile(zos);
            }
        }
    }

    public void fromXml(Element dashboardObjElement, String type, String version) {
        Element refsElement;
        Element modelElement;
        this.themeGroupVO = new ThemeGroupVO();
        this.themeGroupVO.setThemeGroupName(dashboardObjElement.getAttributeValue("category"));
        this.themeVO = new ThemeVO();
        this.themeVO.setThemeID(dashboardObjElement.getAttributeValue("id"));
        this.themeVO.setThemeName(dashboardObjElement.getAttributeValue("name"));
        this.themeVO.setPreset(NameSpace.system.name().equals(dashboardObjElement.getAttributeValue("nameSpace")));
        Element descElement = dashboardObjElement.getChild("Desc");
        if (descElement != null) {
            this.themeVO.setDescription(descElement.getTextTrim());
        }
        if ((modelElement = dashboardObjElement.getChild("Model")) != null) {
            this.dsbModelFileName = modelElement.getAttributeValue("file");
        }
        if ((refsElement = dashboardObjElement.getChild("Refs")) != null) {
            this.dsbRefObjs = new ArrayList<DsbRefObject>(10);
            List refElements = refsElement.getChildren("Ref");
            for (Element refElement : refElements) {
                DsbRefObject dsbRefObj = new DsbRefObject();
                dsbRefObj.fromXml(refElement, type, version);
                this.dsbRefObjs.add(dsbRefObj);
            }
        }
    }

    public void endCleanFiles() {
        ImExportUtil.deleteExportFile(this.dsbModelFileName);
        if (this.dsbRefObjs != null) {
            for (DsbRefObject dsbRefObj : this.dsbRefObjs) {
                dsbRefObj.endCleanFiles();
            }
        }
    }
}

