/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.model.publish;

import com.kingdee.bos.qing.common.exception.IntegratedRuntimeException;
import com.kingdee.bos.qing.imexport.model.PermissionTypeEnum;
import com.kingdee.bos.qing.publish.model.PermissionInfo;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.StringUtils;
import org.jdom2.Element;

public class PermissionObject {
    private PermissionInfo permissionInfo;
    private String viewerName;

    public PermissionInfo getPermissionInfo() {
        return this.permissionInfo;
    }

    public void setPermissionInfo(PermissionInfo permissionInfo) {
        this.permissionInfo = permissionInfo;
    }

    public String getViewerName() {
        return this.viewerName;
    }

    public void setViewerName(String viewerName) {
        this.viewerName = viewerName;
    }

    public Element toXml() throws IntegratedRuntimeException {
        Element authorizedIdElement = new Element("AuthorizedId");
        PermissionTypeEnum permissionTypeEnum = PermissionTypeEnum.getSchemaTypeEnum(this.permissionInfo.getType());
        String permissionName = this.getPermissionName(this.permissionInfo.getViewerId(), permissionTypeEnum);
        authorizedIdElement.setAttribute("type", permissionTypeEnum.name());
        authorizedIdElement.setAttribute("value", this.permissionInfo.getViewerId());
        authorizedIdElement.setAttribute("name", StringUtils.isNotEmpty((CharSequence)permissionName) ? permissionName : "");
        return authorizedIdElement;
    }

    private String getPermissionName(String viewerId, PermissionTypeEnum permissionTypeEnum) throws IntegratedRuntimeException {
        if (permissionTypeEnum == PermissionTypeEnum.role) {
            return IntegratedHelper.getRoleName(null, null, (String)viewerId);
        }
        if (permissionTypeEnum == PermissionTypeEnum.user) {
            return IntegratedHelper.getUserName(null, null, (String)viewerId);
        }
        return "";
    }

    public void fromXml(Element authorizedIdElement, String type, String version) {
        this.permissionInfo = new PermissionInfo();
        this.permissionInfo.setType(PermissionTypeEnum.valueOf(authorizedIdElement.getAttributeValue("type")).getType());
        this.permissionInfo.setViewerId(authorizedIdElement.getAttributeValue("value"));
        this.viewerName = authorizedIdElement.getAttributeValue("name");
    }
}

