/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.model.publish.dashboard;

import com.kingdee.bos.qing.common.exception.IntegratedRuntimeException;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.imexport.model.dashboard.DsbRefObject;
import com.kingdee.bos.qing.imexport.model.publish.AbstractPublishObject;
import com.kingdee.bos.qing.imexport.util.ImExportUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipOutputStream;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class DsbPublishObject
extends AbstractPublishObject {
    private List<DsbRefObject> dsbRefObjs;
    private String dsbModelFileName;

    public String getDsbModelFileName() {
        return this.dsbModelFileName;
    }

    public void setDsbModelFileName(String dsbModelFileName) {
        this.dsbModelFileName = dsbModelFileName;
    }

    public List<DsbRefObject> getDsbRefObjs() {
        return this.dsbRefObjs;
    }

    public void setDsbRefObjs(List<DsbRefObject> dsbRefObjs) {
        this.dsbRefObjs = dsbRefObjs;
    }

    @Override
    public Element toXml() throws IntegratedRuntimeException {
        Element publishElement = super.toXml();
        Element modelElement = new Element("Model");
        modelElement.setAttribute("file", this.getPublishDsbModelFileName());
        publishElement.addContent((Content)modelElement);
        if (this.dsbRefObjs != null && !this.dsbRefObjs.isEmpty()) {
            Element refsElement = new Element("Refs");
            for (DsbRefObject dsbRefObj : this.dsbRefObjs) {
                refsElement.addContent((Content)dsbRefObj.toXml());
            }
            publishElement.addContent((Content)refsElement);
        }
        return publishElement;
    }

    @Override
    public void fromXml(Element dashboardPublishObjElement, String type, String version) throws ModelParseException, JDOMException, IOException {
        List refElements;
        super.fromXml(dashboardPublishObjElement, type, version);
        Element modelElement = dashboardPublishObjElement.getChild("Model");
        if (modelElement != null) {
            this.dsbModelFileName = modelElement.getAttributeValue("file");
        }
        Element refsElement = dashboardPublishObjElement.getChild("Refs");
        this.dsbRefObjs = new ArrayList<DsbRefObject>(10);
        if (refsElement != null && (refElements = refsElement.getChildren("Ref")) != null) {
            for (Element refElement : refElements) {
                DsbRefObject dsbRefObj = new DsbRefObject();
                dsbRefObj.fromXml(refElement, type, version);
                this.dsbRefObjs.add(dsbRefObj);
            }
        }
    }

    private void exportDashboardModelFile(ZipOutputStream zos) throws IOException {
        String dsbModelFilePath = "model" + File.separator + this.getPublishDsbModelFileName();
        ImExportUtil.exportFile(zos, this.dsbModelFileName, dsbModelFilePath);
    }

    private void exportDsbRefObjsFile(ZipOutputStream zos) throws IOException {
        if (this.dsbRefObjs != null) {
            for (DsbRefObject dsbRefObj : this.dsbRefObjs) {
                dsbRefObj.exportFile(zos);
            }
        }
    }

    private String getPublishDsbModelFileName() {
        return this.publishPO.getId() + ".dsb";
    }

    @Override
    public void exportPublishFile(ZipOutputStream zos) throws IOException {
        this.exportDashboardModelFile(zos);
        this.exportDsbRefObjsFile(zos);
    }

    @Override
    public void endCleanPublishFiles() {
        ImExportUtil.deleteExportFile(this.dsbModelFileName);
        if (this.dsbRefObjs != null) {
            for (DsbRefObject dsbRefObj : this.dsbRefObjs) {
                dsbRefObj.endCleanFiles();
            }
        }
    }
}

