/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.model.publish.subject;

import com.kingdee.bos.qing.common.namespace.NameSpace;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.imexport.model.publish.AbstractCarryDataInfo;
import com.kingdee.bos.qing.imexport.model.subject.DataModelingObject;
import com.kingdee.bos.qing.imexport.model.subject.SubjectQsInfo;
import com.kingdee.bos.qing.manage.model.ThemeGroupVO;
import com.kingdee.bos.qing.manage.model.ThemeVO;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.IOException;
import java.util.zip.ZipOutputStream;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class SubjectCarryDataInfo
extends AbstractCarryDataInfo {
    private ThemeGroupVO themeGroupVO;
    private ThemeVO themeVO;
    private DataModelingObject dataModelingObj;
    private SubjectQsInfo subjectQsInfo;

    public ThemeGroupVO getThemeGroupVO() {
        return this.themeGroupVO;
    }

    public void setThemeGroupVO(ThemeGroupVO themeGroupVO) {
        this.themeGroupVO = themeGroupVO;
    }

    public ThemeVO getThemeVO() {
        return this.themeVO;
    }

    public void setThemeVO(ThemeVO themeVO) {
        this.themeVO = themeVO;
    }

    public DataModelingObject getDataModelingObj() {
        return this.dataModelingObj;
    }

    public void setDataModelingObj(DataModelingObject dataModelingObj) {
        this.dataModelingObj = dataModelingObj;
    }

    public SubjectQsInfo getSubjectQsInfo() {
        return this.subjectQsInfo;
    }

    public void setSubjectQsInfo(SubjectQsInfo subjectQsInfo) {
        this.subjectQsInfo = subjectQsInfo;
    }

    @Override
    public Element toXml(PublishPO publishPO) {
        Element carryDataInfoElement = new Element("CarryDataInfo");
        Element subjectElement = new Element("Subject");
        if (this.themeVO != null) {
            subjectElement.setAttribute("id", this.themeVO.getThemeID());
            subjectElement.setAttribute("name", this.themeVO.getThemeName());
            String nameSpace = this.themeVO.isPreset() ? NameSpace.system.toPersistance() : NameSpace.user.toPersistance();
            subjectElement.setAttribute("nameSpace", nameSpace);
            if (this.themeGroupVO != null) {
                subjectElement.setAttribute("category", this.themeGroupVO.getThemeGroupName());
            }
            if (StringUtils.isNotEmpty((CharSequence)this.themeVO.getDescription())) {
                Element descElement = new Element("Desc");
                XmlUtil.addCDATA((Element)descElement, (String)this.themeVO.getDescription());
                subjectElement.addContent((Content)descElement);
            }
        }
        if (this.dataModelingObj != null) {
            subjectElement.addContent((Content)this.dataModelingObj.toXml(publishPO.getId()));
        }
        if (this.subjectQsInfo != null) {
            subjectElement.addContent((Content)this.subjectQsInfo.toXml());
        }
        carryDataInfoElement.addContent((Content)subjectElement);
        return carryDataInfoElement;
    }

    @Override
    public void fromXml(Element xml, String type, String version) throws ModelParseException, JDOMException, IOException {
        Element subjectObjElement;
        Element carryDataInfoElm = xml.getChild("CarryDataInfo");
        if (carryDataInfoElm != null && (subjectObjElement = carryDataInfoElm.getChild("Subject")) != null) {
            Element subjectQsInfoElement;
            Element dataModelingElement;
            this.themeGroupVO = new ThemeGroupVO();
            this.themeGroupVO.setThemeGroupName(subjectObjElement.getAttributeValue("category"));
            this.themeVO = new ThemeVO();
            this.themeVO.setThemeID(subjectObjElement.getAttributeValue("id"));
            this.themeVO.setThemeName(subjectObjElement.getAttributeValue("name"));
            this.themeVO.setPreset(NameSpace.system.name().equals(subjectObjElement.getAttributeValue("nameSpace")));
            Element descElement = subjectObjElement.getChild("Desc");
            if (descElement != null) {
                this.themeVO.setDescription(descElement.getTextTrim());
            }
            if ((dataModelingElement = subjectObjElement.getChild("DataModeling")) != null) {
                this.dataModelingObj = new DataModelingObject();
                this.dataModelingObj.fromXml(dataModelingElement, type, version);
            }
            if ((subjectQsInfoElement = subjectObjElement.getChild("QsInfo")) != null) {
                this.subjectQsInfo = new SubjectQsInfo();
                this.subjectQsInfo.fromXml(subjectQsInfoElement, type, version);
            }
        }
    }

    @Override
    public void exportFile(String publishId, ZipOutputStream zos) throws IOException {
        if (this.dataModelingObj != null) {
            this.dataModelingObj.exportFile(publishId, zos);
        }
        if (this.subjectQsInfo != null) {
            this.subjectQsInfo.exportFile(zos);
        }
    }

    @Override
    public void endCleanFiles() {
        if (this.dataModelingObj != null) {
            this.dataModelingObj.endCleanFiles();
        }
        if (this.subjectQsInfo != null) {
            this.subjectQsInfo.endCleanFiles();
        }
    }
}

