/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.model.resource;

import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.util.IOUtil;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipOutputStream;
import org.jdom2.Element;

public class QingMap {
    private String id;
    private String name;
    private String desc;
    private String categoryName;
    private String nameSpace;
    private String version;
    private String modelFileName;
    private String svgFileName;
    private String configFileName;
    private String thumbnailFileName;
    private String backgroundImageFileName;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public void setNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
    }

    public String getModelFileName() {
        return this.modelFileName;
    }

    public void setModelFileName(String modelFileName) {
        this.modelFileName = modelFileName;
    }

    public String getSvgFileName() {
        return this.svgFileName;
    }

    public void setSvgFileName(String svgFileName) {
        this.svgFileName = svgFileName;
    }

    public String getConfigFileName() {
        return this.configFileName;
    }

    public void setConfigFileName(String configFileName) {
        this.configFileName = configFileName;
    }

    public String getThumbnailFileName() {
        return this.thumbnailFileName;
    }

    public void setThumbnailFileName(String thumbnailFileName) {
        this.thumbnailFileName = thumbnailFileName;
    }

    public String getBackgroundImageFileName() {
        return this.backgroundImageFileName;
    }

    public void setBackgroundImageFileName(String backgroundImageFileName) {
        this.backgroundImageFileName = backgroundImageFileName;
    }

    public Element toXml() {
        Element xml = new Element("Map");
        xml.setAttribute("id", this.id);
        xml.setAttribute("name", this.name);
        xml.setAttribute("categoryName", this.categoryName);
        if (this.version != null) {
            xml.setAttribute("version", this.version);
        }
        xml.setAttribute("nameSpace", this.nameSpace);
        if (this.desc != null) {
            Element descElm = new Element("Desc");
            XmlUtil.addCDATA((Element)descElm, (String)this.desc);
        }
        return xml;
    }

    public void fromXml(Element mapElement, String type, String version) {
        this.id = mapElement.getAttributeValue("id");
        this.name = mapElement.getAttributeValue("name");
        this.categoryName = mapElement.getAttributeValue("categoryName");
        this.version = mapElement.getAttributeValue("version");
        this.nameSpace = mapElement.getAttributeValue("nameSpace");
        Element descElm = mapElement.getChild("Desc");
        if (descElm != null) {
            this.desc = descElm.getText();
        }
    }

    public void exportFile(ZipOutputStream zos) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)this.modelFileName)) {
            IOUtil.writeZipEntry((ZipOutputStream)zos, (AbstractQingFileType)QingPersistentFileType.MAP, (String)this.modelFileName, (String)this.getModelZipFilePathName());
        }
        if (StringUtils.isNotBlank((CharSequence)this.svgFileName)) {
            IOUtil.writeZipEntry((ZipOutputStream)zos, (AbstractQingFileType)QingPersistentFileType.MAP, (String)this.svgFileName, (String)this.getSvgZipFilePathName());
        }
        if (StringUtils.isNotBlank((CharSequence)this.configFileName)) {
            IOUtil.writeZipEntry((ZipOutputStream)zos, (AbstractQingFileType)QingPersistentFileType.MAP, (String)this.configFileName, (String)this.getConfigZipFilePathName());
        }
        if (StringUtils.isNotBlank((CharSequence)this.thumbnailFileName)) {
            IOUtil.writeZipEntry((ZipOutputStream)zos, (AbstractQingFileType)QingPersistentFileType.MAP, (String)this.thumbnailFileName, (String)this.getThumbnailZipFilePathName());
        }
        if (StringUtils.isNotBlank((CharSequence)this.backgroundImageFileName)) {
            IOUtil.writeZipEntry((ZipOutputStream)zos, (AbstractQingFileType)QingPersistentFileType.MAP, (String)this.backgroundImageFileName, (String)this.getBackgroundImageZipFilePathName());
        }
    }

    private String getModelZipFilePathName() {
        return this.getZipPathPrefix() + this.getModelZipFileName();
    }

    public String getModelZipFileName() {
        return this.id + ".model";
    }

    private String getSvgZipFilePathName() {
        return this.getZipPathPrefix() + this.getSvgZipFileName();
    }

    public String getSvgZipFileName() {
        return this.id + ".svg";
    }

    private String getConfigZipFilePathName() {
        return this.getZipPathPrefix() + this.getConfigZipFileName();
    }

    public String getConfigZipFileName() {
        return this.id + ".config";
    }

    private String getThumbnailZipFilePathName() {
        return this.getZipPathPrefix() + this.getThumbnailZipFileName();
    }

    public String getThumbnailZipFileName() {
        return this.id + ".thumbnail";
    }

    private String getBackgroundImageZipFilePathName() {
        return this.getZipPathPrefix() + this.getBackgroundImageZipFileName();
    }

    public String getBackgroundImageZipFileName() {
        return this.id + ".background-image";
    }

    private String getZipPathPrefix() {
        return "resource" + File.separator + "map" + File.separator;
    }
}

