/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.model.subject;

import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.imexport.model.QsInfo;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.IOUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jdom2.Content;
import org.jdom2.Element;

public class SubjectQsInfo
extends QsInfo {
    private Map<String, String> qs = new HashMap<String, String>();

    public Map<String, String> getQs() {
        return this.qs;
    }

    public void setQs(Map<String, String> qs) {
        this.qs = qs;
    }

    @Override
    public Element toXml() {
        Element qsInfoElement = super.toXml();
        for (Map.Entry<String, String> entry : this.qs.entrySet()) {
            Element qsElement = new Element("Qs");
            qsElement.setAttribute("entityName", entry.getKey());
            qsElement.setAttribute("file", entry.getValue() + ".qs");
            qsInfoElement.addContent((Content)qsElement);
        }
        return qsInfoElement;
    }

    public void fromXml(Element qsInfoElement, String type, String version) {
        super.fromXml(qsInfoElement);
        List elementList = qsInfoElement.getChildren("Qs");
        for (Element qsElement : elementList) {
            this.qs.put(qsElement.getAttributeValue("entityName"), qsElement.getAttributeValue("file"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportFile(ZipOutputStream zos) throws IOException {
        super.exportFile(zos);
        for (Map.Entry<String, String> entry : this.qs.entrySet()) {
            QingInputStream is = null;
            try {
                String fileName = entry.getValue();
                IQingFileVisitor qingFileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.TEMP_QS, (String)fileName);
                if (!qingFileVisitor.exists()) {
                    qingFileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.DATAMODELING_QS, (String)fileName);
                }
                String boxFilePath = "qs" + File.separator + fileName + ".qs";
                zos.putNextEntry(new ZipEntry(boxFilePath));
                is = qingFileVisitor.getInputStream();
                IOUtil.copy((InputStream)is, (OutputStream)zos);
                zos.flush();
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{is});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{is});
        }
    }
}

