/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.util;

import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.common.trace.TraceSpan;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.filesystem.manager.CopyWriteCall;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.api.IWriteCall;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.imexport.exporter.exception.ExportException;
import com.kingdee.bos.qing.imexport.importer.exception.ImportException;
import com.kingdee.bos.qing.imexport.importer.pkg.model.ImportParamModel;
import com.kingdee.bos.qing.imexport.importer.qhf.model.TraceSpanVO;
import com.kingdee.bos.qing.imexport.model.ImportedModel;
import com.kingdee.bos.qing.publish.model.PermissionInfo;
import com.kingdee.bos.qing.publish.model.PermissionObject;
import com.kingdee.bos.qing.publish.model.PublishOperPermissionsObject;
import com.kingdee.bos.qing.publish.model.PublishOperPermissionsPO;
import com.kingdee.bos.qing.schema.model.SchemaTypeEnum;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.IOUtil;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class ImExportUtil {
    public static String[] parseEntryNameToList(String zipEntryName) {
        String[] zipEntryPath = null;
        zipEntryPath = zipEntryName.contains("\\") ? zipEntryName.split("\\\\") : (zipEntryName.contains("/") ? zipEntryName.split("/") : new String[]{zipEntryName});
        return zipEntryPath;
    }

    public static ByteArrayInputStream getInputStreamFromZipInputStream(ZipInputStream zipInputStream) throws IOException {
        return new ByteArrayInputStream(ImExportUtil.getBytesFromZipInputStream(zipInputStream));
    }

    private static byte[] getBytesFromZipInputStream(ZipInputStream zipInputStream) throws IOException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = zipInputStream.read(buffer)) > -1) {
            baos.write(buffer, 0, len);
        }
        baos.flush();
        return baos.toByteArray();
    }

    public static String writeBytesToExportTempFile(byte[] bytes) throws IOException {
        IQingFile tempFile = FileFactory.newTempFile((QingTempFileType)QingTempFileType.EXPORT);
        tempFile.write((IWriteCall)new CopyWriteCall((InputStream)new ByteArrayInputStream(bytes), false), true);
        return tempFile.getName();
    }

    public static String writeXmlToExportTempFile(Element element) throws IOException {
        try (ByteArrayOutputStream baos = null;){
            baos = new ByteArrayOutputStream();
            XmlUtil.save((Element)element, (OutputStream)baos);
            String string = ImExportUtil.writeBytesToExportTempFile(baos.toByteArray());
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportFile(ZipOutputStream zos, String exportFileName, String zipFilePath) throws IOException {
        QingInputStream is = null;
        try {
            IQingFileVisitor file = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.EXPORT, (String)exportFileName);
            if (file.exists()) {
                zos.putNextEntry(new ZipEntry(zipFilePath));
                is = file.getInputStream();
                IOUtil.copy((InputStream)is, (OutputStream)zos);
                zos.flush();
            }
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{is});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{is});
    }

    public static void deleteExportFile(String exportFileName) {
        if (StringUtils.isBlank((CharSequence)exportFileName)) {
            return;
        }
        FileFactory.clearTempFile((QingTempFileType)QingTempFileType.EXPORT, (String)exportFileName);
    }

    public static List<PermissionObject> getPermissionObjs(List<PermissionInfo> permissionInfos) throws ExportException {
        if (permissionInfos != null) {
            ArrayList<PermissionObject> permissionObjs = new ArrayList<PermissionObject>(16);
            for (PermissionInfo permissionInfo : permissionInfos) {
                PermissionObject permissionObj = new PermissionObject();
                permissionObj.setPermissionInfo(permissionInfo);
                permissionObjs.add(permissionObj);
            }
            return permissionObjs;
        }
        return null;
    }

    public static List<PublishOperPermissionsObject> getPublishOperObjs(List<PublishOperPermissionsPO> publishOperPermissionsPOList) throws ExportException {
        if (publishOperPermissionsPOList != null) {
            ArrayList<PublishOperPermissionsObject> publishOperPermissionsObjects = new ArrayList<PublishOperPermissionsObject>(16);
            for (PublishOperPermissionsPO publishOperPermissionsPO : publishOperPermissionsPOList) {
                PublishOperPermissionsObject publishOperPermissionsObject = new PublishOperPermissionsObject();
                publishOperPermissionsObject.setPublishOperPermissionsPO(publishOperPermissionsPO);
                publishOperPermissionsObjects.add(publishOperPermissionsObject);
            }
            return publishOperPermissionsObjects;
        }
        return null;
    }

    public static String rename(String name) {
        String newName = null;
        if (name.lastIndexOf("_") > 0) {
            String indexStr = name.substring(name.lastIndexOf("_") + 1);
            newName = name.substring(0, name.lastIndexOf("_"));
            try {
                Integer index = Integer.parseInt(indexStr);
                index = index + 1;
                newName = newName + "_" + index;
            }
            catch (NumberFormatException e) {
                newName = name + "_1";
            }
        } else {
            newName = name + "_1";
        }
        return newName;
    }

    public static void cacheDashboardWidgetID(ImportParamModel importParamModel, String dsbId, String uid, String fullPath, String type) {
        Map<String, List<String>> cacheDsbIdAndUid = importParamModel.getCacheDsbIdAndUid();
        String dashboardWidgetID = dsbId + "," + uid + "," + type;
        List<Object> dsbIdAndUids = null;
        if (cacheDsbIdAndUid.containsKey(fullPath)) {
            dsbIdAndUids = cacheDsbIdAndUid.get(fullPath);
            dsbIdAndUids.add(dashboardWidgetID);
        } else {
            dsbIdAndUids = new ArrayList();
            dsbIdAndUids.add(dashboardWidgetID);
            cacheDsbIdAndUid.put(fullPath, dsbIdAndUids);
        }
    }

    public static Element traceSpansToXml(List<TraceSpan> traceSpans) {
        Element tracesElement = new Element("Traces");
        for (TraceSpan traceSpan : traceSpans) {
            tracesElement.addContent((Content)traceSpan.toXml());
        }
        return tracesElement;
    }

    public static List<TraceSpan> getTraceSpansByZipFileName(String zipFileName, ImportedModel importedModel) throws ImportException {
        if (StringUtils.isBlank((CharSequence)zipFileName)) {
            return null;
        }
        Map<String, String> tempMap = importedModel.getTempFileMap();
        String exportFileName = tempMap.get(zipFileName);
        try {
            Element xmlElement;
            List traceElements;
            IQingFileVisitor qingFileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.UPLOAD, (String)exportFileName);
            if (qingFileVisitor.exists() && (traceElements = (xmlElement = XmlUtil.loadRootElement((InputStream)qingFileVisitor.getInputStream())).getChildren("Trace")) != null && !traceElements.isEmpty()) {
                ArrayList<TraceSpan> traceSpans = new ArrayList<TraceSpan>(10);
                for (Element traceElement : traceElements) {
                    TraceSpan traceSpan = TraceSpan.fromXml((Element)traceElement);
                    traceSpans.add(traceSpan);
                }
                return traceSpans;
            }
        }
        catch (JDOMException e) {
            throw new ImportException(e);
        }
        catch (IOException e) {
            throw new ImportException(e);
        }
        return null;
    }

    public static String getInitSchemaId(SchemaTypeEnum schemaTypeEnum) {
        switch (schemaTypeEnum) {
            case longer: {
                return "longerInitSchemaId";
            }
            case square: {
                return "squareInitSchemaId";
            }
        }
        return "";
    }

    public static String getFinalSchemaId(SchemaTypeEnum schemaTypeEnum) {
        switch (schemaTypeEnum) {
            case longer: {
                return "longerFinalSchemaId";
            }
            case square: {
                return "squareFinalSchemaId";
            }
        }
        return "";
    }

    public static List<TraceSpanVO> traceSpansToVOs(List<TraceSpan> traceSpans, int level) {
        ArrayList<TraceSpanVO> traceSpanVOList = new ArrayList<TraceSpanVO>(10);
        if (traceSpans != null && !traceSpans.isEmpty()) {
            for (TraceSpan traceSpan : traceSpans) {
                ImExportUtil.parseChildrenTraceSpan(traceSpanVOList, traceSpan, level, 100.0);
            }
        }
        return traceSpanVOList;
    }

    private static void parseChildrenTraceSpan(List<TraceSpanVO> traceSpanVOList, TraceSpan traceSpan, int level, Double costPercent) {
        TraceSpanVO traceSpanInfoVO = new TraceSpanVO();
        traceSpanInfoVO.setDescription(traceSpan.getDescription());
        traceSpanInfoVO.setCost(traceSpan.getCost());
        traceSpanInfoVO.setAttributeMap(traceSpan.getAttributeMap());
        traceSpanInfoVO.setSeriesNum(traceSpan.getSeriesNum());
        traceSpanInfoVO.setCostPercent(costPercent);
        traceSpanInfoVO.setLevel(level);
        traceSpanVOList.add(traceSpanInfoVO);
        long allChildrenCost = 0L;
        long parentCost = traceSpan.getCost();
        Double parentCostPercent = traceSpanInfoVO.getCostPercent();
        List children = traceSpan.getChildren();
        if (children != null && !children.isEmpty()) {
            for (TraceSpan child : children) {
                allChildrenCost += child.getCost();
                ImExportUtil.parseChildrenTraceSpan(traceSpanVOList, child, level + 1, ImExportUtil.getCostPercentRelativeToWholeChain(child.getCost(), parentCost, parentCostPercent));
            }
            long privateCost = parentCost - allChildrenCost;
            TraceSpanVO privateTraceSpanInfoVO = new TraceSpanVO();
            privateTraceSpanInfoVO.setDescription(Messages.getMLS((String)"useTime", (String)"\u81ea\u7528\u65f6\u95f4", (Messages.ProjectName)Messages.ProjectName.QING_THEME));
            privateTraceSpanInfoVO.setCost(privateCost);
            privateTraceSpanInfoVO.setLevel(level + 1);
            privateTraceSpanInfoVO.setNodeType(TraceSpanVO.TraceSpanVONodeTypeEnum.PRIVATE.name());
            privateTraceSpanInfoVO.setCostPercent(ImExportUtil.getCostPercentRelativeToWholeChain(privateCost, parentCost, parentCostPercent));
            traceSpanVOList.add(privateTraceSpanInfoVO);
        } else {
            traceSpanInfoVO.setNodeType(TraceSpanVO.TraceSpanVONodeTypeEnum.LAST.name());
        }
    }

    private static double getCostPercentRelativeToWholeChain(long myCost, long parentCost, double parentCostPercent) {
        if (parentCost > 0L) {
            BigDecimal bigDecimal = new BigDecimal(myCost).multiply(BigDecimal.valueOf(parentCostPercent)).divide(new BigDecimal(parentCost), 2, 4);
            return bigDecimal.doubleValue();
        }
        return 100.0;
    }

    public static List<TraceSpanVO> getTraceSpanVOsByZipTraceFileName(String zipTraceFileName, ImportedModel importedModel, int level, String nodeDescription) throws ImportException {
        ArrayList<TraceSpanVO> traceSpanVOList = new ArrayList<TraceSpanVO>(10);
        List<TraceSpan> extractDataTraceSpans = ImExportUtil.getTraceSpansByZipFileName(zipTraceFileName, importedModel);
        if (extractDataTraceSpans != null && !extractDataTraceSpans.isEmpty()) {
            TraceSpanVO extractDataNodeTraceSpanVO = new TraceSpanVO();
            extractDataNodeTraceSpanVO.setLevel(level);
            extractDataNodeTraceSpanVO.setDescription(nodeDescription);
            traceSpanVOList.add(extractDataNodeTraceSpanVO);
            List<TraceSpanVO> extractDataTraceSpanVOs = ImExportUtil.traceSpansToVOs(extractDataTraceSpans, level + 1);
            traceSpanVOList.addAll(extractDataTraceSpanVOs);
        }
        return traceSpanVOList;
    }

    public static List<ReferenceMap> getNeedExportPublishInfoRefList(Map<String, ReferenceMap> uniqueRefSourceMap, List<ReferenceMap> referenceMapList) {
        ArrayList<ReferenceMap> needExportPublishInfoRefList = new ArrayList<ReferenceMap>(referenceMapList);
        needExportPublishInfoRefList.removeAll(uniqueRefSourceMap.values());
        for (int i = needExportPublishInfoRefList.size() - 1; i >= 0; --i) {
            ReferenceMap referenceMap = (ReferenceMap)needExportPublishInfoRefList.get(i);
            String refType = referenceMap.getRefType();
            RefTypeEnum refTypeEnum = RefTypeEnum.valueOf((String)refType);
            if (refTypeEnum != RefTypeEnum.subject) continue;
            needExportPublishInfoRefList.remove(i);
        }
        return needExportPublishInfoRefList;
    }
}

