/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.manage;

import com.kingdee.bos.qing.behavior.BehaviorAssociate;
import com.kingdee.bos.qing.behavior.impl.BehaviorService;
import com.kingdee.bos.qing.common.context.IQingContextable;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBAccessable;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.filesystem.stream.QingEncryptedStreamUtil;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.imexport.exporter.pkg.domain.ExportPKGDomain;
import com.kingdee.bos.qing.imexport.importer.pkg.domain.ImportPKGDomain;
import com.kingdee.bos.qing.manage.domain.AbstractThemeManageDomain;
import com.kingdee.bos.qing.manage.domain.ThemeDomain;
import com.kingdee.bos.qing.manage.domain.ThemeGroupDomain;
import com.kingdee.bos.qing.manage.domain.impl.ThemeMangeDomainFactory;
import com.kingdee.bos.qing.manage.exception.ThemeManagementException;
import com.kingdee.bos.qing.manage.exception.ThemeNotFoundException;
import com.kingdee.bos.qing.manage.handover.domain.HandOverDomain;
import com.kingdee.bos.qing.manage.imexport.domain.ImExportDomain;
import com.kingdee.bos.qing.manage.imexport.model.vo.ExportListThemeVO;
import com.kingdee.bos.qing.manage.imexport.model.vo.ExportPublishConflictVO;
import com.kingdee.bos.qing.manage.imexport.model.vo.ExportThemeVO;
import com.kingdee.bos.qing.manage.model.FolderNode;
import com.kingdee.bos.qing.manage.model.ThemeGroupListVO;
import com.kingdee.bos.qing.manage.model.ThemeGroupPO;
import com.kingdee.bos.qing.manage.model.ThemeGroupVO;
import com.kingdee.bos.qing.manage.model.ThemeListVO;
import com.kingdee.bos.qing.manage.model.ThemePO;
import com.kingdee.bos.qing.manage.model.ThemeVO;
import com.kingdee.bos.qing.message.domain.MessageDomain;
import com.kingdee.bos.qing.message.model.MessageLevelTypeEnum;
import com.kingdee.bos.qing.message.model.MessageReadFlagEnum;
import com.kingdee.bos.qing.response.AbstractResponseWrap;
import com.kingdee.bos.qing.response.IResponseWrap;
import com.kingdee.bos.qing.response.ResponseErrorWrap;
import com.kingdee.bos.qing.response.ResponseSuccessWrap;
import com.kingdee.bos.qing.response.ResponseUtil;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.schedule.IScheduleEngineable;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.JsonUtil;
import java.io.Closeable;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ThemeService
extends BehaviorService
implements IQingContextable,
IDBAccessable,
IScheduleEngineable {
    private static final String THEME_ID = "themeID";
    private static final String THEME_NAME = "themeName";
    private QingContext context;
    private ITransactionManagement tx;
    private IDBExcuter dbExcuter;
    private IScheduleEngine scheduleEngine;
    private ThemeDomain themeDomain;
    private Map<String, AbstractThemeManageDomain> manageDomainMap;
    private ThemeGroupDomain themeGroupDomain;
    private ImExportDomain exportDomain;
    private ExportPKGDomain exportPKGDomain;
    private ImportPKGDomain importPKGDomain;
    private HandOverDomain handOverDomain;
    private MessageDomain messageDomain;

    public void setQingContext(QingContext context) {
        this.context = context;
    }

    public void setTx(ITransactionManagement tx) {
        this.tx = tx;
    }

    public void setScheduleEngine(IScheduleEngine scheduleEngine) {
        this.scheduleEngine = scheduleEngine;
    }

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    private ThemeDomain getThemeDomain() {
        if (this.themeDomain == null) {
            this.themeDomain = new ThemeDomain(this.context, this.dbExcuter);
        }
        return this.themeDomain;
    }

    private ThemeGroupDomain getThemeGroupDomain() {
        if (this.themeGroupDomain == null) {
            this.themeGroupDomain = new ThemeGroupDomain();
            this.themeGroupDomain.setQingContext(this.context);
            this.themeGroupDomain.setTx(this.tx);
            this.themeGroupDomain.setDbExcuter(this.dbExcuter);
            this.themeGroupDomain.setScheduleEngine(this.scheduleEngine);
        }
        return this.themeGroupDomain;
    }

    private ImExportDomain getExportDomain() {
        if (this.exportDomain == null) {
            this.exportDomain = new ImExportDomain();
            this.exportDomain.setTx(this.tx);
            this.exportDomain.setDbExcuter(this.dbExcuter);
            this.exportDomain.setQingContext(this.context);
            this.exportDomain.setScheduleEngine(this.scheduleEngine);
        }
        return this.exportDomain;
    }

    private ExportPKGDomain getExportPKGDomain() {
        if (this.exportPKGDomain == null) {
            this.exportPKGDomain = new ExportPKGDomain();
            this.exportPKGDomain.setDbExcuter(this.dbExcuter);
            this.exportPKGDomain.setQingContext(this.context);
            this.exportPKGDomain.setTx(this.tx);
            this.exportPKGDomain.setScheduleEngine(this.scheduleEngine);
        }
        return this.exportPKGDomain;
    }

    private ImportPKGDomain getImportPKGDomain() {
        if (this.importPKGDomain == null) {
            this.importPKGDomain = new ImportPKGDomain();
            this.importPKGDomain.setDbExcuter(this.dbExcuter);
            this.importPKGDomain.setQingContext(this.context);
            this.importPKGDomain.setTx(this.tx);
            this.importPKGDomain.setScheduleEngine(this.scheduleEngine);
        }
        return this.importPKGDomain;
    }

    private AbstractThemeManageDomain getThemeManageDomainByThemeId(String userID, String themeId) throws AbstractQingException {
        ThemeVO themeVO;
        try {
            themeVO = this.getThemeDomain().loadThemeIncludePreset(userID, themeId);
        }
        catch (SQLException e) {
            throw new ThemeManagementException(e);
        }
        if (themeVO == null) {
            throw new ThemeNotFoundException();
        }
        return this.getThemeManageDomain(themeVO);
    }

    private AbstractThemeManageDomain getThemeManageDomain(ThemeVO themeVO) throws ThemeManagementException {
        AbstractThemeManageDomain manageDomain;
        String themeType = themeVO.getThemeType();
        if (this.manageDomainMap == null) {
            this.manageDomainMap = new HashMap<String, AbstractThemeManageDomain>();
        }
        if ((manageDomain = this.manageDomainMap.get(themeType)) == null) {
            manageDomain = ThemeMangeDomainFactory.create(themeType, this.context, this.tx, this.dbExcuter, this.scheduleEngine);
            this.manageDomainMap.put(themeType, manageDomain);
        }
        if (manageDomain == null) {
            throw new ThemeManagementException(new UnsupportedOperationException("unsupported ThemeType:" + themeType));
        }
        return manageDomain;
    }

    private HandOverDomain getHandOverDomain() {
        if (this.handOverDomain == null) {
            this.handOverDomain = new HandOverDomain(this.context, this.tx, this.dbExcuter, this.scheduleEngine);
        }
        return this.handOverDomain;
    }

    private MessageDomain getMessageDomain() {
        if (this.messageDomain == null) {
            this.messageDomain = new MessageDomain(this.context, this.tx, this.dbExcuter);
        }
        return this.messageDomain;
    }

    public byte[] listThemeGroup(Map<String, String> params) {
        String userID = this.context.getUserId();
        try {
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(this.getThemeGroupDomain().listThemeGroup(userID)));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public byte[] saveOrUpdateThemeGroup(Map<String, String> params) {
        ThemeGroupVO groupVO = (ThemeGroupVO)JsonUtil.decodeFromString((String)params.get("model"), ThemeGroupVO.class);
        ThemeGroupPO groupPO = new ThemeGroupPO();
        groupPO.setThemeGroupID(groupVO.getThemeGroupID());
        groupPO.setThemeGroupName(groupVO.getThemeGroupName());
        groupPO.setOrderID(groupVO.getOrderID());
        String userId = this.context.getUserId();
        groupPO.setUserID(userId);
        try {
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)this.getThemeGroupDomain().saveOrUpdateThemeGroup(groupPO));
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public byte[] saveOrderThemeGroup(Map<String, String> params) {
        List<ThemeGroupVO> themeGroupList = ((ThemeGroupListVO)JsonUtil.decodeFromString((String)params.get("themeGroupList"), ThemeGroupListVO.class)).getThemeGroupList();
        ArrayList<ThemeGroupPO> groupPOList = new ArrayList<ThemeGroupPO>(themeGroupList.size());
        String userId = this.context.getUserId();
        ThemeGroupPO groupPO = null;
        for (ThemeGroupVO themeGroupVO : themeGroupList) {
            groupPO = new ThemeGroupPO();
            groupPO.setThemeGroupID(themeGroupVO.getThemeGroupID());
            groupPO.setOrderID(themeGroupVO.getOrderID());
            groupPO.setUserID(userId);
            groupPOList.add(groupPO);
        }
        try {
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)this.getThemeGroupDomain().saveOrderThemeGroup(groupPOList));
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public byte[] deleteThemeGroup(Map<String, String> params) {
        try {
            String groupID = params.get("themeGroupID");
            String userID = this.context.getUserId();
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)this.getThemeGroupDomain().deleteThemeGroup(userID, groupID));
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] listGroupedTheme(Map<String, String> params) {
        String groupID = params.get("themeGroupID");
        String userID = this.context.getUserId();
        try {
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(this.getThemeDomain().listUserVisibleThemes(userID, groupID)));
        }
        catch (SQLException ex) {
            ThemeManagementException e = new ThemeManagementException(ex);
            return ResponseUtil.output((Exception)((Object)e));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public byte[] listAllGroupTheme(Map<String, String> params) {
        List arrThemeGroup = (List)JsonUtil.decodeFromString((String)params.get("arrThemeGroupID"), List.class);
        String userID = this.context.getUserId();
        try {
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(this.getThemeDomain().listUserVisibleAllThemes(userID, arrThemeGroup)));
        }
        catch (SQLException ex) {
            ThemeManagementException e = new ThemeManagementException(ex);
            return ResponseUtil.output((Exception)((Object)e));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public byte[] saveOrUpdateTheme(Map<String, String> params) {
        ThemeVO themeVO = (ThemeVO)JsonUtil.decodeFromString((String)params.get("model"), ThemeVO.class);
        ThemePO themePO = new ThemePO();
        themePO.setThemeID(themeVO.getThemeID());
        themePO.setGroupID(themeVO.getThemeGroupID());
        themePO.setThemeName(themeVO.getThemeName());
        themePO.setDescription(themeVO.getDescription());
        themePO.setThemeType(themeVO.getThemeType());
        String userID = this.context.getUserId();
        themePO.setUserID(userID);
        try {
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)this.getThemeManageDomain(themeVO).saveOrUpdateTheme(themePO));
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public byte[] deleteTheme(Map<String, String> params) {
        String themeID = params.get(THEME_ID);
        boolean deletePublish = Boolean.parseBoolean(params.get("deletePublish"));
        String userID = this.context.getUserId();
        try {
            AbstractThemeManageDomain themeManageDomain = this.getThemeManageDomainByThemeId(userID, themeID);
            List<String> publishIds = themeManageDomain.deleteTheme(userID, themeID, deletePublish);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(publishIds);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public byte[] copyTheme(Map<String, String> params) {
        String userID = this.context.getUserId();
        params.put("userID", userID);
        String themeID = params.get(THEME_ID);
        try {
            AbstractThemeManageDomain themeManageDomain = this.getThemeManageDomainByThemeId(userID, themeID);
            ThemeVO themeVO = themeManageDomain.copyTheme(params);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)themeVO);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public byte[] moveTheme(Map<String, String> params) {
        String themeID = params.get(THEME_ID);
        String groupID = params.get("groupID");
        String themeName = params.get(THEME_NAME);
        String userID = this.context.getUserId();
        try {
            this.getThemeManageDomainByThemeId(userID, themeID).moveTheme(userID, groupID, themeID, themeName);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)true);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public byte[] saveOrderTheme(Map<String, String> params) {
        List<ThemeVO> themeList = ((ThemeListVO)JsonUtil.decodeFromString((String)params.get("themeList"), ThemeListVO.class)).getThemeList();
        ArrayList<ThemePO> themePOList = new ArrayList<ThemePO>(themeList.size());
        String userId = this.context.getUserId();
        ThemePO themePO = null;
        for (ThemeVO themeVO : themeList) {
            themePO = new ThemePO();
            themePO.setThemeID(themeVO.getThemeID());
            themePO.setOrderID(themeVO.getOrderID());
            themePO.setUserID(userId);
            themePOList.add(themePO);
        }
        try {
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)this.getThemeGroupDomain().saveOrderTheme(themePOList));
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] getAllThemeForExportTheme(Map<String, String> params) {
        String userID = this.context.getUserId();
        try {
            FolderNode root = this.getExportDomain().getExportThemeFolder(userID);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)root);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public byte[] confirmForExportTheme(Map<String, String> params) {
        String userID = this.context.getUserId();
        List<ExportThemeVO> themeList = ((ExportListThemeVO)JsonUtil.decodeFromString((String)params.get("themeList"), ExportListThemeVO.class)).getExportThemes();
        boolean needPublish = Boolean.parseBoolean(params.get("needPublish"));
        IQingFile exportFile = FileFactory.newTempFile((QingTempFileType)QingTempFileType.EXPORT);
        ImExportDomain imExportDomain = this.getExportDomain();
        try {
            imExportDomain.compressZipFile(userID, themeList, needPublish, exportFile);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)exportFile.getName());
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getSelectableForImportTheme(Map<String, String> params) {
        byte[] byArray;
        String fileName = params.get("fileName");
        FolderNode root = null;
        ZipInputStream zis = null;
        QingEncryptedStreamUtil.setEncryptedFlag((QingEncryptedStreamUtil.EncryptedType)QingEncryptedStreamUtil.EncryptedType.IMPORT);
        IQingFileVisitor zipFile = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.UPLOAD, (String)fileName);
        QingInputStream in = zipFile.getInputStream();
        try {
            zis = QingEncryptedStreamUtil.createZipInputStream((InputStream)in);
        }
        catch (Throwable e) {
            byte[] byArray2 = ResponseUtil.output((IResponseWrap)new ResponseErrorWrap(e));
            QingEncryptedStreamUtil.clearEncryptedFlag();
            CloseUtil.close((Closeable[])new Closeable[]{zis});
            return byArray2;
        }
        try {
            ZipEntry zipEntry = zis.getNextEntry();
            root = zipEntry.getName().equals("package-meta.xml") ? this.getImportPKGDomain().parseThemeZipFile(zis) : this.getExportDomain().parseThemeZipFile(fileName);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)root);
            byArray = ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            byte[] byArray3;
            try {
                byArray3 = ResponseUtil.output((Exception)e);
            }
            catch (Throwable throwable) {
                QingEncryptedStreamUtil.clearEncryptedFlag();
                CloseUtil.close((Closeable[])new Closeable[]{zis});
                throw throwable;
            }
            QingEncryptedStreamUtil.clearEncryptedFlag();
            CloseUtil.close((Closeable[])new Closeable[]{zis});
            return byArray3;
        }
        QingEncryptedStreamUtil.clearEncryptedFlag();
        CloseUtil.close((Closeable[])new Closeable[]{zis});
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BehaviorAssociate(behavior=true)
    public byte[] importSelectedTheme(Map<String, String> params) {
        byte[] byArray;
        String fileName = params.get("fileName");
        String sourceStrategy = params.get("sourceStrategy");
        boolean firstTimeImport = Boolean.parseBoolean(params.get("firstTimeImport"));
        String cacheImportMapIdKey = params.get("cacheIdKey");
        String paramPathPrefix = params.get("paramPathPrefix");
        List<ExportThemeVO> themeList = ((ExportListThemeVO)JsonUtil.decodeFromString((String)params.get("themeList"), ExportListThemeVO.class)).getExportThemes();
        ArrayList<ExportThemeVO> selectedThemeList = new ArrayList<ExportThemeVO>();
        for (int i = 0; i < themeList.size(); ++i) {
            ExportThemeVO exportTheme = themeList.get(i);
            if ("ignore".equals(exportTheme.getStrategy())) continue;
            selectedThemeList.add(exportTheme);
        }
        ZipInputStream zis = null;
        QingEncryptedStreamUtil.setEncryptedFlag((QingEncryptedStreamUtil.EncryptedType)QingEncryptedStreamUtil.EncryptedType.IMPORT);
        IQingFileVisitor zipFile = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.UPLOAD, (String)fileName);
        QingInputStream in = zipFile.getInputStream();
        try {
            zis = QingEncryptedStreamUtil.createZipInputStream((InputStream)in);
        }
        catch (Throwable e) {
            byte[] byArray2 = ResponseUtil.output((IResponseWrap)new ResponseErrorWrap(e));
            QingEncryptedStreamUtil.clearEncryptedFlag();
            CloseUtil.close((Closeable[])new Closeable[]{zis});
            return byArray2;
        }
        try {
            HashMap<String, String> map;
            int i;
            ZipEntry zipEntry = zis.getNextEntry();
            Map<Object, Object> importConflict = new HashMap();
            importConflict = zipEntry.getName().equals("package-meta.xml") ? this.getImportPKGDomain().importSelected(fileName, selectedThemeList, sourceStrategy, firstTimeImport, cacheImportMapIdKey, paramPathPrefix) : this.getExportDomain().importSelectedTheme(zipFile, selectedThemeList, sourceStrategy, firstTimeImport, cacheImportMapIdKey);
            List conflictExportThemeList = (List)importConflict.get("conflictTheme");
            List conflictPublishList = (List)importConflict.get("conflictPublish");
            ArrayList conflictThemeResult = new ArrayList(10);
            ArrayList conflictPublishResult = new ArrayList(10);
            for (i = 0; i < conflictExportThemeList.size(); ++i) {
                map = new HashMap<String, String>();
                ExportThemeVO conflictExportTheme = (ExportThemeVO)conflictExportThemeList.get(i);
                map.put("themeType", conflictExportTheme.getThemeType());
                map.put("themeGroupoId", conflictExportTheme.getThemeGroupID());
                map.put(THEME_ID, conflictExportTheme.getThemeID());
                map.put("themeGroupName", conflictExportTheme.getThemeGroupName());
                map.put(THEME_NAME, conflictExportTheme.getThemeName());
                conflictThemeResult.add(map);
            }
            for (i = 0; i < conflictPublishList.size(); ++i) {
                map = new HashMap();
                ExportPublishConflictVO conflictPublish = (ExportPublishConflictVO)conflictPublishList.get(i);
                map.put(THEME_NAME, conflictPublish.getThemeName());
                map.put("themeType", conflictPublish.getThemeType());
                map.put("publishPath", conflictPublish.getPublishPath());
                conflictPublishResult.add(map);
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("conflictTheme", conflictThemeResult);
            result.put("conflictPublish", conflictPublishResult);
            result.put("cacheMapIdKey", importConflict.get("cacheIdKey"));
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(result);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            byArray = ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            byte[] byArray3;
            try {
                byArray3 = ResponseUtil.output((Exception)e);
            }
            catch (Throwable throwable) {
                QingEncryptedStreamUtil.clearEncryptedFlag();
                CloseUtil.close((Closeable[])new Closeable[]{zis});
                throw throwable;
            }
            QingEncryptedStreamUtil.clearEncryptedFlag();
            CloseUtil.close((Closeable[])new Closeable[]{zis});
            return byArray3;
        }
        QingEncryptedStreamUtil.clearEncryptedFlag();
        CloseUtil.close((Closeable[])new Closeable[]{zis});
        return byArray;
    }

    @BehaviorAssociate(behavior=true)
    public byte[] writeZip(Map<String, String> params) {
        try {
            String fileName = this.getExportPKGDomain().doExport(params);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)fileName);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] checkThemePermission(String themeId) {
        try {
            this.getThemeDomain().checkThemePermission(themeId);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)true));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] isCurrentUserInQingAdminRole(Map<String, String> params) {
        try {
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)IntegratedHelper.isCurrentUserInQingAdminRole((QingContext)this.context, (IDBExcuter)this.dbExcuter)));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadUnReadHandOverOperationRecord(Map<String, String> params) {
        try {
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(this.getHandOverDomain().loadUnReadHandOverOperationRecord(null, MessageReadFlagEnum.UNREAD.getIsRead())));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] queryImportantUnReadMessage(Map<String, String> params) {
        String userId = this.context.getUserId();
        try {
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)this.getMessageDomain().queryUnReadMessageDetailList(userId, MessageLevelTypeEnum.MAJOR_LEVEL.getMessageLevel())));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }
}

