/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.manage.dao.impl;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.manage.dao.IEntityQSFileDao;
import com.kingdee.bos.qing.manage.model.EntityQSFilePO;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.StringUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class EntityQSFileDaoImpl
implements IEntityQSFileDao {
    private IDBExcuter dbExcuter;
    private static final String TABLE_NAME = "T_QING_ENTITY_QS_FILE";
    private static final String COLUMN = "FID,FORIGINALFILENAME,FORIGINALFILETYPE,FORIGINALENTITYNAME,FSOURCEID,FSOURCETYPE,FQSFILENAME,FQSFILETYPE";
    private static final String INSERT = "INSERT INTO T_QING_ENTITY_QS_FILE (FID,FORIGINALFILENAME,FORIGINALFILETYPE,FORIGINALENTITYNAME,FSOURCEID,FSOURCETYPE,FQSFILENAME,FQSFILETYPE) VALUES (?,?,?,?,?,?,?,?)";
    private static final String GET_ENTITY_FILE = "SELECT FID,FORIGINALFILENAME,FORIGINALFILETYPE,FORIGINALENTITYNAME,FSOURCEID,FSOURCETYPE,FQSFILENAME,FQSFILETYPE FROM T_QING_ENTITY_QS_FILE WHERE  FORIGINALFILENAME = ? AND FORIGINALENTITYNAME = ?";
    private static final String DELETE_BY_ID = "DELETE FROM T_QING_ENTITY_QS_FILE WHERE FID = ?";
    private static final String QUERY_IN_RESOURCE_FILE_NAME = "SELECT FID,FORIGINALFILENAME,FORIGINALFILETYPE,FORIGINALENTITYNAME,FSOURCEID,FSOURCETYPE,FQSFILENAME,FQSFILETYPE FROM T_QING_ENTITY_QS_FILE WHERE FORIGINALFILENAME IN ";

    public EntityQSFileDaoImpl(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    @Override
    public void insert(EntityQSFilePO entityQSFilePO) throws AbstractQingIntegratedException, SQLException {
        String fid = this.dbExcuter.genStringId(TABLE_NAME);
        Object[] params = new Object[]{fid, entityQSFilePO.getOriginalFileName(), entityQSFilePO.getOriginalFileType(), entityQSFilePO.getOriginalEntityName(), entityQSFilePO.getSourceId(), entityQSFilePO.getSourceType(), entityQSFilePO.getQsFileName(), entityQSFilePO.getQsFileType()};
        this.dbExcuter.execute(INSERT, params);
    }

    @Override
    public EntityQSFilePO getEntityFile(String resourceFileName, String entityName) throws AbstractQingIntegratedException, SQLException {
        if (StringUtils.isBlank((CharSequence)resourceFileName) || StringUtils.isBlank((CharSequence)entityName)) {
            return null;
        }
        Object[] params = new Object[]{resourceFileName, entityName};
        return (EntityQSFilePO)this.dbExcuter.query(GET_ENTITY_FILE, params, (ResultHandler)new ResultHandler<EntityQSFilePO>(){

            public EntityQSFilePO handle(ResultSet rs) throws SQLException {
                EntityQSFilePO entityQSFile = null;
                while (rs.next()) {
                    entityQSFile = EntityQSFileDaoImpl.this.buildEntityQSFilePO(rs);
                }
                return entityQSFile;
            }
        });
    }

    private EntityQSFilePO buildEntityQSFilePO(ResultSet rs) throws SQLException {
        EntityQSFilePO entityQSFilePO = new EntityQSFilePO();
        entityQSFilePO.setId(rs.getString("FID"));
        entityQSFilePO.setOriginalFileName(rs.getString("FORIGINALFILENAME"));
        entityQSFilePO.setOriginalFileType(rs.getString("FORIGINALFILETYPE"));
        entityQSFilePO.setOriginalEntityName(rs.getString("FORIGINALENTITYNAME"));
        entityQSFilePO.setSourceId(rs.getString("FSOURCEID"));
        entityQSFilePO.setSourceType(rs.getString("FSOURCETYPE"));
        entityQSFilePO.setQsFileName(rs.getString("FQSFILENAME"));
        entityQSFilePO.setQsFileType(rs.getString("FQSFILETYPE"));
        return entityQSFilePO;
    }

    @Override
    public void deleteById(String fid) throws AbstractQingIntegratedException, SQLException {
        Object[] params = new Object[]{fid};
        this.dbExcuter.execute(DELETE_BY_ID, params);
    }

    @Override
    public List<EntityQSFilePO> queryByResourceFileNameSet(Set<String> resourceFileNameSet) throws AbstractQingIntegratedException, SQLException {
        if (CollectionUtils.isEmpty(resourceFileNameSet)) {
            return null;
        }
        Object[] params = resourceFileNameSet.toArray();
        String sql = this.getInSQL(resourceFileNameSet);
        return (List)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<List<EntityQSFilePO>>(){

            public List<EntityQSFilePO> handle(ResultSet rs) throws SQLException {
                ArrayList<EntityQSFilePO> resultList = new ArrayList<EntityQSFilePO>(10);
                while (rs.next()) {
                    resultList.add(EntityQSFileDaoImpl.this.buildEntityQSFilePO(rs));
                }
                return resultList;
            }
        });
    }

    private String getInSQL(Set<String> resourceFileNameSet) {
        StringBuilder stringBuilder = new StringBuilder(QUERY_IN_RESOURCE_FILE_NAME).append("(");
        int size = resourceFileNameSet.size();
        for (int i = 0; i < size; ++i) {
            if (i != size - 1) {
                stringBuilder.append(" ?, ");
                continue;
            }
            stringBuilder.append(" ? ");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

