/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.manage.handover.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.common.lock.ILock;
import com.kingdee.bos.qing.common.lock.LockFactory;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.common.systemvar.SystemVarType;
import com.kingdee.bos.qing.core.exception.PersistentModelTooModernException;
import com.kingdee.bos.qing.dashboard.domain.DashboardDesignDomain;
import com.kingdee.bos.qing.dashboard.exception.PersistentModelParseException;
import com.kingdee.bos.qing.dashboard.model.DashboardModel;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.model.designtime.Box;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileUpdater;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.filesystem.manager.model.ResourceFromType;
import com.kingdee.bos.qing.filesystem.stream.QingEncryptedStreamUtil;
import com.kingdee.bos.qing.imagelibrary.dao.ImageLibraryDao;
import com.kingdee.bos.qing.imagelibrary.exception.GroupDuplicateNameException;
import com.kingdee.bos.qing.imagelibrary.model.ImageModel;
import com.kingdee.bos.qing.manage.dao.IThemeDao;
import com.kingdee.bos.qing.manage.dao.IThemeGroupDao;
import com.kingdee.bos.qing.manage.dao.impl.ThemeDaoImpl;
import com.kingdee.bos.qing.manage.dao.impl.ThemeGroupDaoImpl;
import com.kingdee.bos.qing.manage.domain.impl.SubjectManageDomain;
import com.kingdee.bos.qing.manage.exception.EncryptedLicenseCheckException;
import com.kingdee.bos.qing.manage.exception.ThemeGroupDuplicateNameException;
import com.kingdee.bos.qing.manage.handover.dao.HandOverDao;
import com.kingdee.bos.qing.manage.handover.exception.HandOverEncryptedLicenseException;
import com.kingdee.bos.qing.manage.handover.exception.HandOverException;
import com.kingdee.bos.qing.manage.handover.exception.HandOverNotGetLappOpenIdException;
import com.kingdee.bos.qing.manage.handover.exception.HandOverNotInQingAdminRoleException;
import com.kingdee.bos.qing.manage.handover.exception.HandOverQingFileStorageLimitException;
import com.kingdee.bos.qing.manage.handover.exception.HandOverSourceNotExistException;
import com.kingdee.bos.qing.manage.handover.exception.IsInHandOveringException;
import com.kingdee.bos.qing.manage.handover.exception.NothingToHandOverException;
import com.kingdee.bos.qing.manage.handover.model.HandOverOpeation;
import com.kingdee.bos.qing.manage.handover.model.HandOverPublish;
import com.kingdee.bos.qing.manage.handover.model.HandOverRecordOperationVO;
import com.kingdee.bos.qing.manage.handover.model.HandOverRecordVO;
import com.kingdee.bos.qing.manage.handover.model.HandOverSource;
import com.kingdee.bos.qing.manage.handover.model.HandOverVO;
import com.kingdee.bos.qing.manage.handover.model.PublishTypeEnum;
import com.kingdee.bos.qing.manage.handover.model.SourceTypeEnum;
import com.kingdee.bos.qing.manage.model.ThemeGroupPO;
import com.kingdee.bos.qing.manage.model.ThemeGroupVO;
import com.kingdee.bos.qing.manage.model.ThemePO;
import com.kingdee.bos.qing.manage.model.ThemeVO;
import com.kingdee.bos.qing.message.domain.MessageDomain;
import com.kingdee.bos.qing.message.exception.MessageException;
import com.kingdee.bos.qing.message.exception.MessageParamErrorException;
import com.kingdee.bos.qing.message.model.BizTypeEnum;
import com.kingdee.bos.qing.message.model.MessageLevelTypeEnum;
import com.kingdee.bos.qing.message.model.MessageTypeEnum;
import com.kingdee.bos.qing.message.model.vo.SaveMessageVo;
import com.kingdee.bos.qing.publish.dao.PublishInfoDao;
import com.kingdee.bos.qing.publish.domain.CommonPublishDomain;
import com.kingdee.bos.qing.publish.exception.PublishNotFoundException;
import com.kingdee.bos.qing.publish.exception.PublishScheduleModelException;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.target.AbstractPublishTargetDomain;
import com.kingdee.bos.qing.publish.target.PublishTargetDomainFactory;
import com.kingdee.bos.qing.publish.target.email.dao.EmailSenderDao;
import com.kingdee.bos.qing.publish.target.email.domain.EmailConfigManageDomain;
import com.kingdee.bos.qing.publish.target.email.model.EmailConfig;
import com.kingdee.bos.qing.publish.target.email.model.EmailSenderVO;
import com.kingdee.bos.qing.publish.target.lapp.dao.LappDao;
import com.kingdee.bos.qing.publish.target.lapp.model.LappSchedulePushConfigModel;
import com.kingdee.bos.qing.publish.target.lapp.strategy.ILappStrategy;
import com.kingdee.bos.qing.publish.thumbnail.domain.ThumbnailDomain;
import com.kingdee.bos.qing.publish.thumbnail.model.ThumbnailInfo;
import com.kingdee.bos.qing.publish.util.PublishUtil;
import com.kingdee.bos.qing.resource.AbstractResourceManager;
import com.kingdee.bos.qing.resource.ResourceManagerFactory;
import com.kingdee.bos.qing.resource.domain.ResourceInfoDomain;
import com.kingdee.bos.qing.resource.exception.ResourceManagementException;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.schedule.exception.ScheduleEngineException;
import com.kingdee.bos.qing.schedule.exception.ScheduleModelParseException;
import com.kingdee.bos.qing.schedule.model.AbstractJobParam;
import com.kingdee.bos.qing.schedule.model.Schedule;
import com.kingdee.bos.qing.schema.dao.SchemaManageDao;
import com.kingdee.bos.qing.schema.model.SchemaBO;
import com.kingdee.bos.qing.subject.dao.ISubjectDao;
import com.kingdee.bos.qing.subject.dao.impl.SubjectDaoImpl;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HandOverDomain {
    private QingContext qingContext;
    private ITransactionManagement tx;
    private IDBExcuter dbExcuter;
    private IScheduleEngine scheduleEngine;
    private ResourceInfoDomain resourceInfoDomain;
    private CommonPublishDomain commonPublishDomain;
    private EmailConfigManageDomain emailConfigManageDomain;
    private DashboardDesignDomain dashboardDesignDomain;
    private MessageDomain messageDomain;
    private SubjectManageDomain subjectManageDomain;
    private HandOverDao handOverDao;
    private IThemeGroupDao themeGroupDao;
    private IThemeDao iThemeDao;
    private ISubjectDao iSubjectDao;
    private LappDao lappDao;
    private ImageLibraryDao imageLibraryDao;
    private PublishInfoDao publishInfoDao;
    private ThumbnailDomain thumbnailDomain;
    private SchemaManageDao schemaDao;
    private EmailSenderDao emailSenderDao;
    private String handOverOpeationId;
    private static final String HAND_OVER_LOCK_KEY = "hand_over_lock_key_";
    private static final String HAS_DELETED = "hasDeleted";

    public HandOverDomain(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter, IScheduleEngine scheduleEngine) {
        this.qingContext = qingContext;
        this.tx = tx;
        this.dbExcuter = dbExcuter;
        this.scheduleEngine = scheduleEngine;
    }

    private HandOverDao getHandOverDao() {
        if (this.handOverDao == null) {
            this.handOverDao = new HandOverDao(this.qingContext, this.dbExcuter);
        }
        return this.handOverDao;
    }

    private IThemeGroupDao getThemeGroupDao() {
        if (this.themeGroupDao == null) {
            this.themeGroupDao = new ThemeGroupDaoImpl(this.dbExcuter);
        }
        return this.themeGroupDao;
    }

    private IThemeDao getThemeDao() {
        if (this.iThemeDao == null) {
            this.iThemeDao = new ThemeDaoImpl(this.dbExcuter);
        }
        return this.iThemeDao;
    }

    private ResourceInfoDomain getResourceInfoDomain() {
        if (this.resourceInfoDomain == null) {
            AbstractResourceManager resourceManager = ResourceManagerFactory.createResourceManager((QingContext)this.qingContext);
            this.resourceInfoDomain = new ResourceInfoDomain(resourceManager);
        }
        return this.resourceInfoDomain;
    }

    private CommonPublishDomain getCommonPublishDomain() {
        if (this.commonPublishDomain == null) {
            this.commonPublishDomain = new CommonPublishDomain(this.qingContext, this.tx, this.dbExcuter);
        }
        return this.commonPublishDomain;
    }

    private EmailConfigManageDomain getPublishManageDomain() {
        if (this.emailConfigManageDomain == null) {
            this.emailConfigManageDomain = new EmailConfigManageDomain(this.qingContext, this.tx, this.dbExcuter, null);
        }
        return this.emailConfigManageDomain;
    }

    private MessageDomain getMessageDomain() {
        if (this.messageDomain == null) {
            this.messageDomain = new MessageDomain(this.qingContext, this.tx, this.dbExcuter);
        }
        return this.messageDomain;
    }

    private SubjectManageDomain getSubjectManageDomain() {
        if (this.subjectManageDomain == null) {
            this.subjectManageDomain = new SubjectManageDomain(this.qingContext, this.tx, this.dbExcuter, null);
        }
        return this.subjectManageDomain;
    }

    private ISubjectDao getSubjectDao() {
        if (this.iSubjectDao == null) {
            this.iSubjectDao = new SubjectDaoImpl(this.dbExcuter);
        }
        return this.iSubjectDao;
    }

    private LappDao getLappDao() {
        if (this.lappDao == null) {
            this.lappDao = new LappDao(this.dbExcuter);
        }
        return this.lappDao;
    }

    private DashboardDesignDomain getDashboardDesignDomain() {
        if (this.dashboardDesignDomain == null) {
            this.dashboardDesignDomain = new DashboardDesignDomain(this.qingContext, this.tx, this.dbExcuter, null);
        }
        return this.dashboardDesignDomain;
    }

    private ImageLibraryDao getImageLibraryDao() {
        if (this.imageLibraryDao == null) {
            this.imageLibraryDao = new ImageLibraryDao(this.dbExcuter);
        }
        return this.imageLibraryDao;
    }

    private PublishInfoDao getPublishInfoDao() {
        if (this.publishInfoDao == null) {
            this.publishInfoDao = new PublishInfoDao(this.dbExcuter);
        }
        return this.publishInfoDao;
    }

    public ThumbnailDomain getThumbnailDomain() {
        if (this.thumbnailDomain == null) {
            this.thumbnailDomain = new ThumbnailDomain(this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine);
        }
        return this.thumbnailDomain;
    }

    private SchemaManageDao getSchemaDao() {
        if (this.schemaDao == null) {
            this.schemaDao = new SchemaManageDao(this.dbExcuter);
        }
        return this.schemaDao;
    }

    private EmailSenderDao getEmailSenderDao() {
        if (this.emailSenderDao == null) {
            this.emailSenderDao = new EmailSenderDao(this.dbExcuter);
        }
        return this.emailSenderDao;
    }

    public List<HandOverVO> queryDataByUserId(String userId) throws AbstractQingIntegratedException, SQLException {
        ArrayList<HandOverVO> handOverVOs = new ArrayList<HandOverVO>(10);
        ArrayList<String> publishIds = new ArrayList<String>(16);
        List<HandOverVO> ownPublishHandOver = this.getHandOverDao().queryOwnThemePublishDataByUserId(userId);
        HashMap<String, List<HandOverVO>> publishHandOverMap = new HashMap<String, List<HandOverVO>>(16);
        this.buildPublishIdAndHandOverMap(publishIds, ownPublishHandOver, publishHandOverMap);
        this.getResultHandOver(publishIds, ownPublishHandOver, publishHandOverMap);
        List<HandOverVO> indirectPublishHandOver = this.getHandOverDao().queryIndirectThemePublishDataByUserId(userId);
        publishIds.clear();
        publishHandOverMap.clear();
        this.buildPublishIdAndHandOverMap(publishIds, indirectPublishHandOver, publishHandOverMap);
        this.getResultHandOver(publishIds, indirectPublishHandOver, publishHandOverMap);
        List<HandOverVO> embeddedPublishHandOver = this.getHandOverDao().queryEmbeddedPublishDataByUserId(userId);
        publishIds.clear();
        publishHandOverMap.clear();
        this.buildPublishIdAndHandOverMap(publishIds, embeddedPublishHandOver, publishHandOverMap);
        this.getResultHandOver(publishIds, embeddedPublishHandOver, publishHandOverMap);
        List<HandOverVO> ownPushHandOver = this.queryOwnThemePushDataByUserId(userId);
        List<HandOverVO> indirectPushHandOver = this.getHandOverDao().queryIndirectThemePushDataByUserId(userId);
        List<HandOverVO> embeddedPushHandOver = this.getHandOverDao().queryEmbeddedPushDataByUserId(userId);
        handOverVOs.addAll(ownPublishHandOver);
        handOverVOs.addAll(indirectPublishHandOver);
        handOverVOs.addAll(embeddedPublishHandOver);
        handOverVOs.addAll(ownPushHandOver);
        handOverVOs.addAll(indirectPushHandOver);
        handOverVOs.addAll(embeddedPushHandOver);
        Collections.sort(handOverVOs);
        this.cleanList(handOverVOs);
        return handOverVOs;
    }

    private List<HandOverVO> queryOwnThemePushDataByUserId(String userId) throws AbstractQingIntegratedException, SQLException {
        HashSet<HandOverVO> voSet = new HashSet<HandOverVO>(10);
        voSet.addAll(this.getHandOverDao().queryThemeEmailPush(userId));
        voSet.addAll(this.getHandOverDao().queryPublishEmailPush(userId));
        voSet.addAll(this.getHandOverDao().queryThemeLappPush(userId));
        voSet.addAll(this.getHandOverDao().queryPublishLappPush(userId));
        ArrayList<HandOverVO> voList = new ArrayList<HandOverVO>(voSet);
        return voList;
    }

    private void getResultHandOver(List<String> publishIds, List<HandOverVO> ownPublishHandOver, Map<String, List<HandOverVO>> ownPublishHandOverMap) throws AbstractQingIntegratedException, SQLException {
        if (CollectionUtils.isEmpty(publishIds)) {
            return;
        }
        List<String> ownNotExistsPublishIds = this.getHandOverDao().queryPublishIdsFromPushRecored(publishIds);
        for (String string : ownNotExistsPublishIds) {
            ownPublishHandOverMap.remove(string);
        }
        ownPublishHandOver.clear();
        for (Map.Entry entry : ownPublishHandOverMap.entrySet()) {
            ownPublishHandOver.addAll((Collection)entry.getValue());
        }
    }

    private void buildPublishIdAndHandOverMap(List<String> publishIds, List<HandOverVO> ownPublishHandOver, Map<String, List<HandOverVO>> ownPublishHandOverMap) {
        for (HandOverVO handOverVO : ownPublishHandOver) {
            if ("2".equals(handOverVO.getPublishToType())) {
                publishIds.add(handOverVO.getPubId());
            }
            if (ownPublishHandOverMap.get(handOverVO.getPubId()) == null) {
                ownPublishHandOverMap.put(handOverVO.getPubId(), new ArrayList(16));
            }
            ownPublishHandOverMap.get(handOverVO.getPubId()).add(handOverVO);
        }
    }

    public Set<String> handOver(List<HandOverVO> handOverVOs, String toUserId, String publishedRuntimeUrl, String paramPathPrefix, Map<String, String> publishAppTypeMap) throws AbstractQingIntegratedException, HandOverException {
        String userId = this.qingContext.getUserId();
        if (!IntegratedHelper.isUserInQingAdminRole((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (String)userId)) {
            throw new HandOverNotInQingAdminRoleException();
        }
        ArrayList<String> dataModelingQSGarbage = new ArrayList<String>();
        ILock lock = null;
        try {
            QingEncryptedStreamUtil.setEncryptedFlag((QingEncryptedStreamUtil.EncryptedType)QingEncryptedStreamUtil.EncryptedType.HANDOVER);
            String owerUserId = handOverVOs.get(0).getSourceCreatorId();
            lock = LockFactory.createLock((String)(HAND_OVER_LOCK_KEY + owerUserId));
            boolean falg = lock.tryLock(1000L);
            if (falg) {
                this.tx.beginRequired();
                HandOverOpeation handOverOpeation = new HandOverOpeation();
                handOverOpeation.setCreatorId(userId);
                handOverOpeation.setFromUserId(owerUserId);
                handOverOpeation.setToUserId(toUserId);
                this.handOverOpeationId = this.getHandOverDao().insertHandOverOpeation(handOverOpeation);
                HashMap<Integer, List<String>> handOverNameMap = new HashMap<Integer, List<String>>();
                Set<String> handOverLappPublishIds = this.doHandOver(handOverVOs, toUserId, publishedRuntimeUrl, paramPathPrefix, publishAppTypeMap, owerUserId, handOverNameMap, dataModelingQSGarbage);
                StringBuilder handOverSourceNames = new StringBuilder();
                int countNum = 0;
                int totalNum = handOverVOs.size();
                for (int i = 0; i < handOverVOs.size() && countNum < 3; ++i) {
                    List handOverNameList;
                    HandOverVO handOverVO = handOverVOs.get(i);
                    if (StringUtils.isNotEmpty((CharSequence)handOverVO.getSourceName()) && !HAS_DELETED.equals(handOverVO.getSourceName())) {
                        handOverSourceNames.append("\u201c").append(handOverVO.getSourceName()).append("\u201d\u3001");
                        ++countNum;
                    }
                    if (!CollectionUtils.isNotEmpty((Collection)(handOverNameList = (List)handOverNameMap.get(i)))) continue;
                    totalNum += handOverNameList.size();
                    for (int j = 0; j < handOverNameList.size() && countNum < 3; ++j, ++countNum) {
                        handOverSourceNames.append("\u201c").append((String)handOverNameList.get(j)).append("\u201d\u3001");
                    }
                }
                if (handOverSourceNames.length() > 0) {
                    handOverSourceNames.delete(handOverSourceNames.length() - 1, handOverSourceNames.length());
                }
                String messageTitleTo = Messages.getMLS((QingContext)this.qingContext, (String)"messageTitleHandOverTo", (String)"\u8f7b\u5206\u6790\u7ba1\u7406\u5458\u201c$param1\u201d\u5411\u60a8\u79fb\u4ea4\u4e86$param2", (Messages.ProjectName)Messages.ProjectName.QING_THEME).replace("$param1", IntegratedHelper.getUserName((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (String)userId)).replace("$param2", handOverSourceNames);
                String messageTitleFrom = Messages.getMLS((QingContext)this.qingContext, (String)"messageTitleHandOverFrom", (String)"\u8f7b\u5206\u6790\u7ba1\u7406\u5458\u201c$param1\u201d\u5c06$param2", (Messages.ProjectName)Messages.ProjectName.QING_THEME).replace("$param1", IntegratedHelper.getUserName((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (String)userId)).replace("$param2", handOverSourceNames);
                if (totalNum > 3) {
                    messageTitleTo = messageTitleTo + Messages.getMLS((QingContext)this.qingContext, (String)"messageTitleHandOverCommon", (String)"\u7b49$param3\u9879\u5185\u5bb9", (Messages.ProjectName)Messages.ProjectName.QING_THEME).replace("$param3", totalNum + "");
                    messageTitleFrom = messageTitleFrom + Messages.getMLS((QingContext)this.qingContext, (String)"messageTitleHandOverCommon", (String)"\u7b49$param3\u9879\u5185\u5bb9", (Messages.ProjectName)Messages.ProjectName.QING_THEME).replace("$param3", totalNum + "");
                }
                messageTitleFrom = messageTitleFrom + Messages.getMLS((QingContext)this.qingContext, (String)"messageTitleHandOverToUser", (String)"\u79fb\u4ea4\u7ed9\u4e86\u201c$param4\u201d", (Messages.ProjectName)Messages.ProjectName.QING_THEME).replace("$param4", IntegratedHelper.getUserName((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (String)toUserId));
                this.saveMessage(toUserId, messageTitleTo);
                this.saveMessage(owerUserId, messageTitleFrom);
                Set<String> set = handOverLappPublishIds;
                return set;
            }
            try {
                throw new IsInHandOveringException();
            }
            catch (AbstractQingIntegratedException e) {
                this.tx.markRollback();
                throw e;
            }
            catch (SQLException e) {
                this.tx.markRollback();
                throw new HandOverException(e);
            }
            catch (HandOverException e) {
                this.tx.markRollback();
                throw e;
            }
            catch (Exception e) {
                this.tx.markRollback();
                throw new HandOverException(e);
            }
        }
        finally {
            this.tx.end();
            QingEncryptedStreamUtil.clearEncryptedFlag();
            this.clearDataModelingQSGarbage(dataModelingQSGarbage);
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    private void clearDataModelingQSGarbage(List<String> dataModelingQSGarbage) {
        for (String filePath : dataModelingQSGarbage) {
            IQingFileUpdater fileUpdater = FileFactory.newFileUpdater((QingContext)this.qingContext, (AbstractQingFileType)QingPersistentFileType.DATAMODELING_QS, (String)filePath);
            fileUpdater.delete();
        }
    }

    private void saveMessage(String toUserId, String messageTitle) throws AbstractQingIntegratedException, SQLException, MessageParamErrorException {
        ArrayList<String> messageReceiverIdList = new ArrayList<String>();
        messageReceiverIdList.add(toUserId);
        SaveMessageVo saveMessageVo = new SaveMessageVo();
        saveMessageVo.setMessageLevel(MessageLevelTypeEnum.NORMAL_LEVEL);
        saveMessageVo.setMessageType(MessageTypeEnum.BIZ_NEWS);
        saveMessageVo.setMessageTitle(messageTitle);
        saveMessageVo.setBizId(this.handOverOpeationId);
        saveMessageVo.setBizType(BizTypeEnum.HAND_OVER_NEWS);
        saveMessageVo.setReceiverIdList(messageReceiverIdList);
        this.getMessageDomain().saveMessageNoTx(saveMessageVo);
    }

    private Set<String> doHandOver(List<HandOverVO> handOverVOs, String toUserId, String publishedRuntimeUrl, String paramPathPrefix, Map<String, String> publishAppTypeMap, String owerUserId, Map<Integer, List<String>> handOverNameMap, List<String> dataModelingQSGarbage) throws HandOverException, AbstractQingIntegratedException, SQLException {
        HashSet<String> lappPublishIds = new HashSet<String>(10);
        for (int i = 0; i < handOverVOs.size(); ++i) {
            Set<Object> handOverLappPublishIds = new HashSet(10);
            HandOverVO handOverVO = handOverVOs.get(i);
            String sourceType = handOverVO.getSourceType();
            ArrayList<String> handOverNameList = new ArrayList<String>();
            if (SourceTypeEnum.SUBJECT.getSourceType().equals(sourceType)) {
                handOverLappPublishIds = this.themeHandOver(handOverVO, toUserId, publishedRuntimeUrl, paramPathPrefix, publishAppTypeMap, owerUserId, handOverNameList, dataModelingQSGarbage);
            } else if (SourceTypeEnum.DSB.getSourceType().equals(sourceType)) {
                handOverLappPublishIds = this.dsbHandOver(handOverVO, toUserId, publishedRuntimeUrl, paramPathPrefix, publishAppTypeMap, owerUserId, handOverNameList, dataModelingQSGarbage);
            } else if (SourceTypeEnum.PUBLISH.getSourceType().equals(sourceType)) {
                handOverLappPublishIds = this.publishHandOver(handOverVO, toUserId, publishedRuntimeUrl, paramPathPrefix, publishAppTypeMap, owerUserId, handOverNameList);
            } else if (SourceTypeEnum.BILL.getSourceType().equals(sourceType) || sourceType == null) {
                handOverLappPublishIds = this.publishPushHandOver(handOverVO, toUserId, publishedRuntimeUrl, paramPathPrefix, publishAppTypeMap, owerUserId, handOverNameList);
            }
            lappPublishIds.addAll(handOverLappPublishIds);
            handOverNameMap.put(i, handOverNameList);
        }
        return lappPublishIds;
    }

    private Set<String> themeHandOver(HandOverVO handOverVO, String toUserId, String publishedRuntimeUrl, String paramPathPrefix, Map<String, String> publishAppTypeMap, String owerUserId, List<String> handOverNameList, List<String> dataModelingQSGarbage) throws AbstractQingIntegratedException, SQLException, HandOverException {
        String hoSourceId = this.updateThemeUserId(handOverVO, toUserId, dataModelingQSGarbage);
        this.getHandOverDao().updateSubjectSchemaUserId(handOverVO, toUserId);
        Set<String> lappPublishIds = this.updatePublishByTagId(handOverVO, toUserId, hoSourceId, publishAppTypeMap, owerUserId, publishedRuntimeUrl, paramPathPrefix, handOverNameList);
        this.updateEmailPush(handOverVO, toUserId, hoSourceId, publishedRuntimeUrl, owerUserId, handOverNameList);
        this.updateLappPush(handOverVO, toUserId, hoSourceId, paramPathPrefix, owerUserId, handOverNameList);
        return lappPublishIds;
    }

    private Set<String> publishHandOver(HandOverVO handOverVO, String toUserId, String publishedRuntimeUrl, String paramPathPrefix, Map<String, String> publishAppTypeMap, String owerUserId, List<String> handOverNameList) throws AbstractQingIntegratedException, SQLException, HandOverException {
        if (!this.checkPushOrPubExist(handOverVO, owerUserId)) {
            throw new NothingToHandOverException();
        }
        HandOverSource handOverSource = new HandOverSource();
        handOverSource.setOperationId(this.handOverOpeationId);
        handOverSource.setSourceId(handOverVO.getSourceId());
        handOverSource.setSourceNewName(HAS_DELETED.equals(handOverVO.getSourceName()) ? null : handOverVO.getSourceName());
        handOverSource.setSourceOldName(HAS_DELETED.equals(handOverVO.getSourceName()) ? null : handOverVO.getSourceName());
        handOverSource.setSourcePathId(handOverVO.getSourcePathId());
        handOverSource.setSourcePathName(handOverVO.getSourcePathName());
        handOverSource.setSourceType(StringUtils.isEmpty((CharSequence)handOverVO.getSourceType()) ? " " : handOverVO.getSourceType());
        String hoSourceId = this.getHandOverDao().insertHandOverSource(handOverSource);
        handOverVO.setSourceName(handOverSource.getSourceNewName());
        Set<String> lappPublishIds = this.updatePublishByTagId(handOverVO, toUserId, hoSourceId, publishAppTypeMap, owerUserId, publishedRuntimeUrl, paramPathPrefix, handOverNameList);
        return lappPublishIds;
    }

    private Set<String> dsbHandOver(HandOverVO handOverVO, String toUserId, String publishedRuntimeUrl, String paramPathPrefix, Map<String, String> publishAppTypeMap, String owerUserId, List<String> handOverNameList, List<String> dataModelingQSGarbage) throws AbstractQingIntegratedException, SQLException, HandOverException {
        String hoSourceId = this.updateThemeUserId(handOverVO, toUserId, dataModelingQSGarbage);
        Set<String> lappPublishIds = this.updatePublishByTagId(handOverVO, toUserId, hoSourceId, publishAppTypeMap, owerUserId, publishedRuntimeUrl, paramPathPrefix, handOverNameList);
        this.updateEmailPush(handOverVO, toUserId, hoSourceId, publishedRuntimeUrl, owerUserId, handOverNameList);
        this.updateLappPush(handOverVO, toUserId, hoSourceId, paramPathPrefix, owerUserId, handOverNameList);
        return lappPublishIds;
    }

    private Set<String> updatePublishByTagId(HandOverVO handOverVO, String toUserId, String hoSourceId, Map<String, String> publishAppTypeMap, String owerUserId, String publishedRuntimeUrl, String paramPathPrefix, List<String> handOverNameList) throws AbstractQingIntegratedException, SQLException, HandOverException {
        HashSet<String> lappPublishIds = new HashSet<String>(10);
        List publishPOList = new ArrayList(10);
        String sourceId = handOverVO.getSourceId();
        if (PublishUtil.isPublish((String)sourceId)) {
            this.updateEmailPush(handOverVO, toUserId, hoSourceId, publishedRuntimeUrl, owerUserId, handOverNameList);
            this.updateLappPush(handOverVO, toUserId, hoSourceId, paramPathPrefix, owerUserId, handOverNameList);
        } else {
            publishPOList = this.getCommonPublishDomain().loadPublishInfos(handOverVO.getSourceId(), handOverVO.getSourceCreatorId());
        }
        if (handOverNameList != null && CollectionUtils.isNotEmpty(publishPOList)) {
            for (PublishPO publishPO : publishPOList) {
                if (!PublishUtil.isPublish((String)publishPO.getId()) || publishPO.getPublishTargetType() == 2 || publishPO.getPublishTargetType() == 6) continue;
                handOverNameList.add(publishPO.getName());
            }
        }
        for (PublishPO publishPO : publishPOList) {
            AbstractPublishTargetDomain publishTargetDomain = PublishTargetDomainFactory.createPublishTargetDomain((QingContext)this.qingContext, (ITransactionManagement)this.tx, (IDBExcuter)this.dbExcuter, null, (Integer)publishPO.getPublishTargetType());
            if (publishTargetDomain == null) continue;
            String publishId = publishPO.getId();
            String pathName = publishTargetDomain.loadPathNamePOByPathId(publishPO.getPath());
            String publishPathId = publishTargetDomain.loadOrCreatePath(toUserId, publishPO.getPath(), pathName);
            String publishNewName = this.getPublishName(publishPO.getPublishTargetType(), publishPO.getName(), publishPO.getName(), publishPathId, toUserId, 0);
            this.getHandOverDao().updatePublishedUserId(publishId, publishPathId, publishNewName, toUserId);
            ArrayList<SchemaBO> owerSchemaList = this.getSchemaDao().loadSchemaAttrs(publishId, owerUserId);
            ArrayList<SchemaBO> toUserIdSchemaList = this.getSchemaDao().loadSchemaAttrs(publishId, toUserId);
            for (SchemaBO schemaBO : owerSchemaList) {
                boolean exist = false;
                for (SchemaBO toSchemaBO : toUserIdSchemaList) {
                    if (!toSchemaBO.getfId().equals(schemaBO.getfId())) continue;
                    exist = true;
                    break;
                }
                if (exist) continue;
                String schemaName = schemaBO.getSchemaName();
                ArrayList<SchemaBO> otherSchemaBOs = new ArrayList<SchemaBO>();
                otherSchemaBOs.addAll(owerSchemaList);
                otherSchemaBOs.addAll(toUserIdSchemaList);
                otherSchemaBOs.remove(schemaBO);
                HashSet<String> nameSet = new HashSet<String>(10);
                for (SchemaBO otherSchemaBO : otherSchemaBOs) {
                    nameSet.add(otherSchemaBO.getSchemaName());
                }
                String schemaNameNew = this.getNewName(schemaName, schemaName, 0, nameSet);
                if (!schemaNameNew.equals(schemaName)) {
                    this.getHandOverDao().updatePublishedSchemaName(schemaBO.getfId(), schemaNameNew);
                }
                this.getHandOverDao().updatePublishedSchemaUser(schemaBO.getfId(), toUserId, owerUserId);
            }
            String newPublishPathName = publishTargetDomain.loadPathNameByPath(publishPathId, publishId);
            if (publishPO.getPublishTargetType() != 6 && (publishPO.getPublishTargetType() != 2 || publishPO.getPath().equals("lightapp"))) {
                HandOverPublish handOverPublish = new HandOverPublish();
                handOverPublish.setHoSourceId(hoSourceId);
                handOverPublish.setPubId(publishPO.getId());
                handOverPublish.setPublishToType(publishPO.getPublishTargetType());
                handOverPublish.setPubNewName(publishNewName);
                handOverPublish.setPubOldName(publishPO.getName());
                handOverPublish.setPubPath(publishPathId);
                handOverPublish.setPubPathName(newPublishPathName);
                handOverPublish.setPubType(PublishTypeEnum.PUBLISH.name());
                this.getHandOverDao().insertHandOverPublish(handOverPublish);
            }
            if (publishPO.getPublishTargetType() != 2 || !publishPO.getPath().equals("lightapp")) continue;
            lappPublishIds.add(publishId);
            ILappStrategy lappStrategy = (ILappStrategy)CustomStrategyRegistrar.getStrategy(ILappStrategy.class);
            if (lappStrategy == null) {
                throw new RuntimeException("cannot found the implement of ILappStrategy.");
            }
            String appType = publishAppTypeMap.get(publishId);
            if (appType != null && !lappStrategy.hasConfigOpenIdByUserIdAndAppType(toUserId, appType, this.qingContext, this.dbExcuter, this.tx, this.scheduleEngine)) {
                throw new HandOverNotGetLappOpenIdException();
            }
            this.updateLappPublishThumbnailSchedule(publishPO, toUserId);
        }
        this.getHandOverDao().updatePublishFileResourceUserId(handOverVO.getSourceId(), toUserId);
        try {
            boolean isEnough = this.getResourceInfoDomain().getFileResourceDomain().isEnoughFileSize(0L, toUserId);
            if (!isEnough) {
                throw new HandOverQingFileStorageLimitException();
            }
        }
        catch (ResourceManagementException e) {
            throw new HandOverException(e);
        }
        return lappPublishIds;
    }

    private Set<String> publishPushHandOver(HandOverVO handOverVO, String toUserId, String publishedRuntimeUrl, String paramPathPrefix, Map<String, String> publishAppTypeMap, String owerUserId, List<String> handOverNameList) throws AbstractQingIntegratedException, SQLException, HandOverException {
        if (!this.checkPushOrPubExist(handOverVO, owerUserId)) {
            throw new NothingToHandOverException();
        }
        HandOverSource handOverSource = new HandOverSource();
        handOverSource.setOperationId(this.handOverOpeationId);
        handOverSource.setSourceId(handOverVO.getSourceId());
        handOverSource.setSourceNewName(HAS_DELETED.equals(handOverVO.getSourceName()) ? null : handOverVO.getSourceName());
        handOverSource.setSourceOldName(HAS_DELETED.equals(handOverVO.getSourceName()) ? null : handOverVO.getSourceName());
        handOverSource.setSourcePathId(handOverVO.getSourcePathId());
        handOverSource.setSourcePathName(handOverVO.getSourcePathName());
        handOverSource.setSourceType(StringUtils.isEmpty((CharSequence)handOverVO.getSourceType()) ? " " : handOverVO.getSourceType());
        String hoSourceId = this.getHandOverDao().insertHandOverSource(handOverSource);
        handOverVO.setSourceName(handOverSource.getSourceNewName());
        Set<String> lappPublishIds = this.updatePublishByTagId(handOverVO, toUserId, hoSourceId, publishAppTypeMap, owerUserId, publishedRuntimeUrl, paramPathPrefix, handOverNameList);
        this.updateEmailPush(handOverVO, toUserId, hoSourceId, publishedRuntimeUrl, owerUserId, handOverNameList);
        this.updateLappPush(handOverVO, toUserId, hoSourceId, paramPathPrefix, owerUserId, handOverNameList);
        return lappPublishIds;
    }

    private boolean checkPushOrPubExist(HandOverVO handOverVO, String fromUserId) throws AbstractQingIntegratedException, SQLException {
        List<EmailConfig> emailConfigs = this.getPublishManageDomain().loadEmailConfigsByBizId(handOverVO.getSourceId(), fromUserId);
        if (!emailConfigs.isEmpty()) {
            return true;
        }
        List<LappSchedulePushConfigModel> lappConfigs = this.getLappDao().loadConfigInfoByTagId(fromUserId, handOverVO.getSourceId());
        if (!lappConfigs.isEmpty()) {
            return true;
        }
        List publishPOList = this.getCommonPublishDomain().loadPublishInfos(handOverVO.getSourceId(), handOverVO.getSourceCreatorId());
        return !publishPOList.isEmpty();
    }

    private void updateEmailPush(HandOverVO handOverVO, String toUserId, String hoSourceId, String publishedRuntimeUrl, String owerUserId, List<String> handOverNameList) throws AbstractQingIntegratedException, SQLException, HandOverException {
        String senderId = null;
        List<EmailConfig> emailConfigs = this.getPublishManageDomain().loadEmailConfigsByBizId(handOverVO.getSourceId(), owerUserId);
        for (EmailConfig emailConfig : emailConfigs) {
            if (senderId == null) {
                EmailSenderVO toUserIdEmailSenderVO = this.getEmailSenderDao().getUserEmailSender(toUserId, false);
                if (toUserIdEmailSenderVO == null) {
                    EmailSenderVO owerUserIdEmailSenderVO = this.getEmailSenderDao().getUserEmailSender(owerUserId, false);
                    owerUserIdEmailSenderVO.setUserId(toUserId);
                    senderId = this.getEmailSenderDao().insert(owerUserIdEmailSenderVO);
                } else {
                    senderId = toUserIdEmailSenderVO.getId();
                }
            }
            this.getHandOverDao().updateEmailPushedUserId(emailConfig.getId(), toUserId, senderId);
            HandOverPublish handOverPublish = new HandOverPublish();
            handOverPublish.setHoSourceId(hoSourceId);
            handOverPublish.setPubId(emailConfig.getId());
            handOverPublish.setPublishToType(6);
            handOverPublish.setPubNewName(emailConfig.getNameRule().getName());
            handOverPublish.setPubOldName(emailConfig.getNameRule().getName());
            handOverPublish.setPubPath(null);
            handOverPublish.setPubPathName(null);
            handOverPublish.setPubType(PublishTypeEnum.PUSH.name());
            this.getHandOverDao().insertHandOverPublish(handOverPublish);
            handOverNameList.add(emailConfig.getNameRule().getName());
            if (!emailConfig.getScheduleSwitch()) continue;
            this.updateEmailPushSchedule(emailConfig, publishedRuntimeUrl, toUserId);
        }
    }

    private void updateLappPush(HandOverVO handOverVO, String toUserId, String hoSourceId, String paramPathPrefix, String owerUserId, List<String> handOverNameList) throws AbstractQingIntegratedException, SQLException, HandOverException {
        List<LappSchedulePushConfigModel> allConfigInfo = this.getLappDao().loadConfigInfoByTagId(owerUserId, handOverVO.getSourceId());
        for (int i = 0; i < allConfigInfo.size(); ++i) {
            LappSchedulePushConfigModel configInfo = allConfigInfo.get(i);
            this.getHandOverDao().updateLappPushUserId(configInfo, toUserId);
            this.getHandOverDao().updateLappPushRecordUserId(configInfo, toUserId);
            this.getHandOverDao().updateLappPushThumbnailFileResourceUserId(configInfo.getId(), toUserId);
            try {
                boolean isEnough = this.getResourceInfoDomain().getFileResourceDomain().isEnoughFileSize(0L, toUserId);
                if (!isEnough) {
                    throw new HandOverQingFileStorageLimitException();
                }
            }
            catch (ResourceManagementException e) {
                throw new HandOverException(e);
            }
            HandOverPublish handOverPublish = new HandOverPublish();
            handOverPublish.setHoSourceId(hoSourceId);
            handOverPublish.setPubId(configInfo.getId());
            handOverPublish.setPublishToType(2);
            handOverPublish.setPubNewName(configInfo.getName());
            handOverPublish.setPubOldName(configInfo.getName());
            handOverPublish.setPubPath(null);
            handOverPublish.setPubPathName(null);
            handOverPublish.setPubType(PublishTypeEnum.PUSH.name());
            this.getHandOverDao().insertHandOverPublish(handOverPublish);
            handOverNameList.add(configInfo.getName());
            if (!configInfo.isOpenSchedule()) continue;
            this.updateLappPushSchedule(configInfo, paramPathPrefix, toUserId);
        }
    }

    private void deleteSchedule(String pkId) throws HandOverException {
        try {
            this.scheduleEngine.deleteJob(this.qingContext, null, pkId);
        }
        catch (AbstractQingIntegratedException e) {
            throw new HandOverException(e);
        }
        catch (ScheduleEngineException e) {
            throw new HandOverException(e);
        }
    }

    private String updateThemeUserId(HandOverVO handOverVO, String toUserId, List<String> dataModelingQSGarbage) throws AbstractQingIntegratedException, SQLException, HandOverException {
        String themeNameNew;
        String themeName;
        String themeGroupId;
        String themeGroupName;
        block20: {
            ThemePO themePO = this.getThemeDao().getThemeByID(handOverVO.getSourceId());
            if (themePO == null) {
                throw new HandOverSourceNotExistException();
            }
            themeGroupName = handOverVO.getSourcePathName();
            ThemeGroupVO owerUserIdThemeGroupVO = this.getThemeGroupDao().loadThemeGroupByGroupId(themePO.getUserID(), themePO.getGroupID());
            if (owerUserIdThemeGroupVO != null) {
                themeGroupName = owerUserIdThemeGroupVO.getThemeGroupName();
            }
            ThemeGroupPO themeGroupPO = new ThemeGroupPO();
            themeGroupPO.setThemeGroupName(themeGroupName);
            themeGroupPO.setUserID(toUserId);
            themeGroupId = null;
            try {
                themeGroupId = this.getThemeGroupDao().saveThemeGroup(themeGroupPO);
            }
            catch (ThemeGroupDuplicateNameException e) {
                ThemeGroupVO toUserIdThemeGroupVO = this.getThemeGroupDao().loadThemeGroupByGroupName(toUserId, handOverVO.getSourcePathName());
                themeGroupId = toUserIdThemeGroupVO.getThemeGroupID();
            }
            themeName = themePO.getThemeName();
            String themeType = themePO.getThemeType();
            List<ThemeVO> themeVOs = this.getThemeDao().listThemesLikeName(toUserId, themeGroupId, themeName, themeType);
            HashSet<String> themeNameSet = new HashSet<String>(themeVOs.size());
            for (ThemeVO themeVO : themeVOs) {
                themeNameSet.add(themeVO.getThemeName());
            }
            themeNameNew = this.getNewName(themeName, themeName, 0, themeNameSet);
            this.getHandOverDao().updateThemeUserId(handOverVO.getSourceId(), themeGroupId, themeNameNew, toUserId);
            if (SourceTypeEnum.SUBJECT.getSourceType().equals(handOverVO.getSourceType())) {
                this.getHandOverDao().updateSubjectFileResourceUserId(handOverVO.getSourceId(), toUserId);
                try {
                    boolean isEnough = this.getResourceInfoDomain().getFileResourceDomain().isEnoughFileSize(0L, toUserId);
                    if (!isEnough) {
                        throw new HandOverQingFileStorageLimitException();
                    }
                }
                catch (ResourceManagementException e) {
                    throw new HandOverException(e);
                }
                this.updateSubjectSchedule(handOverVO, toUserId, themeNameNew, dataModelingQSGarbage);
            } else if (SourceTypeEnum.DSB.getSourceType().equals(handOverVO.getSourceType())) {
                try {
                    DashboardModel dashboardModel = this.getDashboardDesignDomain().loadModel(handOverVO.getSourceId());
                    if (dashboardModel == null) break block20;
                    List referenceMaps = dashboardModel.pickReferences();
                    int c = referenceMaps.size();
                    for (int i = 0; i < c; ++i) {
                        ImageModel imageModelToHandOver;
                        String imageName;
                        String categoryName;
                        String refToId;
                        ReferenceMap referenceMap = (ReferenceMap)referenceMaps.get(i);
                        String refType = referenceMap.getRefType();
                        if (RefTypeEnum.picture != RefTypeEnum.valueOf((String)refType) || !StringUtils.isNotBlank((CharSequence)(refToId = referenceMap.getRefToId())) || !StringUtils.isNotBlank((CharSequence)(categoryName = this.getImageLibraryDao().getCategoryName(refToId, handOverVO.getSourceCreatorId()))) || !StringUtils.isNotBlank((CharSequence)(imageName = (imageModelToHandOver = this.getImageLibraryDao().getImageModelByImageFileName(refToId)).getImageName()))) continue;
                        String categoryId = "";
                        try {
                            categoryId = this.getImageLibraryDao().saveOrUpdateCategory(toUserId, null, categoryName);
                        }
                        catch (GroupDuplicateNameException e) {
                            categoryId = this.getImageLibraryDao().getCategoryIdByName(categoryName, toUserId);
                        }
                        List<ImageModel> imageModels = this.getImageLibraryDao().getAllImageOfCategory(categoryId, toUserId);
                        HashSet<String> imageNameSet = new HashSet<String>(imageModels.size());
                        for (ImageModel imageModel : imageModels) {
                            String temp = imageModel.getImageName();
                            int idx = temp.lastIndexOf(46);
                            String imageSubName = temp.substring(0, idx);
                            imageNameSet.add(imageSubName);
                        }
                        int idx = imageName.lastIndexOf(46);
                        String imageSubName = imageName.substring(0, idx);
                        String imagePrefixName = imageName.substring(idx);
                        String newSubImageName = this.getNewName(imageSubName, imageSubName, 0, imageNameSet);
                        this.getHandOverDao().updateImageUserId(refToId, categoryId, newSubImageName + imagePrefixName, toUserId);
                        this.getHandOverDao().updateFileResourceUserId(imageModelToHandOver.getId(), ResourceFromType.IMAGELIBRARY, toUserId);
                        try {
                            boolean isEnough = this.getResourceInfoDomain().getFileResourceDomain().isEnoughFileSize(0L);
                            if (isEnough) continue;
                            throw new HandOverQingFileStorageLimitException();
                        }
                        catch (ResourceManagementException e) {
                            throw new HandOverException(e);
                        }
                    }
                }
                catch (PersistentModelParseException e) {
                    throw new HandOverException(e);
                }
                catch (EncryptedLicenseCheckException e) {
                    throw new HandOverEncryptedLicenseException(e.getMessage(), e.getErrorCode());
                }
            }
        }
        HandOverSource handOverSource = new HandOverSource();
        handOverSource.setOperationId(this.handOverOpeationId);
        handOverSource.setSourceId(handOverVO.getSourceId());
        handOverSource.setSourceNewName(themeNameNew);
        handOverSource.setSourceOldName(themeName);
        handOverSource.setSourcePathId(themeGroupId);
        handOverSource.setSourcePathName(themeGroupName);
        handOverVO.setSourceName(themeNameNew);
        handOverSource.setSourceType(StringUtils.isEmpty((CharSequence)handOverVO.getSourceType()) ? " " : handOverVO.getSourceType());
        String hoSourceId = this.getHandOverDao().insertHandOverSource(handOverSource);
        return hoSourceId;
    }

    private String getNewName(String oldName, String newName, int i, Set<String> haveNameSet) {
        if (haveNameSet.contains(newName)) {
            newName = oldName + "_" + ++i;
            return this.getNewName(oldName, newName, i, haveNameSet);
        }
        return newName;
    }

    private String getPublishName(int publishTargetType, String publishName, String publishNewName, String path, String toUserId, int i) throws AbstractQingIntegratedException, SQLException {
        boolean isNameExist = this.getPublishInfoDao().isNameExist(publishTargetType, publishNewName, path, toUserId);
        if (!isNameExist) {
            return publishNewName;
        }
        publishNewName = publishName + "_" + ++i;
        return this.getPublishName(publishTargetType, publishName, publishNewName, path, toUserId, i);
    }

    public List<HandOverRecordVO> queryHandOverRecords(List<HandOverVO> handOverVOs) throws AbstractQingIntegratedException, SQLException {
        if (handOverVOs.isEmpty()) {
            return new ArrayList<HandOverRecordVO>();
        }
        HandOverVO firstHandOverVO = handOverVOs.get(0);
        if (SourceTypeEnum.SUBJECT.getSourceType().equals(firstHandOverVO.getSourceType()) || SourceTypeEnum.DSB.getSourceType().equals(firstHandOverVO.getSourceType())) {
            return this.getHandOverDao().queryHandOverRecordsBySourceId(firstHandOverVO.getSourceId());
        }
        ArrayList<HandOverRecordVO> handOverRecordVO = new ArrayList<HandOverRecordVO>();
        HashSet<String> hoSourceIds = new HashSet<String>();
        for (HandOverVO handOverVO : handOverVOs) {
            hoSourceIds.addAll(this.getHandOverDao().queryHOSourceId(handOverVO.getPubId(), handOverVO.getPubType()));
        }
        Iterator iterator = hoSourceIds.iterator();
        while (iterator.hasNext()) {
            handOverRecordVO.addAll(this.getHandOverDao().queryHandOverRecordsByHOSourceId((String)iterator.next()));
        }
        return handOverRecordVO;
    }

    public void updateSubjectSchedule(HandOverVO handOverVO, String toUserId, String themeNameNew, List<String> dataModelingQSGarbage) throws AbstractQingIntegratedException, SQLException, HandOverException {
        try {
            Schedule schedule;
            Box box = this.getSubjectDao().loadSubjectModelIncludePreset(toUserId, handOverVO.getSourceId());
            if (box != null && (schedule = box.getSchedule()) != null && schedule.getPeriod() != null) {
                this.deleteSchedule(handOverVO.getSourceId());
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("JobType", "extractThemeData");
                params.put("themeId", handOverVO.getSourceId());
                params.put("userId", toUserId);
                params.put("name", themeNameNew);
                params.put("pkId", handOverVO.getSourceId());
                AbstractJobParam jobParams = this.scheduleEngine.createJobParam(params);
                String scheduleName = this.scheduleEngine.getScheduleName();
                this.scheduleEngine.saveJob(this.qingContext, toUserId, this.qingContext.getSystemVarStringValue(SystemVarType.ORG_ID), this.qingContext.getTenantId(), scheduleName, schedule, jobParams);
                this.getSubjectManageDomain().collectScheduleFileAndRecord(handOverVO.getSourceId(), dataModelingQSGarbage);
            }
        }
        catch (ModelParseException e) {
            throw new HandOverException(e);
        }
        catch (ScheduleEngineException e) {
            throw new HandOverException(e);
        }
        catch (ScheduleModelParseException e) {
            throw new HandOverException(e);
        }
        catch (EncryptedLicenseCheckException e) {
            throw new HandOverEncryptedLicenseException(e.getMessage(), e.getErrorCode());
        }
    }

    public void updateLappPublishThumbnailSchedule(PublishPO publishPO, String toUserId) throws HandOverException, AbstractQingIntegratedException, SQLException {
        block9: {
            try {
                Schedule schedule;
                String publishId = publishPO.getId();
                ThumbnailInfo thumbnailInfo = this.getThumbnailDomain().loadThumbnailInfoByPublishId(publishId);
                if (thumbnailInfo == null || (schedule = thumbnailInfo.getSchedule()) == null || schedule.getPeriod() == null) break block9;
                String analysisId = thumbnailInfo.getAnalysisId();
                String publishName = publishPO.getName();
                this.deleteSchedule(analysisId);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("JobType", "updateLappThumbnail");
                params.put("analysisId", analysisId);
                params.put("userId", toUserId);
                params.put("publishId", publishId);
                params.put("publishName", publishName);
                AbstractJobParam jobParams = this.scheduleEngine.createJobParam(params);
                try {
                    this.scheduleEngine.saveJob(this.qingContext, toUserId, this.qingContext.getSystemVarStringValue(SystemVarType.ORG_ID), this.qingContext.getTenantId(), null, schedule, jobParams);
                }
                catch (AbstractQingIntegratedException e) {
                    throw new HandOverException(e);
                }
                catch (ScheduleEngineException e) {
                    throw new HandOverException(e);
                }
                catch (ScheduleModelParseException e) {
                    throw new HandOverException(e);
                }
            }
            catch (com.kingdee.bos.qing.core.exception.PersistentModelParseException e1) {
                throw new HandOverException(e1);
            }
            catch (PersistentModelTooModernException e1) {
                throw new HandOverException(e1);
            }
            catch (PublishScheduleModelException e1) {
                throw new HandOverException(e1);
            }
            catch (PublishNotFoundException e1) {
                throw new HandOverException(e1);
            }
        }
    }

    public void updateEmailPushSchedule(EmailConfig emailConfig, String publishedRuntimeUrl, String toUserId) throws HandOverException {
        Schedule schedule = emailConfig.getSchedule();
        if (emailConfig.getScheduleSwitch() && schedule != null && schedule.getPeriod() != null) {
            this.deleteSchedule(emailConfig.getId());
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("JobType", "emailPublishExecute");
            params.put("pkId", emailConfig.getId());
            params.put("sourceName", emailConfig.getNameRule().getName());
            params.put("sourceId", emailConfig.getId());
            params.put("publishedRuntimeUrl", publishedRuntimeUrl);
            AbstractJobParam jobParams = this.scheduleEngine.createJobParam(params);
            String scheduleName = this.scheduleEngine.getScheduleName();
            try {
                this.scheduleEngine.saveJob(this.qingContext, toUserId, this.qingContext.getSystemVarStringValue(SystemVarType.ORG_ID), this.qingContext.getTenantId(), scheduleName, schedule, jobParams);
            }
            catch (AbstractQingIntegratedException e) {
                throw new HandOverException(e);
            }
            catch (ScheduleEngineException e) {
                throw new HandOverException(e);
            }
            catch (ScheduleModelParseException e) {
                throw new HandOverException(e);
            }
        }
    }

    public void updateLappPushSchedule(LappSchedulePushConfigModel pushConfigModel, String paramPathPrefix, String toUserId) throws HandOverException {
        Schedule schedule = pushConfigModel.getSchedule();
        if (pushConfigModel.isOpenSchedule() && schedule != null && schedule.getPeriod() != null) {
            this.deleteSchedule(pushConfigModel.getId());
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("JobType", "pushExecute");
            params.put("pkId", pushConfigModel.getId());
            params.put("sourceName", pushConfigModel.getName());
            params.put("sourceId", pushConfigModel.getId());
            params.put("paramPathPrefix", paramPathPrefix);
            AbstractJobParam jobParams = this.scheduleEngine.createJobParam(params);
            String scheduleName = this.scheduleEngine.getScheduleName();
            try {
                this.scheduleEngine.saveJob(this.qingContext, toUserId, this.qingContext.getSystemVarStringValue(SystemVarType.ORG_ID), this.qingContext.getTenantId(), scheduleName, schedule, jobParams);
            }
            catch (AbstractQingIntegratedException e) {
                throw new HandOverException(e);
            }
            catch (ScheduleEngineException e) {
                throw new HandOverException(e);
            }
            catch (ScheduleModelParseException e) {
                throw new HandOverException(e);
            }
        }
    }

    public List<HandOverRecordOperationVO> loadUnReadHandOverOperationRecord(String messageId, String isread) throws AbstractQingIntegratedException, SQLException, HandOverException {
        List<HandOverRecordOperationVO> handOverRecordOperations = this.getHandOverDao().loadUnReadHandOverOperationRecord(messageId, isread);
        ArrayList<String> messageIdList = new ArrayList<String>(10);
        for (HandOverRecordOperationVO handOverRecordOperationVO : handOverRecordOperations) {
            handOverRecordOperationVO.setHandOverRecordDatas(this.getHandOverDao().loadHandOverRecordDataByOperationId(handOverRecordOperationVO.getOperationId()));
            messageIdList.add(handOverRecordOperationVO.getMessageId());
        }
        if (handOverRecordOperations.size() == 0) {
            return handOverRecordOperations;
        }
        try {
            this.getMessageDomain().updateToHasReadByReceiverIdAndBizType(this.qingContext.getUserId(), messageIdList);
        }
        catch (MessageException e) {
            throw new HandOverException(e);
        }
        return handOverRecordOperations;
    }

    private void cleanList(List<HandOverVO> handOvers) {
        for (int i = handOvers.size() - 1; i >= 0; --i) {
            HandOverVO handOverVO = handOvers.get(i);
            if (PublishSourceEnum.extreport.toString().equals(handOverVO.getPubSourceType())) {
                handOvers.remove(i);
                continue;
            }
            if (!this.isThemeHandOverVO(handOverVO)) continue;
            for (int j = i + 1; j < handOvers.size(); ++j) {
                HandOverVO handOverVO2 = handOvers.get(j);
                if (!this.isSameSource(handOverVO2, handOverVO)) continue;
                handOvers.remove(i);
            }
        }
    }

    private boolean isThemeHandOverVO(HandOverVO handOverVO) {
        return StringUtils.isEmpty((CharSequence)handOverVO.getPubId()) && StringUtils.isEmpty((CharSequence)handOverVO.getPublishToType()) && StringUtils.isEmpty((CharSequence)handOverVO.getPubSourceType()) && StringUtils.isEmpty((CharSequence)handOverVO.getPubPath());
    }

    private boolean isSameSource(HandOverVO handOverVO1, HandOverVO handOverVO2) {
        return handOverVO2.getSourceCreatorId().equals(handOverVO1.getSourceCreatorId()) && handOverVO2.getSourceType().equals(handOverVO1.getSourceType()) && handOverVO2.getSourceId().equals(handOverVO1.getSourceId());
    }
}

