/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.manage.imexport.collector.dashboard;

import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.filesystem.manager.CopyWriteCall;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IWriteCall;
import com.kingdee.bos.qing.filesystem.manager.model.QingAppLocalTempFileType;
import com.kingdee.bos.qing.manage.exception.ImportThemeException;
import com.kingdee.bos.qing.manage.imexport.collector.ICollectable;
import com.kingdee.bos.qing.manage.imexport.collector.util.ImportUtil;
import com.kingdee.bos.qing.manage.imexport.model.runtime.AbstractThemeImportModel;
import com.kingdee.bos.qing.manage.imexport.model.runtime.DashboardImportModel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipInputStream;

public class DsbWidgetSchemaCollecor
implements ICollectable {
    public static final RefTypeEnum refType = RefTypeEnum.subject;

    @Override
    public void collect(ZipInputStream zis, String[] zipEntryPath, AbstractThemeImportModel exportThemeCollectModel) throws ImportThemeException {
        DashboardImportModel dashboardImportModel = (DashboardImportModel)exportThemeCollectModel;
        List<String> schemaFileKeys = dashboardImportModel.getFileKeys(refType);
        if (schemaFileKeys == null) {
            schemaFileKeys = new ArrayList<String>();
            dashboardImportModel.setFileKeys(refType, schemaFileKeys);
        }
        try {
            byte[] dsbSchemaContent = ImportUtil.getBytesFromZipInputStream(zis);
            IQingFile qingFile = FileFactory.newAppLocalTempFile((QingAppLocalTempFileType)QingAppLocalTempFileType.LOCAL_TEMP);
            String fileKey = qingFile.getName();
            qingFile.write((IWriteCall)new CopyWriteCall((InputStream)new ByteArrayInputStream(dsbSchemaContent), false), true);
            schemaFileKeys.add(fileKey);
        }
        catch (IOException e) {
            throw new ImportThemeException(e);
        }
    }
}

