/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.manage.imexport.collector.subject;

import com.kingdee.bos.qing.manage.exception.ImportThemeException;
import com.kingdee.bos.qing.manage.imexport.collector.ICollectable;
import com.kingdee.bos.qing.manage.imexport.collector.util.ImportUtil;
import com.kingdee.bos.qing.manage.imexport.model.po.subject.ExportSchemaProperty;
import com.kingdee.bos.qing.manage.imexport.model.runtime.AbstractThemeImportModel;
import com.kingdee.bos.qing.manage.imexport.model.runtime.SubjectImportModel;
import com.kingdee.bos.qing.manage.imexport.model.runtime.SubjectSchemaImportModel;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.zip.ZipInputStream;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class SubjectSchemaPropertyCollector
implements ICollectable {
    @Override
    public void collect(ZipInputStream zis, String[] zipEntryPath, AbstractThemeImportModel exportThemeCollectModel) throws ImportThemeException {
        String schemaKey;
        SubjectSchemaImportModel schemaImportModel;
        SubjectImportModel subjectCollectModel = (SubjectImportModel)exportThemeCollectModel;
        LinkedHashMap<String, SubjectSchemaImportModel> schemaImportModels = subjectCollectModel.getSchemaImportModels();
        if (schemaImportModels == null) {
            schemaImportModels = new LinkedHashMap();
            subjectCollectModel.setSchemaImportModels(schemaImportModels);
        }
        if ((schemaImportModel = schemaImportModels.get(schemaKey = zipEntryPath[3] + "/" + zipEntryPath[4])) == null) {
            schemaImportModel = new SubjectSchemaImportModel();
            schemaImportModels.put(schemaKey, schemaImportModel);
        }
        try {
            ExportSchemaProperty schemaProperty = this.parseSchemaProperty(zis, zipEntryPath);
            schemaImportModel.setSchemaProperty(schemaProperty);
        }
        catch (JDOMException e) {
            throw new ImportThemeException(e);
        }
        catch (IOException e) {
            throw new ImportThemeException(e);
        }
    }

    private ExportSchemaProperty parseSchemaProperty(ZipInputStream zis, String[] zipEntryPath) throws JDOMException, IOException {
        Element schemaPropertyElement = XmlUtil.loadRootElement((InputStream)ImportUtil.getInputStreamFromZipInputStream(zis));
        ExportSchemaProperty schemaProperty = new ExportSchemaProperty();
        schemaProperty.fromXml(schemaPropertyElement);
        String schemaName = zipEntryPath[4];
        if (schemaProperty.getId() == null && schemaProperty.getName() == null) {
            schemaProperty.setName(schemaName);
        }
        return schemaProperty;
    }
}

