/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.map;

import com.kingdee.bos.qing.common.context.IQingContextable;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBAccessable;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.map.designer.model.DesigntimeMapModel;
import com.kingdee.bos.qing.map.domain.MapDesignerDomain;
import com.kingdee.bos.qing.response.IResponseWrap;
import com.kingdee.bos.qing.response.ResponseSuccessWrap;
import com.kingdee.bos.qing.response.ResponseUtil;
import com.kingdee.bos.qing.service.MapDesignerService;
import com.kingdee.bos.qing.util.JsonUtil;
import java.util.Map;

public class MapDesignerServiceImpl
extends MapDesignerService
implements IQingContextable,
IDBAccessable {
    private QingContext context;
    private ITransactionManagement tx;
    private IDBExcuter dbExcuter;
    private MapDesignerDomain mapDomain;

    public void setQingContext(QingContext qingContext) {
        this.context = qingContext;
    }

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void setTx(ITransactionManagement tx) {
        this.tx = tx;
    }

    private MapDesignerDomain getMapDomain() {
        if (this.mapDomain == null) {
            this.mapDomain = new MapDesignerDomain();
            this.mapDomain.setDbExcuter(this.dbExcuter);
            this.mapDomain.setTx(this.tx);
            this.mapDomain.setQingContext(this.context);
        }
        return this.mapDomain;
    }

    public byte[] loadMap(Map<String, String> params) {
        try {
            String mapId = params.get("mapId");
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)this.getMapDomain().loadMap(mapId)));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] saveMap(Map<String, String> params) {
        try {
            String mapModelJson = params.get("model");
            String mapId = params.get("mapId");
            DesigntimeMapModel mapModel = (DesigntimeMapModel)JsonUtil.decodeFromString((String)mapModelJson, DesigntimeMapModel.class);
            this.getMapDomain().saveMap(mapModel, mapId);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)true));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }
}

