/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.preparedata.handler;

import com.kingdee.bos.qing.preparedata.exception.PrepareDataException;
import com.kingdee.bos.qing.preparedata.handler.AbstractPrepareDataHandler;
import com.kingdee.bos.qing.preparedata.handler.dsbref.DsbRefPrepareDataHandler;
import com.kingdee.bos.qing.preparedata.handler.publish.PublishedPrepareDataHandler;
import com.kingdee.bos.qing.preparedata.handler.subject.SubjectPrepareDataHandler;
import com.kingdee.bos.qing.preparedata.handler.timingpush.EmailTimingPushPrepareDataHandler;
import com.kingdee.bos.qing.preparedata.handler.timingpush.RobotTimingPushPrepareDataHandler;
import com.kingdee.bos.qing.preparedata.preparedatacontext.IPrepareDataContext;
import com.kingdee.bos.qing.preparedata.task.FromType;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public class PrepareDataHandlerFactory {
    private static Map<FromType, Class<? extends AbstractPrepareDataHandler>> handlerMap = new HashMap<FromType, Class<? extends AbstractPrepareDataHandler>>();

    public static void registerHandler(FromType fromType, Class<? extends AbstractPrepareDataHandler> clazz) {
        if (handlerMap.get((Object)fromType) == null) {
            handlerMap.put(fromType, clazz);
        }
    }

    public static AbstractPrepareDataHandler newPrepareHandlerInstance(FromType fromType, IPrepareDataContext prepareDataContext) throws PrepareDataException {
        Class<? extends AbstractPrepareDataHandler> clazz = handlerMap.get((Object)fromType);
        if (null == clazz) {
            throw new RuntimeException("unknown formtype:" + (Object)((Object)fromType));
        }
        try {
            Constructor<? extends AbstractPrepareDataHandler> con = clazz.getConstructor(IPrepareDataContext.class);
            return con.newInstance(prepareDataContext);
        }
        catch (Exception e) {
            throw new PrepareDataException("create data prepare instance error:" + (Object)((Object)fromType), e);
        }
    }

    static {
        handlerMap.put(FromType.subject, SubjectPrepareDataHandler.class);
        handlerMap.put(FromType.publish, PublishedPrepareDataHandler.class);
        handlerMap.put(FromType.dsbRef, DsbRefPrepareDataHandler.class);
        handlerMap.put(FromType.timingPushEmail, EmailTimingPushPrepareDataHandler.class);
        handlerMap.put(FromType.timingPushRobot, RobotTimingPushPrepareDataHandler.class);
    }
}

